/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity.memory;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;

public final class CraftMemoryMapper {
    private CraftMemoryMapper() {
    }

    public static Object fromNms(Object object) {
        if (object instanceof GlobalPos) {
            return CraftMemoryMapper.fromNms((GlobalPos)object);
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof UUID) {
            return (UUID)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new UnsupportedOperationException("Do not know how to map " + String.valueOf(object));
    }

    public static Object toNms(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Location) {
            return CraftMemoryMapper.toNms((Location)object);
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof UUID) {
            return (UUID)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new UnsupportedOperationException("Do not know how to map " + String.valueOf(object));
    }

    public static Location fromNms(GlobalPos globalPos) {
        return new Location((World)((CraftServer)Bukkit.getServer()).getServer().getLevel(globalPos.dimension()).getWorld(), (double)globalPos.pos().getX(), (double)globalPos.pos().getY(), (double)globalPos.pos().getZ());
    }

    public static GlobalPos toNms(Location location) {
        return GlobalPos.of(((CraftWorld)location.getWorld()).getHandle().dimension(), BlockPos.containing(location.getX(), location.getY(), location.getZ()));
    }
}

