/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.enchantments;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.enchantments.EnchantmentRarity;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.enchantment.Enchantment;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.legacy.FieldRename;
import org.bukkit.craftbukkit.util.ApiVersion;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.entity.EntityCategory;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;

public class CraftEnchantment
extends org.bukkit.enchantments.Enchantment
implements Handleable<Enchantment> {
    private final NamespacedKey key;
    private final Holder<Enchantment> handle;
    private final int id;

    public static org.bukkit.enchantments.Enchantment minecraftToBukkit(Enchantment minecraft) {
        return (org.bukkit.enchantments.Enchantment)CraftRegistry.minecraftToBukkit(minecraft, Registries.ENCHANTMENT, Registry.ENCHANTMENT);
    }

    public static org.bukkit.enchantments.Enchantment minecraftHolderToBukkit(Holder<Enchantment> minecraft) {
        return CraftEnchantment.minecraftToBukkit(minecraft.value());
    }

    public static Enchantment bukkitToMinecraft(org.bukkit.enchantments.Enchantment bukkit) {
        return (Enchantment)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static Holder<Enchantment> bukkitToMinecraftHolder(org.bukkit.enchantments.Enchantment bukkit) {
        return CraftRegistry.bukkitToMinecraftHolder(bukkit, Registries.ENCHANTMENT);
    }

    public static String bukkitToString(org.bukkit.enchantments.Enchantment bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.getKey().toString();
    }

    public static org.bukkit.enchantments.Enchantment stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        string = FieldRename.convertEnchantmentName(ApiVersion.CURRENT, string);
        string = string.toLowerCase(Locale.ROOT);
        NamespacedKey key = NamespacedKey.fromString((String)string);
        return (org.bukkit.enchantments.Enchantment)CraftRegistry.get(Registry.ENCHANTMENT, key, ApiVersion.CURRENT);
    }

    public CraftEnchantment(NamespacedKey key, Enchantment handle) {
        this.key = key;
        this.handle = CraftRegistry.getMinecraftRegistry(Registries.ENCHANTMENT).wrapAsHolder(handle);
        this.id = CraftRegistry.getMinecraftRegistry(Registries.ENCHANTMENT).getId(handle);
    }

    @Override
    public Enchantment getHandle() {
        return this.handle.value();
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public int getMaxLevel() {
        return this.getHandle().getMaxLevel();
    }

    public int getStartLevel() {
        return this.getHandle().getMinLevel();
    }

    public EnchantmentTarget getItemTarget() {
        throw new UnsupportedOperationException("Method no longer applicable. Use Tags instead.");
    }

    public boolean isTreasure() {
        return this.handle.is(EnchantmentTags.TREASURE);
    }

    public boolean isCursed() {
        return this.handle.is(EnchantmentTags.CURSE);
    }

    public boolean canEnchantItem(ItemStack item) {
        return this.getHandle().canEnchant(CraftItemStack.asNMSCopy(item));
    }

    public String getName() {
        return switch (this.id) {
            case 0 -> "PROTECTION_ENVIRONMENTAL";
            case 1 -> "PROTECTION_FIRE";
            case 2 -> "PROTECTION_FALL";
            case 3 -> "PROTECTION_EXPLOSIONS";
            case 4 -> "PROTECTION_PROJECTILE";
            case 5 -> "OXYGEN";
            case 6 -> "WATER_WORKER";
            case 7 -> "THORNS";
            case 8 -> "DEPTH_STRIDER";
            case 9 -> "FROST_WALKER";
            case 10 -> "BINDING_CURSE";
            case 11 -> "SOUL_SPEED";
            case 12 -> "SWIFT_SNEAK";
            case 13 -> "DAMAGE_ALL";
            case 14 -> "DAMAGE_UNDEAD";
            case 15 -> "DAMAGE_ARTHROPODS";
            case 16 -> "KNOCKBACK";
            case 17 -> "FIRE_ASPECT";
            case 18 -> "LOOT_BONUS_MOBS";
            case 19 -> "SWEEPING_EDGE";
            case 20 -> "DIG_SPEED";
            case 21 -> "SILK_TOUCH";
            case 22 -> "DURABILITY";
            case 23 -> "LOOT_BONUS_BLOCKS";
            case 24 -> "ARROW_DAMAGE";
            case 25 -> "ARROW_KNOCKBACK";
            case 26 -> "ARROW_FIRE";
            case 27 -> "ARROW_INFINITE";
            case 28 -> "LUCK";
            case 29 -> "LURE";
            case 30 -> "LOYALTY";
            case 31 -> "IMPALING";
            case 32 -> "RIPTIDE";
            case 33 -> "CHANNELING";
            case 34 -> "MULTISHOT";
            case 35 -> "QUICK_CHARGE";
            case 36 -> "PIERCING";
            case 37 -> "DENSITY";
            case 38 -> "BREACH";
            case 39 -> "WIND_BURST";
            case 40 -> "MENDING";
            case 41 -> "VANISHING_CURSE";
            default -> this.getKey().toString();
        };
    }

    public boolean conflictsWith(org.bukkit.enchantments.Enchantment other) {
        if (other instanceof EnchantmentWrapper) {
            other = ((EnchantmentWrapper)other).getEnchantment();
        }
        if (!(other instanceof CraftEnchantment)) {
            return false;
        }
        CraftEnchantment ench = (CraftEnchantment)other;
        return !Enchantment.areCompatible(this.handle, ench.handle);
    }

    public Component displayName(int level) {
        return PaperAdventure.asAdventure(Enchantment.getFullname(this.handle, level));
    }

    public String translationKey() {
        ComponentContents componentContents = this.getHandle().description().getContents();
        if (!(componentContents instanceof TranslatableContents)) {
            throw new UnsupportedOperationException("Description isn't translatable!");
        }
        TranslatableContents translatableContents = (TranslatableContents)componentContents;
        return translatableContents.getKey();
    }

    public boolean isTradeable() {
        return this.handle.is(EnchantmentTags.TRADEABLE);
    }

    public boolean isDiscoverable() {
        return this.handle.is(EnchantmentTags.IN_ENCHANTING_TABLE) || this.handle.is(EnchantmentTags.ON_RANDOM_LOOT) || this.handle.is(EnchantmentTags.ON_MOB_SPAWN_EQUIPMENT) || this.handle.is(EnchantmentTags.TRADEABLE) || this.handle.is(EnchantmentTags.ON_TRADED_EQUIPMENT);
    }

    public int getMinModifiedCost(int level) {
        return this.getHandle().definition().minCost().calculate(level);
    }

    public int getMaxModifiedCost(int level) {
        return this.getHandle().definition().maxCost().calculate(level);
    }

    public int getAnvilCost() {
        return this.getHandle().definition().anvilCost();
    }

    public EnchantmentRarity getRarity() {
        throw new UnsupportedOperationException("Enchantments don't have a rarity anymore in 1.20.5+.");
    }

    public float getDamageIncrease(int level, EntityCategory entityCategory) {
        throw new UnsupportedOperationException("Enchantments are based on complex effect maps since 1.21, cannot compute a simple damage increase");
    }

    public float getDamageIncrease(int level, EntityType entityType) {
        throw new UnsupportedOperationException("Enchantments are based on complex effect maps since 1.21, cannot compute a simple damage increase");
    }

    public Set<EquipmentSlotGroup> getActiveSlotGroups() {
        return this.getHandle().definition().slots().stream().map(CraftEquipmentSlot::getSlot).collect(Collectors.toSet());
    }

    public String getTranslationKey() {
        return Util.makeDescriptionId("enchantment", this.handle.unwrapKey().get().location());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftEnchantment)) {
            return false;
        }
        return this.getKey().equals((Object)((org.bukkit.enchantments.Enchantment)other).getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "CraftEnchantment[" + String.valueOf(this.getKey()) + "]";
    }
}

