/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Furnace;
import org.bukkit.craftbukkit.block.CraftContainer;
import org.bukkit.craftbukkit.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Recipe;

public abstract class CraftFurnace<T extends AbstractFurnaceBlockEntity>
extends CraftContainer<T>
implements Furnace {
    public CraftFurnace(World world, T tileEntity) {
        super(world, tileEntity);
    }

    protected CraftFurnace(CraftFurnace<T> state, Location location) {
        super(state, location);
    }

    public FurnaceInventory getSnapshotInventory() {
        return new CraftInventoryFurnace((AbstractFurnaceBlockEntity)this.getSnapshot());
    }

    public FurnaceInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryFurnace((AbstractFurnaceBlockEntity)this.getTileEntity());
    }

    public short getBurnTime() {
        return (short)((AbstractFurnaceBlockEntity)this.getSnapshot()).litTime;
    }

    public void setBurnTime(short burnTime) {
        ((AbstractFurnaceBlockEntity)this.getSnapshot()).litTime = burnTime;
        this.data = (BlockState)this.data.setValue(AbstractFurnaceBlock.LIT, burnTime > 0);
    }

    public short getCookTime() {
        return (short)((AbstractFurnaceBlockEntity)this.getSnapshot()).cookingProgress;
    }

    public void setCookTime(short cookTime) {
        ((AbstractFurnaceBlockEntity)this.getSnapshot()).cookingProgress = cookTime;
    }

    public int getCookTimeTotal() {
        return ((AbstractFurnaceBlockEntity)this.getSnapshot()).cookingTotalTime;
    }

    public void setCookTimeTotal(int cookTimeTotal) {
        ((AbstractFurnaceBlockEntity)this.getSnapshot()).cookingTotalTime = cookTimeTotal;
    }

    public Map<CookingRecipe<?>, Integer> getRecipesUsed() {
        ImmutableMap.Builder recipesUsed = ImmutableMap.builder();
        for (Map.Entry entrySet : ((AbstractFurnaceBlockEntity)this.getSnapshot()).getRecipesUsed().object2IntEntrySet()) {
            Recipe recipe = Bukkit.getRecipe((NamespacedKey)CraftNamespacedKey.fromMinecraft((ResourceLocation)entrySet.getKey()));
            if (!(recipe instanceof CookingRecipe)) continue;
            CookingRecipe cookingRecipe = (CookingRecipe)recipe;
            recipesUsed.put((Object)cookingRecipe, (Object)((Integer)entrySet.getValue()));
        }
        return recipesUsed.build();
    }

    @Override
    public abstract CraftFurnace<T> copy();

    @Override
    public abstract CraftFurnace<T> copy(Location var1);

    public double getCookSpeedMultiplier() {
        return ((AbstractFurnaceBlockEntity)this.getSnapshot()).cookSpeedMultiplier;
    }

    public void setCookSpeedMultiplier(double multiplier) {
        Preconditions.checkArgument((multiplier >= 0.0 ? 1 : 0) != 0, (Object)"Furnace speed multiplier cannot be negative");
        Preconditions.checkArgument((multiplier <= 200.0 ? 1 : 0) != 0, (Object)"Furnace speed multiplier cannot more than 200");
        AbstractFurnaceBlockEntity snapshot = (AbstractFurnaceBlockEntity)this.getSnapshot();
        snapshot.cookSpeedMultiplier = multiplier;
        snapshot.cookingTotalTime = AbstractFurnaceBlockEntity.getTotalCookTime(this.isPlaced() ? this.world.getHandle() : null, snapshot.recipeType, snapshot, snapshot.cookSpeedMultiplier);
    }

    public int getRecipeUsedCount(NamespacedKey furnaceRecipe) {
        return ((AbstractFurnaceBlockEntity)this.getSnapshot()).getRecipesUsed().getInt((Object)CraftNamespacedKey.toMinecraft(furnaceRecipe));
    }

    public boolean hasRecipeUsedCount(NamespacedKey furnaceRecipe) {
        return ((AbstractFurnaceBlockEntity)this.getSnapshot()).getRecipesUsed().containsKey((Object)CraftNamespacedKey.toMinecraft(furnaceRecipe));
    }

    public void setRecipeUsedCount(CookingRecipe<?> furnaceRecipe, int count) {
        ResourceLocation location = CraftNamespacedKey.toMinecraft(furnaceRecipe.getKey());
        Optional<RecipeHolder<?>> nmsRecipe = (this.isPlaced() ? this.world.getHandle().getRecipeManager() : MinecraftServer.getServer().getRecipeManager()).byKey(location);
        Preconditions.checkArgument((nmsRecipe.isPresent() && nmsRecipe.get().value() instanceof AbstractCookingRecipe ? 1 : 0) != 0, (Object)(String.valueOf(furnaceRecipe.getKey()) + " is not recognized as a valid and registered furnace recipe"));
        if (count > 0) {
            ((AbstractFurnaceBlockEntity)this.getSnapshot()).getRecipesUsed().put((Object)location, count);
        } else {
            ((AbstractFurnaceBlockEntity)this.getSnapshot()).getRecipesUsed().removeInt((Object)location);
        }
    }

    public void setRecipesUsed(Map<CookingRecipe<?>, Integer> recipesUsed) {
        ((AbstractFurnaceBlockEntity)this.getSnapshot()).getRecipesUsed().clear();
        recipesUsed.forEach((recipe, integer) -> {
            if (integer != null) {
                this.setRecipeUsedCount((CookingRecipe<?>)recipe, (int)integer);
            }
        });
    }
}

