/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.ban;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.SharedPlayerProfile;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import org.bukkit.BanEntry;
import org.bukkit.ban.ProfileBanList;
import org.bukkit.craftbukkit.ban.CraftProfileBanEntry;

public class CraftProfileBanList
implements ProfileBanList {
    private final UserBanList list;

    public CraftProfileBanList(UserBanList list) {
        this.list = list;
    }

    public BanEntry<PlayerProfile> getBanEntry(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.getBanEntry(CraftProfileBanList.getProfile(target));
    }

    public BanEntry<PlayerProfile> getBanEntry(org.bukkit.profile.PlayerProfile target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.getBanEntry(((SharedPlayerProfile)target).buildGameProfile());
    }

    public BanEntry<PlayerProfile> getBanEntry(PlayerProfile target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"target cannot be null");
        return this.getBanEntry(((SharedPlayerProfile)target).buildGameProfile());
    }

    public BanEntry<PlayerProfile> addBan(PlayerProfile target, String reason, Date expires, String source) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"PlayerProfile cannot be null");
        Preconditions.checkArgument((target.getId() != null ? 1 : 0) != 0, (Object)"The PlayerProfile UUID cannot be null");
        return this.addBan(((SharedPlayerProfile)target).buildGameProfile(), reason, expires, source);
    }

    public boolean isBanned(PlayerProfile target) {
        return this.isBanned((SharedPlayerProfile)target);
    }

    public void pardon(PlayerProfile target) {
        this.pardon((SharedPlayerProfile)target);
    }

    public BanEntry<PlayerProfile> addBan(PlayerProfile target, String reason, Instant expires, String source) {
        Date date = expires != null ? Date.from(expires) : null;
        return this.addBan(target, reason, date, source);
    }

    public BanEntry<PlayerProfile> addBan(PlayerProfile target, String reason, Duration duration, String source) {
        Instant instant = duration != null ? Instant.now().plus(duration) : null;
        return this.addBan(target, reason, instant, source);
    }

    public BanEntry<PlayerProfile> addBan(String target, String reason, Date expires, String source) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Ban target cannot be null");
        return this.addBan(CraftProfileBanList.getProfileByName(target), reason, expires, source);
    }

    public BanEntry<PlayerProfile> addBan(org.bukkit.profile.PlayerProfile target, String reason, Date expires, String source) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"PlayerProfile cannot be null");
        Preconditions.checkArgument((target.getUniqueId() != null ? 1 : 0) != 0, (Object)"The PlayerProfile UUID cannot be null");
        return this.addBan(((SharedPlayerProfile)target).buildGameProfile(), reason, expires, source);
    }

    public BanEntry<PlayerProfile> addBan(org.bukkit.profile.PlayerProfile target, String reason, Instant expires, String source) {
        Date date = expires != null ? Date.from(expires) : null;
        return this.addBan(target, reason, date, source);
    }

    public BanEntry<PlayerProfile> addBan(org.bukkit.profile.PlayerProfile target, String reason, Duration duration, String source) {
        Instant instant = duration != null ? Instant.now().plus(duration) : null;
        return this.addBan(target, reason, instant, source);
    }

    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (UserBanListEntry entry : this.list.getEntries()) {
            GameProfile profile = (GameProfile)entry.getUser();
            builder.add((Object)new CraftProfileBanEntry(profile, entry, this.list));
        }
        return builder.build();
    }

    public Set<BanEntry<PlayerProfile>> getEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (UserBanListEntry entry : this.list.getEntries()) {
            GameProfile profile = (GameProfile)entry.getUser();
            builder.add((Object)new CraftProfileBanEntry(profile, entry, this.list));
        }
        return builder.build();
    }

    public boolean isBanned(org.bukkit.profile.PlayerProfile target) {
        return this.isBanned((SharedPlayerProfile)target);
    }

    private boolean isBanned(SharedPlayerProfile target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.isBanned(target.buildGameProfile());
    }

    public boolean isBanned(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.isBanned(CraftProfileBanList.getProfile(target));
    }

    public void pardon(org.bukkit.profile.PlayerProfile target) {
        this.pardon((SharedPlayerProfile)target);
    }

    private void pardon(SharedPlayerProfile target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        this.pardon(target.buildGameProfile());
    }

    public void pardon(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        this.pardon(CraftProfileBanList.getProfile(target));
    }

    public BanEntry<PlayerProfile> getBanEntry(GameProfile profile) {
        if (profile == null) {
            return null;
        }
        UserBanListEntry entry = (UserBanListEntry)this.list.get(profile);
        if (entry == null) {
            return null;
        }
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    public BanEntry<PlayerProfile> addBan(GameProfile profile, String reason, Date expires, String source) {
        if (profile == null) {
            return null;
        }
        UserBanListEntry entry = new UserBanListEntry(profile, new Date(), source == null || source.isBlank() ? null : source, expires, reason == null || reason.isBlank() ? null : reason);
        this.list.add(entry);
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    private void pardon(GameProfile profile) {
        this.list.remove(profile);
    }

    private boolean isBanned(GameProfile profile) {
        return profile != null && this.list.isBanned(profile);
    }

    static GameProfile getProfile(String target) {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(target);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return uuid != null ? CraftProfileBanList.getProfileByUUID(uuid) : CraftProfileBanList.getProfileByName(target);
    }

    static GameProfile getProfileByUUID(UUID uuid) {
        return MinecraftServer.getServer() != null ? (GameProfile)MinecraftServer.getServer().getProfileCache().get(uuid).orElse(null) : null;
    }

    static GameProfile getProfileByName(String name) {
        return MinecraftServer.getServer() != null ? (GameProfile)MinecraftServer.getServer().getProfileCache().get(name).orElse(null) : null;
    }
}

