/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.PlayerScores;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class Scoreboard {
    public static final String HIDDEN_SCORE_PREFIX = "#";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Object2ObjectMap<String, Objective> objectivesByName = new Object2ObjectOpenHashMap(16, 0.5f);
    private final Reference2ObjectMap<ObjectiveCriteria, List<Objective>> objectivesByCriteria = new Reference2ObjectOpenHashMap();
    private final Map<String, PlayerScores> playerScores = new Object2ObjectOpenHashMap(16, 0.5f);
    private final Map<DisplaySlot, Objective> displayObjectives = new EnumMap<DisplaySlot, Objective>(DisplaySlot.class);
    private final Object2ObjectMap<String, PlayerTeam> teamsByName = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, PlayerTeam> teamsByPlayer = new Object2ObjectOpenHashMap();

    @Nullable
    public Objective getObjective(@Nullable String name) {
        return (Objective)this.objectivesByName.get((Object)name);
    }

    public Objective addObjective(String name, ObjectiveCriteria criterion, Component displayName, ObjectiveCriteria.RenderType renderType, boolean displayAutoUpdate, @Nullable NumberFormat numberFormat) {
        if (this.objectivesByName.containsKey((Object)name)) {
            throw new IllegalArgumentException("An objective with the name '" + name + "' already exists!");
        }
        Objective objective = new Objective(this, name, criterion, displayName, renderType, displayAutoUpdate, numberFormat);
        ((List)this.objectivesByCriteria.computeIfAbsent((Object)criterion, criterion2 -> Lists.newArrayList())).add(objective);
        this.objectivesByName.put((Object)name, (Object)objective);
        this.onObjectiveAdded(objective);
        return objective;
    }

    public final void forAllObjectives(ObjectiveCriteria criterion, ScoreHolder scoreHolder, Consumer<ScoreAccess> action) {
        ((List)this.objectivesByCriteria.getOrDefault((Object)criterion, Collections.emptyList())).forEach(objective -> action.accept(this.getOrCreatePlayerScore(scoreHolder, (Objective)objective, true)));
    }

    private PlayerScores getOrCreatePlayerInfo(String scoreHolderName) {
        return this.playerScores.computeIfAbsent(scoreHolderName, name -> new PlayerScores());
    }

    public ScoreAccess getOrCreatePlayerScore(ScoreHolder scoreHolder, Objective objective) {
        return this.getOrCreatePlayerScore(scoreHolder, objective, false);
    }

    public ScoreAccess getOrCreatePlayerScore(final ScoreHolder scoreHolder, final Objective objective, boolean forceWritable) {
        final boolean bl = forceWritable || !objective.getCriteria().isReadOnly();
        PlayerScores playerScores = this.getOrCreatePlayerInfo(scoreHolder.getScoreboardName());
        final MutableBoolean mutableBoolean = new MutableBoolean();
        final Score score2 = playerScores.getOrCreate(objective, score -> mutableBoolean.setTrue());
        return new ScoreAccess(){

            @Override
            @Override
            public int get() {
                return score2.value();
            }

            @Override
            @Override
            public void set(int score) {
                Component component;
                if (!bl) {
                    throw new IllegalStateException("Cannot modify read-only score");
                }
                boolean bl2 = mutableBoolean.isTrue();
                if (objective.displayAutoUpdate() && (component = scoreHolder.getDisplayName()) != null && !component.equals(score2.display())) {
                    score2.display(component);
                    bl2 = true;
                }
                if (score != score2.value()) {
                    score2.value(score);
                    bl2 = true;
                }
                if (bl2) {
                    this.sendScoreToPlayers();
                }
            }

            @Override
            @Nullable
            @Override
            public Component display() {
                return score2.display();
            }

            @Override
            @Override
            public void display(@Nullable Component text) {
                if (mutableBoolean.isTrue() || !Objects.equals(text, score2.display())) {
                    score2.display(text);
                    this.sendScoreToPlayers();
                }
            }

            @Override
            @Override
            public void numberFormatOverride(@Nullable NumberFormat numberFormat) {
                score2.numberFormat(numberFormat);
                this.sendScoreToPlayers();
            }

            @Override
            @Override
            public boolean locked() {
                return score2.isLocked();
            }

            @Override
            @Override
            public void unlock() {
                this.setLocked(false);
            }

            @Override
            @Override
            public void lock() {
                this.setLocked(true);
            }

            private void setLocked(boolean locked) {
                score2.setLocked(locked);
                if (mutableBoolean.isTrue()) {
                    this.sendScoreToPlayers();
                }
                Scoreboard.this.onScoreLockChanged(scoreHolder, objective);
            }

            private void sendScoreToPlayers() {
                Scoreboard.this.onScoreChanged(scoreHolder, objective, score2);
                mutableBoolean.setFalse();
            }
        };
    }

    @Nullable
    public ReadOnlyScoreInfo getPlayerScoreInfo(ScoreHolder scoreHolder, Objective objective) {
        PlayerScores playerScores = this.playerScores.get(scoreHolder.getScoreboardName());
        if (playerScores != null) {
            return playerScores.get(objective);
        }
        return null;
    }

    public Collection<PlayerScoreEntry> listPlayerScores(Objective objective) {
        ArrayList<PlayerScoreEntry> list = new ArrayList<PlayerScoreEntry>();
        this.playerScores.forEach((scoreHolderName, scores) -> {
            Score score = scores.get(objective);
            if (score != null) {
                list.add(new PlayerScoreEntry((String)scoreHolderName, score.value(), score.display(), score.numberFormat()));
            }
        });
        return list;
    }

    public Collection<Objective> getObjectives() {
        return this.objectivesByName.values();
    }

    public Collection<String> getObjectiveNames() {
        return this.objectivesByName.keySet();
    }

    public Collection<ScoreHolder> getTrackedPlayers() {
        return this.playerScores.keySet().stream().map(ScoreHolder::forNameOnly).toList();
    }

    public void resetAllPlayerScores(ScoreHolder scoreHolder) {
        PlayerScores playerScores = this.playerScores.remove(scoreHolder.getScoreboardName());
        if (playerScores != null) {
            this.onPlayerRemoved(scoreHolder);
        }
    }

    public void resetSinglePlayerScore(ScoreHolder scoreHolder, Objective objective) {
        PlayerScores playerScores = this.playerScores.get(scoreHolder.getScoreboardName());
        if (playerScores != null) {
            boolean bl = playerScores.remove(objective);
            if (!playerScores.hasScores()) {
                PlayerScores playerScores2 = this.playerScores.remove(scoreHolder.getScoreboardName());
                if (playerScores2 != null) {
                    this.onPlayerRemoved(scoreHolder);
                }
            } else if (bl) {
                this.onPlayerScoreRemoved(scoreHolder, objective);
            }
        }
    }

    public Object2IntMap<Objective> listPlayerScores(ScoreHolder scoreHolder) {
        PlayerScores playerScores = this.playerScores.get(scoreHolder.getScoreboardName());
        return playerScores != null ? playerScores.listScores() : Object2IntMaps.emptyMap();
    }

    public void removeObjective(Objective objective) {
        this.objectivesByName.remove((Object)objective.getName());
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            if (this.getDisplayObjective(displaySlot) != objective) continue;
            this.setDisplayObjective(displaySlot, null);
        }
        List list = (List)this.objectivesByCriteria.get((Object)objective.getCriteria());
        if (list != null) {
            list.remove(objective);
        }
        for (PlayerScores playerScores : this.playerScores.values()) {
            playerScores.remove(objective);
        }
        this.onObjectiveRemoved(objective);
    }

    public void setDisplayObjective(DisplaySlot slot, @Nullable Objective objective) {
        this.displayObjectives.put(slot, objective);
    }

    @Nullable
    public Objective getDisplayObjective(DisplaySlot slot) {
        return this.displayObjectives.get(slot);
    }

    @Nullable
    public PlayerTeam getPlayerTeam(String name) {
        return (PlayerTeam)this.teamsByName.get((Object)name);
    }

    public PlayerTeam addPlayerTeam(String name) {
        PlayerTeam playerTeam = this.getPlayerTeam(name);
        if (playerTeam != null) {
            LOGGER.warn("Requested creation of existing team '{}'", (Object)name);
            return playerTeam;
        }
        playerTeam = new PlayerTeam(this, name);
        this.teamsByName.put((Object)name, (Object)playerTeam);
        this.onTeamAdded(playerTeam);
        return playerTeam;
    }

    public void removePlayerTeam(PlayerTeam team) {
        this.teamsByName.remove((Object)team.getName());
        for (String string : team.getPlayers()) {
            this.teamsByPlayer.remove((Object)string);
        }
        this.onTeamRemoved(team);
    }

    public boolean addPlayerToTeam(String scoreHolderName, PlayerTeam team) {
        if (this.getPlayersTeam(scoreHolderName) != null) {
            this.removePlayerFromTeam(scoreHolderName);
        }
        this.teamsByPlayer.put((Object)scoreHolderName, (Object)team);
        return team.getPlayers().add(scoreHolderName);
    }

    public boolean removePlayerFromTeam(String scoreHolderName) {
        PlayerTeam playerTeam = this.getPlayersTeam(scoreHolderName);
        if (playerTeam != null) {
            this.removePlayerFromTeam(scoreHolderName, playerTeam);
            return true;
        }
        return false;
    }

    public void removePlayerFromTeam(String scoreHolderName, PlayerTeam team) {
        if (this.getPlayersTeam(scoreHolderName) != team) {
            throw new IllegalStateException("Player is either on another team or not on any team. Cannot remove from team '" + team.getName() + "'.");
        }
        this.teamsByPlayer.remove((Object)scoreHolderName);
        team.getPlayers().remove(scoreHolderName);
    }

    public Collection<String> getTeamNames() {
        return this.teamsByName.keySet();
    }

    public Collection<PlayerTeam> getPlayerTeams() {
        return this.teamsByName.values();
    }

    @Nullable
    public PlayerTeam getPlayersTeam(String scoreHolderName) {
        return (PlayerTeam)this.teamsByPlayer.get((Object)scoreHolderName);
    }

    public void onObjectiveAdded(Objective objective) {
    }

    public void onObjectiveChanged(Objective objective) {
    }

    public void onObjectiveRemoved(Objective objective) {
    }

    protected void onScoreChanged(ScoreHolder scoreHolder, Objective objective, Score score) {
    }

    protected void onScoreLockChanged(ScoreHolder scoreHolder, Objective objective) {
    }

    public void onPlayerRemoved(ScoreHolder scoreHolder) {
    }

    public void onPlayerScoreRemoved(ScoreHolder scoreHolder, Objective objective) {
    }

    public void onTeamAdded(PlayerTeam team) {
    }

    public void onTeamChanged(PlayerTeam team) {
    }

    public void onTeamRemoved(PlayerTeam team) {
    }

    public void entityRemoved(Entity entity) {
        if (entity instanceof Player || entity.isAlive()) {
            return;
        }
        this.resetAllPlayerScores(entity);
        this.removePlayerFromTeam(entity.getScoreboardName());
    }

    protected ListTag savePlayerScores(HolderLookup.Provider registries) {
        ListTag listTag = new ListTag();
        this.playerScores.forEach((name, scores) -> scores.listRawScores().forEach((objective, score) -> {
            CompoundTag compoundTag = score.write(registries);
            compoundTag.putString("Name", (String)name);
            compoundTag.putString("Objective", objective.getName());
            listTag.add(compoundTag);
        }));
        return listTag;
    }

    protected void loadPlayerScores(ListTag list, HolderLookup.Provider registries) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag compoundTag = list.getCompound(i);
            Score score = Score.read(compoundTag, registries);
            String string = compoundTag.getString("Name");
            String string2 = compoundTag.getString("Objective");
            Objective objective = this.getObjective(string2);
            if (objective == null) {
                LOGGER.error("Unknown objective {} for name {}, ignoring", (Object)string2, (Object)string);
                continue;
            }
            this.getOrCreatePlayerInfo(string).setScore(objective, score);
        }
    }
}

