/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.timers;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.primitives.UnsignedLong;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.timers.TimerCallback;
import net.minecraft.world.level.timers.TimerCallbacks;
import org.slf4j.Logger;

public class TimerQueue<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String CALLBACK_DATA_TAG = "Callback";
    private static final String TIMER_NAME_TAG = "Name";
    private static final String TIMER_TRIGGER_TIME_TAG = "TriggerTime";
    private final TimerCallbacks<T> callbacksRegistry;
    private final Queue<Event<T>> queue = new PriorityQueue<Event<T>>(TimerQueue.createComparator());
    private UnsignedLong sequentialId = UnsignedLong.ZERO;
    private final Table<String, Long, Event<T>> events = HashBasedTable.create();

    private static <T> Comparator<Event<T>> createComparator() {
        return Comparator.comparingLong(event -> event.triggerTime).thenComparing(event -> event.sequentialId);
    }

    public TimerQueue(TimerCallbacks<T> timerCallbackSerializer, Stream<? extends Dynamic<?>> nbts) {
        this(timerCallbackSerializer);
        this.queue.clear();
        this.events.clear();
        this.sequentialId = UnsignedLong.ZERO;
        nbts.forEach(nbt -> {
            Tag tag = nbt.convert(NbtOps.INSTANCE).getValue();
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                this.loadEvent(compoundTag);
            } else {
                LOGGER.warn("Invalid format of events: {}", (Object)tag);
            }
        });
    }

    public TimerQueue(TimerCallbacks<T> timerCallbackSerializer) {
        this.callbacksRegistry = timerCallbackSerializer;
    }

    public void tick(T server, long time) {
        Event<T> event;
        while ((event = this.queue.peek()) != null && event.triggerTime <= time) {
            this.queue.remove();
            this.events.remove((Object)event.id, (Object)time);
            event.callback.handle(server, this, time);
        }
    }

    public void schedule(String name, long triggerTime, TimerCallback<T> callback) {
        if (this.events.contains((Object)name, (Object)triggerTime)) {
            return;
        }
        this.sequentialId = this.sequentialId.plus(UnsignedLong.ONE);
        Event<T> event = new Event<T>(triggerTime, this.sequentialId, name, callback);
        this.events.put((Object)name, (Object)triggerTime, event);
        this.queue.add(event);
    }

    public int remove(String name) {
        Collection collection = this.events.row((Object)name).values();
        collection.forEach(this.queue::remove);
        int i = collection.size();
        collection.clear();
        return i;
    }

    public Set<String> getEventsIds() {
        return Collections.unmodifiableSet(this.events.rowKeySet());
    }

    private void loadEvent(CompoundTag nbt) {
        CompoundTag compoundTag = nbt.getCompound(CALLBACK_DATA_TAG);
        TimerCallback<T> timerCallback = this.callbacksRegistry.deserialize(compoundTag);
        if (timerCallback != null) {
            String string = nbt.getString(TIMER_NAME_TAG);
            long l = nbt.getLong(TIMER_TRIGGER_TIME_TAG);
            this.schedule(string, l, timerCallback);
        }
    }

    private CompoundTag storeEvent(Event<T> event) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString(TIMER_NAME_TAG, event.id);
        compoundTag.putLong(TIMER_TRIGGER_TIME_TAG, event.triggerTime);
        compoundTag.put(CALLBACK_DATA_TAG, this.callbacksRegistry.serialize(event.callback));
        return compoundTag;
    }

    public ListTag store() {
        ListTag listTag = new ListTag();
        this.queue.stream().sorted(TimerQueue.createComparator()).map(this::storeEvent).forEach(listTag::add);
        return listTag;
    }

    public static class Event<T> {
        public final long triggerTime;
        public final UnsignedLong sequentialId;
        public final String id;
        public final TimerCallback<T> callback;

        Event(long triggerTime, UnsignedLong id, String name, TimerCallback<T> callback) {
            this.triggerTime = triggerTime;
            this.sequentialId = id;
            this.id = name;
            this.callback = callback;
        }
    }
}

