/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.world.level.storage.loot.entries.ComposableEntryContainer;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class EntryGroup
extends CompositeEntryBase {
    public static final MapCodec<EntryGroup> CODEC = EntryGroup.createCodec(EntryGroup::new);

    EntryGroup(List<LootPoolEntryContainer> terms, List<LootItemCondition> conditions) {
        super(terms, conditions);
    }

    @Override
    @Override
    public LootPoolEntryType getType() {
        return LootPoolEntries.GROUP;
    }

    @Override
    @Override
    protected ComposableEntryContainer compose(List<? extends ComposableEntryContainer> terms) {
        return switch (terms.size()) {
            case 0 -> ALWAYS_TRUE;
            case 1 -> terms.get(0);
            case 2 -> {
                ComposableEntryContainer composableEntryContainer = terms.get(0);
                ComposableEntryContainer composableEntryContainer2 = terms.get(1);
                yield (context, choiceConsumer) -> {
                    composableEntryContainer.expand(context, choiceConsumer);
                    composableEntryContainer2.expand(context, choiceConsumer);
                    return true;
                };
            }
            default -> (context, lootChoiceExpander) -> {
                for (ComposableEntryContainer composableEntryContainer : terms) {
                    composableEntryContainer.expand(context, lootChoiceExpander);
                }
                return true;
            };
        };
    }

    public static Builder list(LootPoolEntryContainer.Builder<?> ... entries) {
        return new Builder(entries);
    }

    public static class Builder
    extends LootPoolEntryContainer.Builder<Builder> {
        private final ImmutableList.Builder<LootPoolEntryContainer> entries = ImmutableList.builder();

        public Builder(LootPoolEntryContainer.Builder<?> ... entries) {
            for (LootPoolEntryContainer.Builder<?> builder : entries) {
                this.entries.add((Object)builder.build());
            }
        }

        @Override
        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        @Override
        public Builder append(LootPoolEntryContainer.Builder<?> entry) {
            this.entries.add((Object)entry.build());
            return this;
        }

        @Override
        @Override
        public LootPoolEntryContainer build() {
            return new EntryGroup((List<LootPoolEntryContainer>)this.entries.build(), this.getConditions());
        }

        @Override
        protected /* synthetic */ LootPoolEntryContainer.Builder getThis() {
            return this.getThis();
        }
    }
}

