/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.Heightmap;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.util.BlockStateListPopulator;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class PortalForcer {
    public static final int TICKET_RADIUS = 3;
    private static final int NETHER_PORTAL_RADIUS = 16;
    private static final int OVERWORLD_PORTAL_RADIUS = 128;
    private static final int FRAME_HEIGHT = 5;
    private static final int FRAME_WIDTH = 4;
    private static final int FRAME_BOX = 3;
    private static final int FRAME_HEIGHT_START = -1;
    private static final int FRAME_HEIGHT_END = 4;
    private static final int FRAME_WIDTH_START = -1;
    private static final int FRAME_WIDTH_END = 3;
    private static final int FRAME_BOX_START = -1;
    private static final int FRAME_BOX_END = 2;
    private static final int NOTHING_FOUND = -1;
    private final ServerLevel level;

    public PortalForcer(ServerLevel world) {
        this.level = world;
    }

    @DoNotUse
    public Optional<BlockPos> findClosestPortalPosition(BlockPos pos, boolean destIsNether, WorldBorder worldBorder) {
        return this.findClosestPortalPosition(pos, worldBorder, destIsNether ? 16 : 128);
    }

    public Optional<BlockPos> findClosestPortalPosition(BlockPos blockposition, WorldBorder worldborder, int i) {
        PoiManager villageplace = this.level.getPoiManager();
        villageplace.ensureLoadedAndValid(this.level, blockposition, i);
        Stream<BlockPos> stream = villageplace.getInSquare(holder -> holder.is(PoiTypes.NETHER_PORTAL), blockposition, i, PoiManager.Occupancy.ANY).map(PoiRecord::getPos);
        Objects.requireNonNull(worldborder);
        return stream.filter(worldborder::isWithinBounds).filter(pos -> this.level.getTypeKey() != LevelStem.NETHER || !this.level.paperConfig().environment.netherCeilingVoidDamageHeight.test(v -> pos.getY() >= v)).filter(blockposition1 -> this.level.getBlockState((BlockPos)blockposition1).hasProperty(BlockStateProperties.HORIZONTAL_AXIS)).min(Comparator.comparingDouble(blockposition1 -> blockposition1.distSqr(blockposition)).thenComparingInt(Vec3i::getY));
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(BlockPos pos, Direction.Axis axis) {
        return this.createPortal(pos, axis, null, 16);
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(BlockPos blockposition, Direction.Axis enumdirection_enumaxis, net.minecraft.world.entity.Entity entity, int createRadius) {
        int i1;
        int l;
        int k;
        int j;
        Direction enumdirection = Direction.get(Direction.AxisDirection.POSITIVE, enumdirection_enumaxis);
        double d0 = -1.0;
        BlockPos blockposition1 = null;
        double d1 = -1.0;
        BlockPos blockposition2 = null;
        WorldBorder worldborder = this.level.getWorldBorder();
        int i = Math.min(this.level.getMaxBuildHeight(), this.level.getMinBuildHeight() + this.level.getLogicalHeight()) - 1;
        if (this.level.getTypeKey() == LevelStem.NETHER && this.level.paperConfig().environment.netherCeilingVoidDamageHeight.enabled()) {
            i = Math.min(i, this.level.paperConfig().environment.netherCeilingVoidDamageHeight.intValue() - 1);
        }
        boolean flag = true;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = blockposition.mutable();
        for (BlockPos.MutableBlockPos blockposition_mutableblockposition1 : BlockPos.spiralAround(blockposition, createRadius, Direction.EAST, Direction.SOUTH)) {
            j = Math.min(i, this.level.getHeight(Heightmap.Types.MOTION_BLOCKING, blockposition_mutableblockposition1.getX(), blockposition_mutableblockposition1.getZ()));
            if (!worldborder.isWithinBounds(blockposition_mutableblockposition1) || !worldborder.isWithinBounds(blockposition_mutableblockposition1.move(enumdirection, 1))) continue;
            blockposition_mutableblockposition1.move(enumdirection.getOpposite(), 1);
            for (k = j; k >= this.level.getMinBuildHeight(); --k) {
                blockposition_mutableblockposition1.setY(k);
                if (!this.canPortalReplaceBlock(blockposition_mutableblockposition1)) continue;
                l = k;
                while (k > this.level.getMinBuildHeight() && this.canPortalReplaceBlock(blockposition_mutableblockposition1.move(Direction.DOWN))) {
                    --k;
                }
                if (k + 4 > i || (i1 = l - k) > 0 && i1 < 3) continue;
                blockposition_mutableblockposition1.setY(k);
                if (!this.canHostFrame(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, 0)) continue;
                double d2 = blockposition.distSqr(blockposition_mutableblockposition1);
                if (this.canHostFrame(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, -1) && this.canHostFrame(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockposition1 = blockposition_mutableblockposition1.immutable();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockposition2 = blockposition_mutableblockposition1.immutable();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockposition1 = blockposition2;
            d0 = d1;
        }
        BlockStateListPopulator blockList = new BlockStateListPopulator(this.level);
        if (d0 == -1.0) {
            int k1 = i - 9;
            int j1 = Math.max(this.level.getMinBuildHeight() - -1, 70);
            if (k1 < j1) {
                return Optional.empty();
            }
            blockposition1 = new BlockPos(blockposition.getX() - enumdirection.getStepX() * 1, Mth.clamp(blockposition.getY(), j1, k1), blockposition.getZ() - enumdirection.getStepZ() * 1).immutable();
            blockposition1 = worldborder.clampToBounds(blockposition1);
            Direction enumdirection1 = enumdirection.getClockWise();
            for (k = -1; k < 2; ++k) {
                for (l = 0; l < 2; ++l) {
                    for (i1 = -1; i1 < 3; ++i1) {
                        BlockState iblockdata = i1 < 0 ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.AIR.defaultBlockState();
                        blockposition_mutableblockposition.setWithOffset(blockposition1, l * enumdirection.getStepX() + k * enumdirection1.getStepX(), i1, l * enumdirection.getStepZ() + k * enumdirection1.getStepZ());
                        blockList.setBlock(blockposition_mutableblockposition, iblockdata, 3);
                    }
                }
            }
        }
        for (int j1 = -1; j1 < 3; ++j1) {
            for (int k1 = -1; k1 < 4; ++k1) {
                if (j1 != -1 && j1 != 2 && k1 != -1 && k1 != 3) continue;
                blockposition_mutableblockposition.setWithOffset(blockposition1, j1 * enumdirection.getStepX(), k1, j1 * enumdirection.getStepZ());
                blockList.setBlock(blockposition_mutableblockposition, Blocks.OBSIDIAN.defaultBlockState(), 3);
            }
        }
        BlockState iblockdata1 = (BlockState)Blocks.NETHER_PORTAL.defaultBlockState().setValue(NetherPortalBlock.AXIS, enumdirection_enumaxis);
        for (int k1 = 0; k1 < 2; ++k1) {
            for (j = 0; j < 3; ++j) {
                blockposition_mutableblockposition.setWithOffset(blockposition1, k1 * enumdirection.getStepX(), j, k1 * enumdirection.getStepZ());
                blockList.setBlock(blockposition_mutableblockposition, iblockdata1, 18);
            }
        }
        CraftWorld bworld = this.level.getWorld();
        PortalCreateEvent event = new PortalCreateEvent(blockList.getList(), (World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.NETHER_PAIR);
        this.level.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return Optional.empty();
        }
        blockList.updateList();
        return Optional.of(new BlockUtil.FoundRectangle(blockposition1.immutable(), 2, 3));
    }

    private boolean canPortalReplaceBlock(BlockPos.MutableBlockPos pos) {
        BlockState iblockdata = this.level.getBlockState(pos);
        return iblockdata.canBeReplaced() && iblockdata.getFluidState().isEmpty();
    }

    private boolean canHostFrame(BlockPos pos, BlockPos.MutableBlockPos temp, Direction portalDirection, int distanceOrthogonalToPortal) {
        Direction enumdirection1 = portalDirection.getClockWise();
        for (int j = -1; j < 3; ++j) {
            for (int k = -1; k < 4; ++k) {
                temp.setWithOffset(pos, portalDirection.getStepX() * j + enumdirection1.getStepX() * distanceOrthogonalToPortal, k, portalDirection.getStepZ() * j + enumdirection1.getStepZ() * distanceOrthogonalToPortal);
                if (!GlobalConfiguration.get().unsupportedSettings.allowPermanentBlockBreakExploits && !this.level.getBlockState(temp).isDestroyable()) {
                    return false;
                }
                if (k < 0 && !this.level.getBlockState(temp).isSolid()) {
                    return false;
                }
                if (k < 0 || this.canPortalReplaceBlock(temp)) continue;
                return false;
            }
        }
        return true;
    }
}

