/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.player.PlayerTeleportEvent;

public record DimensionTransition(ServerLevel newLevel, Vec3 pos, Vec3 speed, float yRot, float xRot, boolean missingRespawnBlock, PostDimensionTransition postDimensionTransition, PlayerTeleportEvent.TeleportCause cause) {
    public static final PostDimensionTransition DO_NOTHING = entity -> {};
    public static final PostDimensionTransition PLAY_PORTAL_SOUND = DimensionTransition::playPortalSound;
    public static final PostDimensionTransition PLACE_PORTAL_TICKET = DimensionTransition::placePortalTicket;

    public DimensionTransition(ServerLevel newLevel, Vec3 pos, Vec3 speed, float yRot, float xRot, boolean missingRespawnBlock, PostDimensionTransition postDimensionTransition) {
        this(newLevel, pos, speed, yRot, xRot, missingRespawnBlock, postDimensionTransition, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public DimensionTransition(PlayerTeleportEvent.TeleportCause cause) {
        this(null, Vec3.ZERO, Vec3.ZERO, 0.0f, 0.0f, false, DO_NOTHING, cause);
    }

    public DimensionTransition(ServerLevel world, Vec3 pos, Vec3 velocity, float yaw, float pitch, PostDimensionTransition postDimensionTransition) {
        this(world, pos, velocity, yaw, pitch, postDimensionTransition, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public DimensionTransition(ServerLevel worldserver, Vec3 vec3d, Vec3 vec3d1, float f, float f1, PostDimensionTransition dimensiontransition_a, PlayerTeleportEvent.TeleportCause cause) {
        this(worldserver, vec3d, vec3d1, f, f1, false, dimensiontransition_a, cause);
    }

    public DimensionTransition(ServerLevel world, Entity entity, PostDimensionTransition postDimensionTransition) {
        this(world, entity, postDimensionTransition, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public DimensionTransition(ServerLevel worldserver, Entity entity, PostDimensionTransition dimensiontransition_a, PlayerTeleportEvent.TeleportCause cause) {
        this(worldserver, DimensionTransition.findAdjustedSharedSpawnPos(worldserver, entity), Vec3.ZERO, worldserver.getSharedSpawnAngle(), 0.0f, false, dimensiontransition_a, cause);
    }

    private static void playPortalSound(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entity;
            entityplayer.connection.send(new ClientboundLevelEventPacket(1032, BlockPos.ZERO, 0, false));
        }
    }

    private static void placePortalTicket(Entity entity) {
        entity.placePortalTicket(BlockPos.containing(entity.position()));
    }

    public static DimensionTransition missingRespawnBlock(ServerLevel world, Entity entity, PostDimensionTransition postDimensionTransition) {
        return new DimensionTransition(world, DimensionTransition.findAdjustedSharedSpawnPos(world, entity), Vec3.ZERO, world.getSharedSpawnAngle(), 0.0f, true, postDimensionTransition);
    }

    private static Vec3 findAdjustedSharedSpawnPos(ServerLevel world, Entity entity) {
        return entity.adjustSpawnLocation(world, world.getSharedSpawnPos()).getBottomCenter();
    }

    @FunctionalInterface
    public static interface PostDimensionTransition {
        public void onTransition(Entity var1);

        default public PostDimensionTransition then(PostDimensionTransition next) {
            return entity -> {
                this.onTransition(entity);
                next.onTransition(entity);
            };
        }
    }
}

