/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.Target;

public class PathFinder {
    private static final float FUDGING = 1.5f;
    private final Node[] neighbors = new Node[32];
    private final int maxVisitedNodes;
    public final NodeEvaluator nodeEvaluator;
    private static final boolean DEBUG = false;
    private final BinaryHeap openSet = new BinaryHeap();

    public PathFinder(NodeEvaluator pathNodeMaker, int range) {
        this.nodeEvaluator = pathNodeMaker;
        this.maxVisitedNodes = range;
    }

    @Nullable
    public Path findPath(PathNavigationRegion world, Mob mob, Set<BlockPos> positions, float followRange, int distance, float rangeMultiplier) {
        this.openSet.clear();
        this.nodeEvaluator.prepare(world, mob);
        Node node = this.nodeEvaluator.getStart();
        if (node == null) {
            return null;
        }
        ArrayList map = Lists.newArrayList();
        for (BlockPos pos : positions) {
            map.add(new AbstractMap.SimpleEntry<Target, BlockPos>(this.nodeEvaluator.getTarget(pos.getX(), pos.getY(), pos.getZ()), pos));
        }
        Path path = this.findPath(world.getProfiler(), node, map, followRange, distance, rangeMultiplier);
        this.nodeEvaluator.done();
        return path;
    }

    @Nullable
    private Path findPath(ProfilerFiller profiler, Node startNode, List<Map.Entry<Target, BlockPos>> positions, float followRange, int distance, float rangeMultiplier) {
        profiler.push("find_path");
        profiler.markForCharting(MetricCategory.PATH_FINDING);
        startNode.g = 0.0f;
        startNode.f = startNode.h = this.getBestH(startNode, positions);
        this.openSet.clear();
        this.openSet.insert(startNode);
        int i = 0;
        ArrayList entryList = Lists.newArrayListWithExpectedSize((int)positions.size());
        int j = (int)((float)this.maxVisitedNodes * rangeMultiplier);
        while (!this.openSet.isEmpty() && ++i < j) {
            Node node = this.openSet.pop();
            node.closed = true;
            for (int i1 = 0; i1 < positions.size(); ++i1) {
                Map.Entry entry = (Map.Entry)positions.get(i1);
                Target target = (Target)entry.getKey();
                if (!(node.distanceManhattan(target) <= (float)distance)) continue;
                target.setReached();
                entryList.add(entry);
            }
            if (!entryList.isEmpty()) break;
            if (node.distanceTo(startNode) >= followRange) continue;
            int k = this.nodeEvaluator.getNeighbors(this.neighbors, node);
            for (int l = 0; l < k; ++l) {
                Node node2 = this.neighbors[l];
                float f = this.distance(node, node2);
                node2.walkedDistance = node.walkedDistance + f;
                float g = node.g + f + node2.costMalus;
                if (!(node2.walkedDistance < followRange) || node2.inOpenSet() && !(g < node2.g)) continue;
                node2.cameFrom = node;
                node2.g = g;
                node2.h = this.getBestH(node2, positions) * 1.5f;
                if (node2.inOpenSet()) {
                    this.openSet.changeCost(node2, node2.g + node2.h);
                    continue;
                }
                node2.f = node2.g + node2.h;
                this.openSet.insert(node2);
            }
        }
        Path best = null;
        boolean entryListIsEmpty = entryList.isEmpty();
        Comparator<Path> comparator = entryListIsEmpty ? Comparator.comparingInt(Path::getNodeCount) : Comparator.comparingDouble(Path::getDistToTarget).thenComparingInt(Path::getNodeCount);
        for (Map.Entry entry : entryListIsEmpty ? positions : entryList) {
            Path path = this.reconstructPath(((Target)entry.getKey()).getBestNode(), (BlockPos)entry.getValue(), !entryListIsEmpty);
            if (best != null && comparator.compare(path, best) >= 0) continue;
            best = path;
        }
        profiler.pop();
        return best;
    }

    protected float distance(Node a, Node b) {
        return a.distanceTo(b);
    }

    private float getBestH(Node node, List<Map.Entry<Target, BlockPos>> targets) {
        float f = Float.MAX_VALUE;
        int targetsSize = targets.size();
        for (int i = 0; i < targetsSize; ++i) {
            Target target = targets.get(i).getKey();
            float g = node.distanceTo(target);
            target.updateBest(g, node);
            f = Math.min(g, f);
        }
        return f;
    }

    private Path reconstructPath(Node endNode, BlockPos target, boolean reachesTarget) {
        ArrayList list = Lists.newArrayList();
        Node node = endNode;
        list.add(0, endNode);
        while (node.cameFrom != null) {
            node = node.cameFrom;
            list.add(0, node);
        }
        return new Path(list, target, reachesTarget);
    }
}

