/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import java.util.Arrays;
import net.minecraft.world.level.pathfinder.Node;

public class BinaryHeap {
    private Node[] heap = new Node[128];
    private int size;

    public Node insert(Node node) {
        if (node.heapIdx >= 0) {
            throw new IllegalStateException("OW KNOWS!");
        }
        if (this.size == this.heap.length) {
            Node[] nodes = new Node[this.size << 1];
            System.arraycopy(this.heap, 0, nodes, 0, this.size);
            this.heap = nodes;
        }
        this.heap[this.size] = node;
        node.heapIdx = this.size;
        this.upHeap(this.size++);
        return node;
    }

    public void clear() {
        this.size = 0;
    }

    public Node peek() {
        return this.heap[0];
    }

    public Node pop() {
        Node node = this.heap[0];
        this.heap[0] = this.heap[--this.size];
        this.heap[this.size] = null;
        if (this.size > 0) {
            this.downHeap(0);
        }
        node.heapIdx = -1;
        return node;
    }

    public void remove(Node node) {
        this.heap[node.heapIdx] = this.heap[--this.size];
        this.heap[this.size] = null;
        if (this.size > node.heapIdx) {
            if (this.heap[node.heapIdx].f < node.f) {
                this.upHeap(node.heapIdx);
            } else {
                this.downHeap(node.heapIdx);
            }
        }
        node.heapIdx = -1;
    }

    public void changeCost(Node node, float weight) {
        float f = node.f;
        node.f = weight;
        if (weight < f) {
            this.upHeap(node.heapIdx);
        } else {
            this.downHeap(node.heapIdx);
        }
    }

    public int size() {
        return this.size;
    }

    private void upHeap(int index) {
        Node node = this.heap[index];
        float f = node.f;
        while (index > 0) {
            int i = index - 1 >> 1;
            Node node2 = this.heap[i];
            if (!(f < node2.f)) break;
            this.heap[index] = node2;
            node2.heapIdx = index;
            index = i;
        }
        this.heap[index] = node;
        node.heapIdx = index;
    }

    private void downHeap(int index) {
        Node node = this.heap[index];
        float f = node.f;
        while (true) {
            float k;
            Node node4;
            int i = 1 + (index << 1);
            int j = i + 1;
            if (i >= this.size) break;
            Node node2 = this.heap[i];
            float g = node2.f;
            if (j >= this.size) {
                Object node3 = null;
                float h = Float.POSITIVE_INFINITY;
            } else {
                node4 = this.heap[j];
                k = node4.f;
            }
            if (g < k) {
                if (!(g < f)) break;
                this.heap[index] = node2;
                node2.heapIdx = index;
                index = i;
                continue;
            }
            if (!(k < f)) break;
            this.heap[index] = node4;
            node4.heapIdx = index;
            index = j;
        }
        this.heap[index] = node;
        node.heapIdx = index;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Node[] getHeap() {
        return Arrays.copyOf(this.heap, this.size);
    }
}

