/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.DataLayerStorageMap;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;

public class SkyLightSectionStorage
extends LayerLightSectionStorage<SkyDataLayerStorageMap> {
    protected SkyLightSectionStorage(LightChunkGetter chunkProvider) {
        super(LightLayer.SKY, chunkProvider, new SkyDataLayerStorageMap((Long2ObjectOpenHashMap<DataLayer>)new Long2ObjectOpenHashMap(), new Long2IntOpenHashMap(), Integer.MAX_VALUE));
    }

    @Override
    @Override
    protected int getLightValue(long blockPos) {
        return this.getLightValue(blockPos, false);
    }

    protected int getLightValue(long blockPos, boolean cached) {
        long l = SectionPos.blockToSection(blockPos);
        int i = SectionPos.y(l);
        SkyDataLayerStorageMap skyDataLayerStorageMap = cached ? (SkyDataLayerStorageMap)this.updatingSectionData : (SkyDataLayerStorageMap)this.visibleSectionData;
        int j = skyDataLayerStorageMap.topSections.get(SectionPos.getZeroNode(l));
        if (j == skyDataLayerStorageMap.currentLowestY || i >= j) {
            if (cached && !this.lightOnInSection(l)) {
                return 0;
            }
            return 15;
        }
        DataLayer dataLayer = this.getDataLayer(skyDataLayerStorageMap, l);
        if (dataLayer == null) {
            blockPos = BlockPos.getFlatIndex(blockPos);
            while (dataLayer == null) {
                if (++i >= j) {
                    return 15;
                }
                l = SectionPos.offset(l, Direction.UP);
                dataLayer = this.getDataLayer(skyDataLayerStorageMap, l);
            }
        }
        return dataLayer.get(SectionPos.sectionRelative(BlockPos.getX(blockPos)), SectionPos.sectionRelative(BlockPos.getY(blockPos)), SectionPos.sectionRelative(BlockPos.getZ(blockPos)));
    }

    @Override
    @Override
    protected void onNodeAdded(long sectionPos) {
        long l;
        int j;
        int i = SectionPos.y(sectionPos);
        if (((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY > i) {
            ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY = i;
            ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.defaultReturnValue(((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY);
        }
        if ((j = ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(l = SectionPos.getZeroNode(sectionPos))) < i + 1) {
            ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.put(l, i + 1);
        }
    }

    @Override
    @Override
    protected void onNodeRemoved(long sectionPos) {
        long l = SectionPos.getZeroNode(sectionPos);
        int i = SectionPos.y(sectionPos);
        if (((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(l) == i + 1) {
            long m = sectionPos;
            while (!this.storingLightForSection(m) && this.hasLightDataAtOrBelow(i)) {
                --i;
                m = SectionPos.offset(m, Direction.DOWN);
            }
            if (this.storingLightForSection(m)) {
                ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.put(l, i + 1);
            } else {
                ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.remove(l);
            }
        }
    }

    @Override
    @Override
    protected DataLayer createDataLayer(long sectionPos) {
        DataLayer dataLayer2;
        DataLayer dataLayer = (DataLayer)this.queuedSections.get(sectionPos);
        if (dataLayer != null) {
            return dataLayer;
        }
        int i = ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(SectionPos.getZeroNode(sectionPos));
        if (i == ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY || SectionPos.y(sectionPos) >= i) {
            if (this.lightOnInSection(sectionPos)) {
                return new DataLayer(15);
            }
            return new DataLayer();
        }
        long l = SectionPos.offset(sectionPos, Direction.UP);
        while ((dataLayer2 = this.getDataLayer(l, true)) == null) {
            l = SectionPos.offset(l, Direction.UP);
        }
        return SkyLightSectionStorage.repeatFirstLayer(dataLayer2);
    }

    private static DataLayer repeatFirstLayer(DataLayer source) {
        if (source.isDefinitelyHomogenous()) {
            return source.copy();
        }
        byte[] bs = source.getData();
        byte[] cs = new byte[2048];
        for (int i = 0; i < 16; ++i) {
            System.arraycopy(bs, 0, cs, i * 128, 128);
        }
        return new DataLayer(cs);
    }

    protected boolean hasLightDataAtOrBelow(int sectionY) {
        return sectionY >= ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY;
    }

    protected boolean isAboveData(long sectionPos) {
        long l = SectionPos.getZeroNode(sectionPos);
        int i = ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(l);
        return i == ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY || SectionPos.y(sectionPos) >= i;
    }

    protected int getTopSectionY(long columnPos) {
        return ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(columnPos);
    }

    protected int getBottomSectionY() {
        return ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY;
    }

    protected static final class SkyDataLayerStorageMap
    extends DataLayerStorageMap<SkyDataLayerStorageMap> {
        int currentLowestY;
        final Long2IntOpenHashMap topSections;

        public SkyDataLayerStorageMap(Long2ObjectOpenHashMap<DataLayer> arrays, Long2IntOpenHashMap columnToTopSection, int minSectionY) {
            super(arrays);
            this.topSections = columnToTopSection;
            columnToTopSection.defaultReturnValue(minSectionY);
            this.currentLowestY = minSectionY;
        }

        @Override
        @Override
        public SkyDataLayerStorageMap copy() {
            return new SkyDataLayerStorageMap((Long2ObjectOpenHashMap<DataLayer>)this.map.clone(), this.topSections.clone(), this.currentLowestY);
        }

        @Override
        public /* synthetic */ DataLayerStorageMap copy() {
            return this.copy();
        }
    }
}

