/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.DataLayerStorageMap;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class LightEngine<M extends DataLayerStorageMap<M>, S extends LayerLightSectionStorage<M>>
implements LayerLightEventListener {
    public static final int MAX_LEVEL = 15;
    protected static final int MIN_OPACITY = 1;
    protected static final long PULL_LIGHT_IN_ENTRY = QueueEntry.decreaseAllDirections(1);
    private static final int MIN_QUEUE_SIZE = 512;
    protected static final Direction[] PROPAGATION_DIRECTIONS = Direction.values();
    protected final LightChunkGetter chunkSource;
    protected final S storage;
    private final LongOpenHashSet blockNodesToCheck = new LongOpenHashSet(512, 0.5f);
    private final LongArrayFIFOQueue decreaseQueue = new LongArrayFIFOQueue();
    private final LongArrayFIFOQueue increaseQueue = new LongArrayFIFOQueue();
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
    private static final int CACHE_SIZE = 2;
    private final long[] lastChunkPos = new long[2];
    private final LightChunk[] lastChunk = new LightChunk[2];

    protected LightEngine(LightChunkGetter chunkProvider, S lightStorage) {
        this.chunkSource = chunkProvider;
        this.storage = lightStorage;
        this.clearChunkCache();
    }

    public static boolean hasDifferentLightProperties(BlockGetter blockView, BlockPos pos, BlockState oldState, BlockState newState) {
        if (newState == oldState) {
            return false;
        }
        return newState.getLightBlock(blockView, pos) != oldState.getLightBlock(blockView, pos) || newState.getLightEmission() != oldState.getLightEmission() || newState.useShapeForLightOcclusion() || oldState.useShapeForLightOcclusion();
    }

    public static int getLightBlockInto(BlockGetter world, BlockState state1, BlockPos pos1, BlockState state2, BlockPos pos2, Direction direction, int opacity2) {
        VoxelShape voxelShape2;
        boolean bl = LightEngine.isEmptyShape(state1);
        boolean bl2 = LightEngine.isEmptyShape(state2);
        if (bl && bl2) {
            return opacity2;
        }
        VoxelShape voxelShape = bl ? Shapes.empty() : state1.getOcclusionShape(world, pos1);
        VoxelShape voxelShape3 = voxelShape2 = bl2 ? Shapes.empty() : state2.getOcclusionShape(world, pos2);
        if (Shapes.mergedFaceOccludes(voxelShape, voxelShape2, direction)) {
            return 16;
        }
        return opacity2;
    }

    public static VoxelShape getOcclusionShape(BlockGetter blockView, BlockPos pos, BlockState blockState, Direction direction) {
        return LightEngine.isEmptyShape(blockState) ? Shapes.empty() : blockState.getFaceOcclusionShape(blockView, pos, direction);
    }

    protected static boolean isEmptyShape(BlockState blockState) {
        return !blockState.canOcclude() || !blockState.useShapeForLightOcclusion();
    }

    protected BlockState getState(BlockPos pos) {
        int j;
        int i = SectionPos.blockToSectionCoord(pos.getX());
        LightChunk lightChunk = this.getChunk(i, j = SectionPos.blockToSectionCoord(pos.getZ()));
        if (lightChunk == null) {
            return Blocks.BEDROCK.defaultBlockState();
        }
        return lightChunk.getBlockState(pos);
    }

    protected int getOpacity(BlockState state, BlockPos pos) {
        return Math.max(1, state.getLightBlock(this.chunkSource.getLevel(), pos));
    }

    protected boolean shapeOccludes(long sourceId, BlockState sourceState, long targetId, BlockState targetState, Direction direction) {
        VoxelShape voxelShape = this.getOcclusionShape(sourceState, sourceId, direction);
        VoxelShape voxelShape2 = this.getOcclusionShape(targetState, targetId, direction.getOpposite());
        return Shapes.faceShapeOccludes(voxelShape, voxelShape2);
    }

    protected VoxelShape getOcclusionShape(BlockState blockState, long pos, Direction direction) {
        return LightEngine.getOcclusionShape(this.chunkSource.getLevel(), this.mutablePos.set(pos), blockState, direction);
    }

    @Nullable
    protected LightChunk getChunk(int chunkX, int chunkZ) {
        long l = ChunkPos.asLong(chunkX, chunkZ);
        for (int i = 0; i < 2; ++i) {
            if (l != this.lastChunkPos[i]) continue;
            return this.lastChunk[i];
        }
        LightChunk lightChunk = this.chunkSource.getChunkForLighting(chunkX, chunkZ);
        for (int j = 1; j > 0; --j) {
            this.lastChunkPos[j] = this.lastChunkPos[j - 1];
            this.lastChunk[j] = this.lastChunk[j - 1];
        }
        this.lastChunkPos[0] = l;
        this.lastChunk[0] = lightChunk;
        return lightChunk;
    }

    private void clearChunkCache() {
        Arrays.fill(this.lastChunkPos, ChunkPos.INVALID_CHUNK_POS);
        Arrays.fill(this.lastChunk, null);
    }

    @Override
    @Override
    public void checkBlock(BlockPos pos) {
        this.blockNodesToCheck.add(pos.asLong());
    }

    public void queueSectionData(long sectionPos, @Nullable DataLayer lightArray) {
        ((LayerLightSectionStorage)this.storage).queueSectionData(sectionPos, lightArray);
    }

    public void retainData(ChunkPos pos, boolean retainData) {
        ((LayerLightSectionStorage)this.storage).retainData(SectionPos.getZeroNode(pos.x, pos.z), retainData);
    }

    @Override
    @Override
    public void updateSectionStatus(SectionPos pos, boolean notReady) {
        ((LayerLightSectionStorage)this.storage).updateSectionStatus(pos.asLong(), notReady);
    }

    @Override
    @Override
    public void setLightEnabled(ChunkPos pos, boolean retainData) {
        ((LayerLightSectionStorage)this.storage).setLightEnabled(SectionPos.getZeroNode(pos.x, pos.z), retainData);
    }

    @Override
    @Override
    public int runLightUpdates() {
        LongIterator longIterator = this.blockNodesToCheck.iterator();
        while (longIterator.hasNext()) {
            this.checkNode(longIterator.nextLong());
        }
        this.blockNodesToCheck.clear();
        this.blockNodesToCheck.trim(512);
        int i = 0;
        i += this.propagateDecreases();
        this.clearChunkCache();
        ((LayerLightSectionStorage)this.storage).markNewInconsistencies(this);
        ((LayerLightSectionStorage)this.storage).swapSectionMap();
        return i += this.propagateIncreases();
    }

    private int propagateIncreases() {
        int i = 0;
        while (!this.increaseQueue.isEmpty()) {
            long l = this.increaseQueue.dequeueLong();
            long m = this.increaseQueue.dequeueLong();
            int j = ((LayerLightSectionStorage)this.storage).getStoredLevel(l);
            int k = QueueEntry.getFromLevel(m);
            if (QueueEntry.isIncreaseFromEmission(m) && j < k) {
                ((LayerLightSectionStorage)this.storage).setStoredLevel(l, k);
                j = k;
            }
            if (j == k) {
                this.propagateIncrease(l, m, j);
            }
            ++i;
        }
        return i;
    }

    private int propagateDecreases() {
        int i = 0;
        while (!this.decreaseQueue.isEmpty()) {
            long l = this.decreaseQueue.dequeueLong();
            long m = this.decreaseQueue.dequeueLong();
            this.propagateDecrease(l, m);
            ++i;
        }
        return i;
    }

    protected void enqueueDecrease(long blockPos, long flags) {
        this.decreaseQueue.enqueue(blockPos);
        this.decreaseQueue.enqueue(flags);
    }

    protected void enqueueIncrease(long blockPos, long flags) {
        this.increaseQueue.enqueue(blockPos);
        this.increaseQueue.enqueue(flags);
    }

    @Override
    @Override
    public boolean hasLightWork() {
        return ((LayerLightSectionStorage)this.storage).hasInconsistencies() || !this.blockNodesToCheck.isEmpty() || !this.decreaseQueue.isEmpty() || !this.increaseQueue.isEmpty();
    }

    @Override
    @Nullable
    @Override
    public DataLayer getDataLayerData(SectionPos pos) {
        return ((LayerLightSectionStorage)this.storage).getDataLayerData(pos.asLong());
    }

    @Override
    @Override
    public int getLightValue(BlockPos pos) {
        return ((LayerLightSectionStorage)this.storage).getLightValue(pos.asLong());
    }

    public String getDebugData(long sectionPos) {
        return this.getDebugSectionType(sectionPos).display();
    }

    public LayerLightSectionStorage.SectionType getDebugSectionType(long sectionPos) {
        return ((LayerLightSectionStorage)this.storage).getDebugSectionType(sectionPos);
    }

    protected abstract void checkNode(long var1);

    protected abstract void propagateIncrease(long var1, long var3, int var5);

    protected abstract void propagateDecrease(long var1, long var3);

    public static class QueueEntry {
        private static final int FROM_LEVEL_BITS = 4;
        private static final int DIRECTION_BITS = 6;
        private static final long LEVEL_MASK = 15L;
        private static final long DIRECTIONS_MASK = 1008L;
        private static final long FLAG_FROM_EMPTY_SHAPE = 1024L;
        private static final long FLAG_INCREASE_FROM_EMISSION = 2048L;

        public static long decreaseSkipOneDirection(int lightLevel, Direction direction) {
            long l = QueueEntry.withoutDirection(1008L, direction);
            return QueueEntry.withLevel(l, lightLevel);
        }

        public static long decreaseAllDirections(int lightLevel) {
            return QueueEntry.withLevel(1008L, lightLevel);
        }

        public static long increaseLightFromEmission(int lightLevel, boolean trivial) {
            long l = 1008L;
            l |= 0x800L;
            if (trivial) {
                l |= 0x400L;
            }
            return QueueEntry.withLevel(l, lightLevel);
        }

        public static long increaseSkipOneDirection(int lightLevel, boolean trivial, Direction direction) {
            long l = QueueEntry.withoutDirection(1008L, direction);
            if (trivial) {
                l |= 0x400L;
            }
            return QueueEntry.withLevel(l, lightLevel);
        }

        public static long increaseOnlyOneDirection(int lightLevel, boolean trivial, Direction direction) {
            long l = 0L;
            if (trivial) {
                l |= 0x400L;
            }
            l = QueueEntry.withDirection(l, direction);
            return QueueEntry.withLevel(l, lightLevel);
        }

        public static long increaseSkySourceInDirections(boolean down, boolean north, boolean south, boolean west, boolean east) {
            long l = QueueEntry.withLevel(0L, 15);
            if (down) {
                l = QueueEntry.withDirection(l, Direction.DOWN);
            }
            if (north) {
                l = QueueEntry.withDirection(l, Direction.NORTH);
            }
            if (south) {
                l = QueueEntry.withDirection(l, Direction.SOUTH);
            }
            if (west) {
                l = QueueEntry.withDirection(l, Direction.WEST);
            }
            if (east) {
                l = QueueEntry.withDirection(l, Direction.EAST);
            }
            return l;
        }

        public static int getFromLevel(long packed) {
            return (int)(packed & 0xFL);
        }

        public static boolean isFromEmptyShape(long packed) {
            return (packed & 0x400L) != 0L;
        }

        public static boolean isIncreaseFromEmission(long packed) {
            return (packed & 0x800L) != 0L;
        }

        public static boolean shouldPropagateInDirection(long packed, Direction direction) {
            return (packed & 1L << direction.ordinal() + 4) != 0L;
        }

        private static long withLevel(long packed, int lightLevel) {
            return packed & 0xFFFFFFFFFFFFFFF0L | (long)lightLevel & 0xFL;
        }

        private static long withDirection(long packed, Direction direction) {
            return packed | 1L << direction.ordinal() + 4;
        }

        private static long withoutDirection(long packed, Direction direction) {
            return packed & (1L << direction.ordinal() + 4 ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }
}

