/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import ca.spottedleaf.moonrise.patches.starlight.light.StarLightInterface;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightLightingProvider;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;
import net.minecraft.world.level.lighting.LightEventListener;

public class LevelLightEngine
implements LightEventListener,
StarLightLightingProvider {
    public static final int LIGHT_SECTION_PADDING = 1;
    protected final LevelHeightAccessor levelHeightAccessor;
    protected final StarLightInterface lightEngine;

    @Override
    public final StarLightInterface starlight$getLightEngine() {
        return this.lightEngine;
    }

    @Override
    public void starlight$clientUpdateLight(LightLayer lightType, SectionPos pos, DataLayer nibble, boolean trustEdges) {
        throw new IllegalStateException("This hook is for the CLIENT ONLY");
    }

    @Override
    public void starlight$clientRemoveLightData(ChunkPos chunkPos) {
        throw new IllegalStateException("This hook is for the CLIENT ONLY");
    }

    @Override
    public void starlight$clientChunkLoad(ChunkPos pos, LevelChunk chunk) {
        throw new IllegalStateException("This hook is for the CLIENT ONLY");
    }

    public LevelLightEngine(LightChunkGetter chunkProvider, boolean hasBlockLight, boolean hasSkyLight) {
        this.levelHeightAccessor = chunkProvider.getLevel();
        this.lightEngine = chunkProvider.getLevel() instanceof Level ? new StarLightInterface(chunkProvider, hasSkyLight, hasBlockLight, this) : new StarLightInterface(null, hasSkyLight, hasBlockLight, this);
    }

    @Override
    public void checkBlock(BlockPos pos) {
        this.lightEngine.blockChange(pos.immutable());
    }

    @Override
    public boolean hasLightWork() {
        return this.lightEngine.hasUpdates();
    }

    @Override
    public int runLightUpdates() {
        boolean hadUpdates = this.hasLightWork();
        this.lightEngine.propagateChanges();
        return hadUpdates ? 1 : 0;
    }

    @Override
    public void updateSectionStatus(SectionPos pos, boolean notReady) {
        this.lightEngine.sectionChange(pos, notReady);
    }

    @Override
    public void setLightEnabled(ChunkPos pos, boolean retainData) {
    }

    @Override
    public void propagateLightSources(ChunkPos chunkPos) {
    }

    public LayerLightEventListener getLayerListener(LightLayer lightType) {
        return lightType == LightLayer.BLOCK ? this.lightEngine.getBlockReader() : this.lightEngine.getSkyReader();
    }

    public String getDebugData(LightLayer lightType, SectionPos pos) {
        return "n/a";
    }

    public LayerLightSectionStorage.SectionType getDebugSectionType(LightLayer lightType, SectionPos pos) {
        throw new UnsupportedOperationException();
    }

    public void queueSectionData(LightLayer lightType, SectionPos pos, @Nullable DataLayer nibbles) {
    }

    public void retainData(ChunkPos pos, boolean retainData) {
    }

    public int getRawBrightness(BlockPos pos, int ambientDarkness) {
        return this.lightEngine.getRawBrightness(pos, ambientDarkness);
    }

    public boolean lightOnInSection(SectionPos sectionPos) {
        throw new UnsupportedOperationException();
    }

    public int getLightSectionCount() {
        return this.levelHeightAccessor.getSectionsCount() + 2;
    }

    public int getMinLightSection() {
        return this.levelHeightAccessor.getMinSection() - 1;
    }

    public int getMaxLightSection() {
        return this.getMinLightSection() + this.getLightSectionCount();
    }
}

