/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.function.LongPredicate;
import net.minecraft.util.Mth;
import net.minecraft.world.level.lighting.LeveledPriorityQueue;

public abstract class DynamicGraphMinFixedPoint {
    public static final long SOURCE = Long.MAX_VALUE;
    private static final int NO_COMPUTED_LEVEL = 255;
    protected final int levelCount;
    private final LeveledPriorityQueue priorityQueue;
    private final Long2ByteMap computedLevels;
    private volatile boolean hasWork;

    protected DynamicGraphMinFixedPoint(int levelCount, int expectedLevelSize, final int expectedTotalSize) {
        if (levelCount >= 254) {
            throw new IllegalArgumentException("Level count must be < 254.");
        }
        this.levelCount = levelCount;
        this.priorityQueue = new LeveledPriorityQueue(levelCount, expectedLevelSize);
        this.computedLevels = new Long2ByteOpenHashMap(expectedTotalSize, 0.5f){

            protected void rehash(int i) {
                if (i > expectedTotalSize) {
                    super.rehash(i);
                }
            }
        };
        this.computedLevels.defaultReturnValue((byte)-1);
    }

    protected void removeFromQueue(long id) {
        int i = this.computedLevels.remove(id) & 0xFF;
        if (i == 255) {
            return;
        }
        int j = this.getLevel(id);
        int k = this.calculatePriority(j, i);
        this.priorityQueue.dequeue(id, k, this.levelCount);
        this.hasWork = !this.priorityQueue.isEmpty();
    }

    public void removeIf(LongPredicate predicate) {
        LongArrayList longList = new LongArrayList();
        this.computedLevels.keySet().forEach(arg_0 -> DynamicGraphMinFixedPoint.lambda$removeIf$0(predicate, (LongList)longList, arg_0));
        longList.forEach(this::removeFromQueue);
    }

    private int calculatePriority(int a, int b) {
        return Math.min(Math.min(a, b), this.levelCount - 1);
    }

    protected void checkNode(long id) {
        this.checkEdge(id, id, this.levelCount - 1, false);
    }

    protected void checkEdge(long sourceId, long id, int level, boolean decrease) {
        this.checkEdge(sourceId, id, level, this.getLevel(id), this.computedLevels.get(id) & 0xFF, decrease);
        this.hasWork = !this.priorityQueue.isEmpty();
    }

    private void checkEdge(long sourceId, long id, int level, int currentLevel, int i, boolean decrease) {
        int k;
        boolean bl;
        if (this.isSource(id)) {
            return;
        }
        level = Mth.clamp(level, 0, this.levelCount - 1);
        currentLevel = Mth.clamp(currentLevel, 0, this.levelCount - 1);
        boolean bl2 = bl = i == 255;
        if (bl) {
            i = currentLevel;
        }
        if (decrease) {
            int j = Math.min(i, level);
        } else {
            k = Mth.clamp(this.getComputedLevel(id, sourceId, level), 0, this.levelCount - 1);
        }
        int l = this.calculatePriority(currentLevel, i);
        if (currentLevel != k) {
            int m = this.calculatePriority(currentLevel, k);
            if (l != m && !bl) {
                this.priorityQueue.dequeue(id, l, m);
            }
            this.priorityQueue.enqueue(id, m);
            this.computedLevels.put(id, (byte)k);
        } else if (!bl) {
            this.priorityQueue.dequeue(id, l, this.levelCount);
            this.computedLevels.remove(id);
        }
    }

    protected final void checkNeighbor(long sourceId, long targetId, int level, boolean decrease) {
        int i = this.computedLevels.get(targetId) & 0xFF;
        int j = Mth.clamp(this.computeLevelFromNeighbor(sourceId, targetId, level), 0, this.levelCount - 1);
        if (decrease) {
            this.checkEdge(sourceId, targetId, j, this.getLevel(targetId), i, decrease);
        } else {
            int l;
            boolean bl;
            boolean bl2 = bl = i == 255;
            if (bl) {
                int k = Mth.clamp(this.getLevel(targetId), 0, this.levelCount - 1);
            } else {
                l = i;
            }
            if (j == l) {
                this.checkEdge(sourceId, targetId, this.levelCount - 1, bl ? l : this.getLevel(targetId), i, decrease);
            }
        }
    }

    protected final boolean hasWork() {
        return this.hasWork;
    }

    protected final int runUpdates(int maxSteps) {
        if (this.priorityQueue.isEmpty()) {
            return maxSteps;
        }
        while (!this.priorityQueue.isEmpty() && maxSteps > 0) {
            --maxSteps;
            long l = this.priorityQueue.removeFirstLong();
            int i = Mth.clamp(this.getLevel(l), 0, this.levelCount - 1);
            int j = this.computedLevels.remove(l) & 0xFF;
            if (j < i) {
                this.setLevel(l, j);
                this.checkNeighborsAfterUpdate(l, j, true);
                continue;
            }
            if (j <= i) continue;
            this.setLevel(l, this.levelCount - 1);
            if (j != this.levelCount - 1) {
                this.priorityQueue.enqueue(l, this.calculatePriority(this.levelCount - 1, j));
                this.computedLevels.put(l, (byte)j);
            }
            this.checkNeighborsAfterUpdate(l, i, false);
        }
        this.hasWork = !this.priorityQueue.isEmpty();
        return maxSteps;
    }

    public int getQueueSize() {
        return this.computedLevels.size();
    }

    protected boolean isSource(long id) {
        return id == Long.MAX_VALUE;
    }

    protected abstract int getComputedLevel(long var1, long var3, int var5);

    protected abstract void checkNeighborsAfterUpdate(long var1, int var3, boolean var4);

    protected abstract int getLevel(long var1);

    protected abstract void setLevel(long var1, int var3);

    protected abstract int computeLevelFromNeighbor(long var1, long var3, int var5);

    private static /* synthetic */ void lambda$removeIf$0(LongPredicate longPredicate, LongList longList, long l) {
        if (longPredicate.test(l)) {
            longList.add(l);
        }
    }
}

