/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlackstoneReplaceProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockAgeProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.LavaSubmergedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;

public class RuinedPortalPiece
extends TemplateStructurePiece {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float PROBABILITY_OF_GOLD_GONE = 0.3f;
    private static final float PROBABILITY_OF_MAGMA_INSTEAD_OF_NETHERRACK = 0.07f;
    private static final float PROBABILITY_OF_MAGMA_INSTEAD_OF_LAVA = 0.2f;
    private final VerticalPlacement verticalPlacement;
    private final Properties properties;

    public RuinedPortalPiece(StructureTemplateManager manager, BlockPos pos, VerticalPlacement verticalPlacement, Properties properties, ResourceLocation id, StructureTemplate template, Rotation rotation, Mirror mirror, BlockPos blockPos) {
        super(StructurePieceType.RUINED_PORTAL, 0, manager, id, id.toString(), RuinedPortalPiece.makeSettings(mirror, rotation, verticalPlacement, blockPos, properties), pos);
        this.verticalPlacement = verticalPlacement;
        this.properties = properties;
    }

    public RuinedPortalPiece(StructureTemplateManager manager, CompoundTag nbt) {
        super(StructurePieceType.RUINED_PORTAL, nbt, manager, id -> RuinedPortalPiece.makeSettings(manager, nbt, id));
        this.verticalPlacement = VerticalPlacement.byName(nbt.getString("VerticalPlacement"));
        this.properties = (Properties)Properties.CODEC.parse(new Dynamic<Tag>(NbtOps.INSTANCE, nbt.get("Properties"))).getPartialOrThrow();
    }

    @Override
    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag nbt) {
        super.addAdditionalSaveData(context, nbt);
        nbt.putString("Rotation", this.placeSettings.getRotation().name());
        nbt.putString("Mirror", this.placeSettings.getMirror().name());
        nbt.putString("VerticalPlacement", this.verticalPlacement.getName());
        Properties.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.properties).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> nbt.put("Properties", (Tag)tag));
    }

    private static StructurePlaceSettings makeSettings(StructureTemplateManager manager, CompoundTag nbt, ResourceLocation id) {
        StructureTemplate structureTemplate = manager.getOrCreate(id);
        BlockPos blockPos = new BlockPos(structureTemplate.getSize().getX() / 2, 0, structureTemplate.getSize().getZ() / 2);
        return RuinedPortalPiece.makeSettings(Mirror.valueOf(nbt.getString("Mirror")), Rotation.valueOf(nbt.getString("Rotation")), VerticalPlacement.byName(nbt.getString("VerticalPlacement")), blockPos, (Properties)Properties.CODEC.parse(new Dynamic<Tag>(NbtOps.INSTANCE, nbt.get("Properties"))).getPartialOrThrow());
    }

    private static StructurePlaceSettings makeSettings(Mirror mirror, Rotation rotation, VerticalPlacement verticalPlacement, BlockPos pos, Properties properties) {
        BlockIgnoreProcessor blockIgnoreProcessor = properties.airPocket ? BlockIgnoreProcessor.STRUCTURE_BLOCK : BlockIgnoreProcessor.STRUCTURE_AND_AIR;
        ArrayList list = Lists.newArrayList();
        list.add(RuinedPortalPiece.getBlockReplaceRule(Blocks.GOLD_BLOCK, 0.3f, Blocks.AIR));
        list.add(RuinedPortalPiece.getLavaProcessorRule(verticalPlacement, properties));
        if (!properties.cold) {
            list.add(RuinedPortalPiece.getBlockReplaceRule(Blocks.NETHERRACK, 0.07f, Blocks.MAGMA_BLOCK));
        }
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings().setRotation(rotation).setMirror(mirror).setRotationPivot(pos).addProcessor(blockIgnoreProcessor).addProcessor(new RuleProcessor(list)).addProcessor(new BlockAgeProcessor(properties.mossiness)).addProcessor(new ProtectedBlockProcessor(BlockTags.FEATURES_CANNOT_REPLACE)).addProcessor(new LavaSubmergedBlockProcessor());
        if (properties.replaceWithBlackstone) {
            structurePlaceSettings.addProcessor(BlackstoneReplaceProcessor.INSTANCE);
        }
        return structurePlaceSettings;
    }

    private static ProcessorRule getLavaProcessorRule(VerticalPlacement verticalPlacement, Properties properties) {
        if (verticalPlacement == VerticalPlacement.ON_OCEAN_FLOOR) {
            return RuinedPortalPiece.getBlockReplaceRule(Blocks.LAVA, Blocks.MAGMA_BLOCK);
        }
        if (properties.cold) {
            return RuinedPortalPiece.getBlockReplaceRule(Blocks.LAVA, Blocks.NETHERRACK);
        }
        return RuinedPortalPiece.getBlockReplaceRule(Blocks.LAVA, 0.2f, Blocks.MAGMA_BLOCK);
    }

    @Override
    @Override
    public void postProcess(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
        BoundingBox boundingBox = this.template.getBoundingBox(this.placeSettings, this.templatePosition);
        if (!chunkBox.isInside(boundingBox.getCenter())) {
            return;
        }
        chunkBox.encapsulate(boundingBox);
        super.postProcess(world, structureAccessor, chunkGenerator, random, chunkBox, chunkPos, pivot);
        this.spreadNetherrack(random, world);
        this.addNetherrackDripColumnsBelowPortal(random, world);
        if (this.properties.vines || this.properties.overgrown) {
            BlockPos.betweenClosedStream(this.getBoundingBox()).forEach(pos -> {
                if (this.properties.vines) {
                    this.maybeAddVines(random, world, (BlockPos)pos);
                }
                if (this.properties.overgrown) {
                    this.maybeAddLeavesAbove(random, world, (BlockPos)pos);
                }
            });
        }
    }

    @Override
    @Override
    protected void handleDataMarker(String metadata, BlockPos pos, ServerLevelAccessor world, RandomSource random, BoundingBox boundingBox) {
    }

    private void maybeAddVines(RandomSource random, LevelAccessor world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        if (blockState.isAir() || blockState.is(Blocks.VINE)) {
            return;
        }
        Direction direction = RuinedPortalPiece.getRandomHorizontalDirection(random);
        BlockPos blockPos = pos.relative(direction);
        BlockState blockState2 = world.getBlockState(blockPos);
        if (!blockState2.isAir()) {
            return;
        }
        if (!Block.isFaceFull(blockState.getCollisionShape(world, pos), direction)) {
            return;
        }
        BooleanProperty booleanProperty = VineBlock.getPropertyForFace(direction.getOpposite());
        world.setBlock(blockPos, (BlockState)Blocks.VINE.defaultBlockState().setValue(booleanProperty, true), 3);
    }

    private void maybeAddLeavesAbove(RandomSource random, LevelAccessor world, BlockPos pos) {
        if (random.nextFloat() < 0.5f && world.getBlockState(pos).is(Blocks.NETHERRACK) && world.getBlockState(pos.above()).isAir()) {
            world.setBlock(pos.above(), (BlockState)Blocks.JUNGLE_LEAVES.defaultBlockState().setValue(LeavesBlock.PERSISTENT, true), 3);
        }
    }

    private void addNetherrackDripColumnsBelowPortal(RandomSource random, LevelAccessor world) {
        for (int i = this.boundingBox.minX() + 1; i < this.boundingBox.maxX(); ++i) {
            for (int j = this.boundingBox.minZ() + 1; j < this.boundingBox.maxZ(); ++j) {
                BlockPos blockPos = new BlockPos(i, this.boundingBox.minY(), j);
                if (!world.getBlockState(blockPos).is(Blocks.NETHERRACK)) continue;
                this.addNetherrackDripColumn(random, world, blockPos.below());
            }
        }
    }

    private void addNetherrackDripColumn(RandomSource random, LevelAccessor world, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        this.placeNetherrackOrMagma(random, world, mutableBlockPos);
        for (int i = 8; i > 0 && random.nextFloat() < 0.5f; --i) {
            mutableBlockPos.move(Direction.DOWN);
            this.placeNetherrackOrMagma(random, world, mutableBlockPos);
        }
    }

    private void spreadNetherrack(RandomSource random, LevelAccessor world) {
        boolean bl = this.verticalPlacement == VerticalPlacement.ON_LAND_SURFACE || this.verticalPlacement == VerticalPlacement.ON_OCEAN_FLOOR;
        BlockPos blockPos = this.boundingBox.getCenter();
        int i = blockPos.getX();
        int j = blockPos.getZ();
        float[] fs = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.8f, 0.7f, 0.6f, 0.4f, 0.2f};
        int k = fs.length;
        int l = (this.boundingBox.getXSpan() + this.boundingBox.getZSpan()) / 2;
        int m = random.nextInt(Math.max(1, 8 - l / 2));
        int n = 3;
        BlockPos.MutableBlockPos mutableBlockPos = BlockPos.ZERO.mutable();
        for (int o = i - k; o <= i + k; ++o) {
            for (int p = j - k; p <= j + k; ++p) {
                int q = Math.abs(o - i) + Math.abs(p - j);
                int r = Math.max(0, q + m);
                if (r >= k) continue;
                float f = fs[r];
                if (!(random.nextDouble() < (double)f)) continue;
                int s = RuinedPortalPiece.getSurfaceY(world, o, p, this.verticalPlacement);
                int t = bl ? s : Math.min(this.boundingBox.minY(), s);
                mutableBlockPos.set(o, t, p);
                if (Math.abs(t - this.boundingBox.minY()) > 3 || !this.canBlockBeReplacedByNetherrackOrMagma(world, mutableBlockPos)) continue;
                this.placeNetherrackOrMagma(random, world, mutableBlockPos);
                if (this.properties.overgrown) {
                    this.maybeAddLeavesAbove(random, world, mutableBlockPos);
                }
                this.addNetherrackDripColumn(random, world, (BlockPos)mutableBlockPos.below());
            }
        }
    }

    private boolean canBlockBeReplacedByNetherrackOrMagma(LevelAccessor world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        return !blockState.is(Blocks.AIR) && !blockState.is(Blocks.OBSIDIAN) && !blockState.is(BlockTags.FEATURES_CANNOT_REPLACE) && (this.verticalPlacement == VerticalPlacement.IN_NETHER || !blockState.is(Blocks.LAVA));
    }

    private void placeNetherrackOrMagma(RandomSource random, LevelAccessor world, BlockPos pos) {
        if (!this.properties.cold && random.nextFloat() < 0.07f) {
            world.setBlock(pos, Blocks.MAGMA_BLOCK.defaultBlockState(), 3);
        } else {
            world.setBlock(pos, Blocks.NETHERRACK.defaultBlockState(), 3);
        }
    }

    private static int getSurfaceY(LevelAccessor world, int x, int y, VerticalPlacement verticalPlacement) {
        return world.getHeight(RuinedPortalPiece.getHeightMapType(verticalPlacement), x, y) - 1;
    }

    public static Heightmap.Types getHeightMapType(VerticalPlacement verticalPlacement) {
        return verticalPlacement == VerticalPlacement.ON_OCEAN_FLOOR ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG;
    }

    private static ProcessorRule getBlockReplaceRule(Block old, float chance, Block updated) {
        return new ProcessorRule(new RandomBlockMatchTest(old, chance), AlwaysTrueTest.INSTANCE, updated.defaultBlockState());
    }

    private static ProcessorRule getBlockReplaceRule(Block old, Block updated) {
        return new ProcessorRule(new BlockMatchTest(old), AlwaysTrueTest.INSTANCE, updated.defaultBlockState());
    }

    public static enum VerticalPlacement implements StringRepresentable
    {
        ON_LAND_SURFACE("on_land_surface"),
        PARTLY_BURIED("partly_buried"),
        ON_OCEAN_FLOOR("on_ocean_floor"),
        IN_MOUNTAIN("in_mountain"),
        UNDERGROUND("underground"),
        IN_NETHER("in_nether");

        public static final StringRepresentable.EnumCodec<VerticalPlacement> CODEC;
        private final String name;

        private VerticalPlacement(String id) {
            this.name = id;
        }

        public String getName() {
            return this.name;
        }

        public static VerticalPlacement byName(String id) {
            return CODEC.byName(id);
        }

        @Override
        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(VerticalPlacement::values);
        }
    }

    public static class Properties {
        public static final Codec<Properties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("cold").forGetter(properties -> properties.cold), (App)Codec.FLOAT.fieldOf("mossiness").forGetter(properties -> Float.valueOf(properties.mossiness)), (App)Codec.BOOL.fieldOf("air_pocket").forGetter(properties -> properties.airPocket), (App)Codec.BOOL.fieldOf("overgrown").forGetter(properties -> properties.overgrown), (App)Codec.BOOL.fieldOf("vines").forGetter(properties -> properties.vines), (App)Codec.BOOL.fieldOf("replace_with_blackstone").forGetter(properties -> properties.replaceWithBlackstone)).apply((Applicative)instance, Properties::new));
        public boolean cold;
        public float mossiness;
        public boolean airPocket;
        public boolean overgrown;
        public boolean vines;
        public boolean replaceWithBlackstone;

        public Properties() {
        }

        public Properties(boolean cold, float mossiness, boolean airPocket, boolean overgrown, boolean vines, boolean replaceWithBlackstone) {
            this.cold = cold;
            this.mossiness = mossiness;
            this.airPocket = airPocket;
            this.overgrown = overgrown;
            this.vines = vines;
            this.replaceWithBlackstone = replaceWithBlackstone;
        }
    }
}

