/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pieces;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;

public class StructurePiecesBuilder
implements StructurePieceAccessor {
    private final List<StructurePiece> pieces = Lists.newArrayList();

    @Override
    @Override
    public void addPiece(StructurePiece piece) {
        this.pieces.add(piece);
    }

    @Override
    @Nullable
    @Override
    public StructurePiece findCollisionPiece(BoundingBox box) {
        return StructurePiece.findCollisionPiece(this.pieces, box);
    }

    @Deprecated
    public void offsetPiecesVertically(int y) {
        for (StructurePiece structurePiece : this.pieces) {
            structurePiece.move(0, y, 0);
        }
    }

    @Deprecated
    public int moveBelowSeaLevel(int topY, int bottomY, RandomSource random, int topPenalty) {
        int i = topY - topPenalty;
        BoundingBox boundingBox = this.getBoundingBox();
        int j = boundingBox.getYSpan() + bottomY + 1;
        if (j < i) {
            j += random.nextInt(i - j);
        }
        int k = j - boundingBox.maxY();
        this.offsetPiecesVertically(k);
        return k;
    }

    public void moveInsideHeights(RandomSource random, int baseY, int topY) {
        int k;
        BoundingBox boundingBox = this.getBoundingBox();
        int i = topY - baseY + 1 - boundingBox.getYSpan();
        if (i > 1) {
            int j = baseY + random.nextInt(i);
        } else {
            k = baseY;
        }
        int l = k - boundingBox.minY();
        this.offsetPiecesVertically(l);
    }

    public PiecesContainer build() {
        return new PiecesContainer(this.pieces);
    }

    public void clear() {
        this.pieces.clear();
    }

    public boolean isEmpty() {
        return this.pieces.isEmpty();
    }

    public BoundingBox getBoundingBox() {
        return StructurePiece.createBoundingBox(this.pieces.stream());
    }
}

