/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NetherForestVegetationConfig;

public class NetherForestVegetationFeature
extends Feature<NetherForestVegetationConfig> {
    public NetherForestVegetationFeature(Codec<NetherForestVegetationConfig> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean place(FeaturePlaceContext<NetherForestVegetationConfig> context) {
        WorldGenLevel worldGenLevel = context.level();
        BlockPos blockPos = context.origin();
        BlockState blockState = worldGenLevel.getBlockState(blockPos.below());
        NetherForestVegetationConfig netherForestVegetationConfig = context.config();
        RandomSource randomSource = context.random();
        if (!blockState.is(BlockTags.NYLIUM)) {
            return false;
        }
        int i = blockPos.getY();
        if (i < worldGenLevel.getMinBuildHeight() + 1 || i + 1 >= worldGenLevel.getMaxBuildHeight()) {
            return false;
        }
        int j = 0;
        for (int k = 0; k < netherForestVegetationConfig.spreadWidth * netherForestVegetationConfig.spreadWidth; ++k) {
            BlockPos blockPos2 = blockPos.offset(randomSource.nextInt(netherForestVegetationConfig.spreadWidth) - randomSource.nextInt(netherForestVegetationConfig.spreadWidth), randomSource.nextInt(netherForestVegetationConfig.spreadHeight) - randomSource.nextInt(netherForestVegetationConfig.spreadHeight), randomSource.nextInt(netherForestVegetationConfig.spreadWidth) - randomSource.nextInt(netherForestVegetationConfig.spreadWidth));
            BlockState blockState2 = netherForestVegetationConfig.stateProvider.getState(randomSource, blockPos2);
            if (!worldGenLevel.isEmptyBlock(blockPos2) || blockPos2.getY() <= worldGenLevel.getMinBuildHeight() || !blockState2.canSurvive(worldGenLevel, blockPos2)) continue;
            worldGenLevel.setBlock(blockPos2, blockState2, 2);
            ++j;
        }
        return j > 0;
    }
}

