/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension.end;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;
import org.bukkit.event.entity.EntityRemoveEvent;

public enum DragonRespawnAnimation {
    START{

        @Override
        public void tick(ServerLevel world, EndDragonFight fight, List<EndCrystal> crystals, int tick, BlockPos pos) {
            BlockPos blockposition1 = new BlockPos(0, 128, 0);
            for (EndCrystal entityendercrystal : crystals) {
                entityendercrystal.setBeamTarget(blockposition1);
            }
            fight.setRespawnStage(PREPARING_TO_SUMMON_PILLARS);
        }
    }
    ,
    PREPARING_TO_SUMMON_PILLARS{

        @Override
        public void tick(ServerLevel world, EndDragonFight fight, List<EndCrystal> crystals, int tick, BlockPos pos) {
            if (tick < 100) {
                if (tick == 0 || tick == 50 || tick == 51 || tick == 52 || tick >= 95) {
                    world.levelEvent(3001, new BlockPos(0, 128, 0), 0);
                }
            } else {
                fight.setRespawnStage(SUMMONING_PILLARS);
            }
        }
    }
    ,
    SUMMONING_PILLARS{

        @Override
        public void tick(ServerLevel world, EndDragonFight fight, List<EndCrystal> crystals, int tick, BlockPos pos) {
            boolean flag2;
            boolean flag = true;
            boolean flag1 = tick % 40 == 0;
            boolean bl = flag2 = tick % 40 == 39;
            if (flag1 || flag2) {
                int j = tick / 40;
                List<SpikeFeature.EndSpike> list1 = SpikeFeature.getSpikesForLevel(world);
                if (j < list1.size()) {
                    SpikeFeature.EndSpike worldgenender_spike = list1.get(j);
                    if (flag1) {
                        for (EndCrystal entityendercrystal : crystals) {
                            entityendercrystal.setBeamTarget(new BlockPos(worldgenender_spike.getCenterX(), worldgenender_spike.getHeight() + 1, worldgenender_spike.getCenterZ()));
                        }
                    } else {
                        boolean flag3 = true;
                        for (BlockPos blockposition1 : BlockPos.betweenClosed(new BlockPos(worldgenender_spike.getCenterX() - 10, worldgenender_spike.getHeight() - 10, worldgenender_spike.getCenterZ() - 10), new BlockPos(worldgenender_spike.getCenterX() + 10, worldgenender_spike.getHeight() + 10, worldgenender_spike.getCenterZ() + 10))) {
                            world.removeBlock(blockposition1, false);
                        }
                        world.explode(null, (float)worldgenender_spike.getCenterX() + 0.5f, worldgenender_spike.getHeight(), (float)worldgenender_spike.getCenterZ() + 0.5f, 5.0f, Level.ExplosionInteraction.BLOCK);
                        SpikeConfiguration worldgenfeatureendspikeconfiguration = new SpikeConfiguration(true, (List<SpikeFeature.EndSpike>)ImmutableList.of((Object)worldgenender_spike), new BlockPos(0, 128, 0));
                        Feature.END_SPIKE.place(worldgenfeatureendspikeconfiguration, world, world.getChunkSource().getGenerator(), RandomSource.create(), new BlockPos(worldgenender_spike.getCenterX(), 45, worldgenender_spike.getCenterZ()));
                    }
                } else if (flag1) {
                    fight.setRespawnStage(SUMMONING_DRAGON);
                }
            }
        }
    }
    ,
    SUMMONING_DRAGON{

        @Override
        public void tick(ServerLevel world, EndDragonFight fight, List<EndCrystal> crystals, int tick, BlockPos pos) {
            if (tick >= 100) {
                fight.setRespawnStage(END);
                fight.resetSpikeCrystals();
                for (EndCrystal entityendercrystal : crystals) {
                    entityendercrystal.setBeamTarget(null);
                    world.explode(entityendercrystal, entityendercrystal.getX(), entityendercrystal.getY(), entityendercrystal.getZ(), 6.0f, Level.ExplosionInteraction.NONE);
                    entityendercrystal.discard(EntityRemoveEvent.Cause.EXPLODE);
                }
            } else if (tick >= 80) {
                world.levelEvent(3001, new BlockPos(0, 128, 0), 0);
            } else if (tick == 0) {
                for (EndCrystal entityendercrystal : crystals) {
                    entityendercrystal.setBeamTarget(new BlockPos(0, 128, 0));
                }
            } else if (tick < 5) {
                world.levelEvent(3001, new BlockPos(0, 128, 0), 0);
            }
        }
    }
    ,
    END{

        @Override
        public void tick(ServerLevel world, EndDragonFight fight, List<EndCrystal> crystals, int tick, BlockPos pos) {
        }
    };


    public abstract void tick(ServerLevel var1, EndDragonFight var2, List<EndCrystal> var3, int var4, BlockPos var5);
}

