/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMath;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PistonMovingBlockEntity
extends BlockEntity {
    private static final int TICKS_TO_EXTEND = 2;
    private static final double PUSH_OFFSET = 0.01;
    public static final double TICK_MOVEMENT = 0.51;
    private BlockState movedState = Blocks.AIR.defaultBlockState();
    private Direction direction;
    private boolean extending;
    private boolean isSourcePiston;
    private static final ThreadLocal<Direction> NOCLIP = ThreadLocal.withInitial(() -> null);
    private float progress;
    private float progressO;
    private long lastTicked;
    private int deathTicks;

    public PistonMovingBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityType.PISTON, pos, state);
    }

    public PistonMovingBlockEntity(BlockPos pos, BlockState state, BlockState pushedBlock, Direction facing, boolean extending, boolean source) {
        this(pos, state);
        this.movedState = pushedBlock;
        this.direction = facing;
        this.extending = extending;
        this.isSourcePiston = source;
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveCustomOnly(registryLookup);
    }

    public boolean isExtending() {
        return this.extending;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isSourcePiston() {
        return this.isSourcePiston;
    }

    public float getProgress(float tickDelta) {
        if (tickDelta > 1.0f) {
            tickDelta = 1.0f;
        }
        return Mth.lerp(tickDelta, this.progressO, this.progress);
    }

    public float getXOff(float tickDelta) {
        return (float)this.direction.getStepX() * this.getExtendedProgress(this.getProgress(tickDelta));
    }

    public float getYOff(float tickDelta) {
        return (float)this.direction.getStepY() * this.getExtendedProgress(this.getProgress(tickDelta));
    }

    public float getZOff(float tickDelta) {
        return (float)this.direction.getStepZ() * this.getExtendedProgress(this.getProgress(tickDelta));
    }

    private float getExtendedProgress(float progress) {
        return this.extending ? progress - 1.0f : 1.0f - progress;
    }

    private BlockState getCollisionRelatedBlockState() {
        return !this.isExtending() && this.isSourcePiston() && this.movedState.getBlock() instanceof PistonBaseBlock ? (BlockState)((BlockState)((BlockState)Blocks.PISTON_HEAD.defaultBlockState().setValue(PistonHeadBlock.SHORT, this.progress > 0.25f)).setValue(PistonHeadBlock.TYPE, this.movedState.is(Blocks.STICKY_PISTON) ? PistonType.STICKY : PistonType.DEFAULT)).setValue(DirectionalBlock.FACING, this.movedState.getValue(DirectionalBlock.FACING)) : this.movedState;
    }

    private static void moveCollidedEntities(Level world, BlockPos pos, float f, PistonMovingBlockEntity blockEntity) {
        AABB aABB;
        List<Entity> list;
        Direction direction = blockEntity.getMovementDirection();
        double d = f - blockEntity.progress;
        VoxelShape voxelShape = blockEntity.getCollisionRelatedBlockState().getCollisionShape(world, pos);
        if (!voxelShape.isEmpty() && !(list = world.getEntities(null, PistonMath.getMovementArea(aABB = PistonMovingBlockEntity.moveByPositionAndProgress(pos, voxelShape.bounds(), blockEntity), direction, d).minmax(aABB))).isEmpty()) {
            List<AABB> list2 = voxelShape.toAabbs();
            boolean bl = blockEntity.movedState.is(Blocks.SLIME_BLOCK);
            Iterator<Entity> var12 = list.iterator();
            while (true) {
                AABB aABB4;
                AABB aABB2;
                AABB aABB3;
                if (!var12.hasNext()) {
                    return;
                }
                Entity entity = var12.next();
                if (entity.getPistonPushReaction() == PushReaction.IGNORE) continue;
                if (bl) {
                    if (entity instanceof ServerPlayer) continue;
                    Vec3 vec3 = entity.getDeltaMovement();
                    double e = vec3.x;
                    double g = vec3.y;
                    double h = vec3.z;
                    switch (direction.getAxis()) {
                        case X: {
                            e = direction.getStepX();
                            break;
                        }
                        case Y: {
                            g = direction.getStepY();
                            break;
                        }
                        case Z: {
                            h = direction.getStepZ();
                        }
                    }
                    entity.setDeltaMovement(e, g, h);
                    entity.activatedTick = Math.max(entity.activatedTick, (long)(MinecraftServer.currentTick + 10));
                    entity.activatedImmunityTick = Math.max(entity.activatedImmunityTick, (long)(MinecraftServer.currentTick + 10));
                }
                double i = 0.0;
                Iterator<AABB> iterator = list2.iterator();
                while (!(!iterator.hasNext() || (aABB3 = PistonMath.getMovementArea(PistonMovingBlockEntity.moveByPositionAndProgress(pos, aABB2 = iterator.next(), blockEntity), direction, d)).intersects(aABB4 = entity.getBoundingBox()) && (i = Math.max(i, PistonMovingBlockEntity.getMovement(aABB3, direction, aABB4))) >= d)) {
                }
                if (i <= 0.0) continue;
                i = Math.min(i, d) + 0.01;
                PistonMovingBlockEntity.moveEntityByPiston(direction, entity, i, direction);
                if (blockEntity.extending || !blockEntity.isSourcePiston) continue;
                PistonMovingBlockEntity.fixEntityWithinPistonBase(pos, entity, direction, d);
            }
        }
    }

    private static void moveEntityByPiston(Direction direction, Entity entity, double distance, Direction movementDirection) {
        NOCLIP.set(direction);
        entity.move(MoverType.PISTON, new Vec3(distance * (double)movementDirection.getStepX(), distance * (double)movementDirection.getStepY(), distance * (double)movementDirection.getStepZ()));
        NOCLIP.set(null);
    }

    private static void moveStuckEntities(Level world, BlockPos pos, float f, PistonMovingBlockEntity blockEntity) {
        Direction direction;
        if (blockEntity.isStickyForEntities() && (direction = blockEntity.getMovementDirection()).getAxis().isHorizontal()) {
            double d = blockEntity.movedState.getCollisionShape(world, pos).max(Direction.Axis.Y);
            AABB aABB = PistonMovingBlockEntity.moveByPositionAndProgress(pos, new AABB(0.0, d, 0.0, 1.0, 1.5000010000000001, 1.0), blockEntity);
            double e = f - blockEntity.progress;
            for (Entity entity : world.getEntities((Entity)null, aABB, entityx -> PistonMovingBlockEntity.matchesStickyCritera(aABB, entityx, pos))) {
                PistonMovingBlockEntity.moveEntityByPiston(direction, entity, e, direction);
            }
        }
    }

    private static boolean matchesStickyCritera(AABB box, Entity entity, BlockPos pos) {
        return entity.getPistonPushReaction() == PushReaction.NORMAL && entity.onGround() && (entity.isSupportedBy(pos) || entity.getX() >= box.minX && entity.getX() <= box.maxX && entity.getZ() >= box.minZ && entity.getZ() <= box.maxZ);
    }

    private boolean isStickyForEntities() {
        return this.movedState.is(Blocks.HONEY_BLOCK);
    }

    public Direction getMovementDirection() {
        return this.extending ? this.direction : this.direction.getOpposite();
    }

    private static double getMovement(AABB aABB, Direction direction, AABB aABB2) {
        switch (direction) {
            case EAST: {
                return aABB.maxX - aABB2.minX;
            }
            case WEST: {
                return aABB2.maxX - aABB.minX;
            }
            default: {
                return aABB.maxY - aABB2.minY;
            }
            case DOWN: {
                return aABB2.maxY - aABB.minY;
            }
            case SOUTH: {
                return aABB.maxZ - aABB2.minZ;
            }
            case NORTH: 
        }
        return aABB2.maxZ - aABB.minZ;
    }

    private static AABB moveByPositionAndProgress(BlockPos pos, AABB box, PistonMovingBlockEntity blockEntity) {
        double d = blockEntity.getExtendedProgress(blockEntity.progress);
        return box.move((double)pos.getX() + d * (double)blockEntity.direction.getStepX(), (double)pos.getY() + d * (double)blockEntity.direction.getStepY(), (double)pos.getZ() + d * (double)blockEntity.direction.getStepZ());
    }

    private static void fixEntityWithinPistonBase(BlockPos pos, Entity entity, Direction direction, double amount) {
        double e;
        Direction direction2;
        double d;
        AABB aABB2;
        AABB aABB = entity.getBoundingBox();
        if (aABB.intersects(aABB2 = Shapes.block().bounds().move(pos)) && Math.abs((d = PistonMovingBlockEntity.getMovement(aABB2, direction2 = direction.getOpposite(), aABB) + 0.01) - (e = PistonMovingBlockEntity.getMovement(aABB2, direction2, aABB.intersect(aABB2)) + 0.01)) < 0.01) {
            d = Math.min(d, amount) + 0.01;
            PistonMovingBlockEntity.moveEntityByPiston(direction, entity, d, direction2);
        }
    }

    public BlockState getMovedState() {
        return this.movedState;
    }

    public void finalTick() {
        if (this.level != null && (this.progressO < 1.0f || this.level.isClientSide)) {
            this.progressO = this.progress = 1.0f;
            this.level.removeBlockEntity(this.worldPosition);
            this.setRemoved();
            if (this.level.getBlockState(this.worldPosition).is(Blocks.MOVING_PISTON)) {
                BlockState blockState = this.isSourcePiston ? Blocks.AIR.defaultBlockState() : Block.updateFromNeighbourShapes(this.movedState, this.level, this.worldPosition);
                this.level.setBlock(this.worldPosition, blockState, 3);
                this.level.neighborChanged(this.worldPosition, blockState.getBlock(), this.worldPosition);
            }
        }
    }

    public static void tick(Level world, BlockPos pos, BlockState state, PistonMovingBlockEntity blockEntity) {
        blockEntity.lastTicked = world.getGameTime();
        blockEntity.progressO = blockEntity.progress;
        if (blockEntity.progressO >= 1.0f) {
            if (world.isClientSide && blockEntity.deathTicks < 5) {
                ++blockEntity.deathTicks;
            } else {
                world.removeBlockEntity(pos);
                blockEntity.setRemoved();
                if (world.getBlockState(pos).is(Blocks.MOVING_PISTON)) {
                    BlockState blockState = Block.updateFromNeighbourShapes(blockEntity.movedState, world, pos);
                    if (blockState.isAir()) {
                        world.setBlock(pos, blockEntity.movedState, GlobalConfiguration.get().unsupportedSettings.allowPistonDuplication ? 84 : 86);
                        Block.updateOrDestroy(blockEntity.movedState, blockState, world, pos, 3);
                    } else {
                        if (blockState.hasProperty(BlockStateProperties.WATERLOGGED) && blockState.getValue(BlockStateProperties.WATERLOGGED).booleanValue()) {
                            blockState = (BlockState)blockState.setValue(BlockStateProperties.WATERLOGGED, false);
                        }
                        world.setBlock(pos, blockState, 67);
                        world.neighborChanged(pos, blockState.getBlock(), pos);
                    }
                }
            }
        } else {
            float f = blockEntity.progress + 0.5f;
            PistonMovingBlockEntity.moveCollidedEntities(world, pos, f, blockEntity);
            PistonMovingBlockEntity.moveStuckEntities(world, pos, f, blockEntity);
            blockEntity.progress = f;
            if (blockEntity.progress >= 1.0f) {
                blockEntity.progress = 1.0f;
            }
        }
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        HolderLookup.RegistryLookup<Block> holderGetter = this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup();
        this.movedState = NbtUtils.readBlockState(holderGetter, nbt.getCompound("blockState"));
        this.direction = Direction.from3DDataValue(nbt.getInt("facing"));
        this.progressO = this.progress = nbt.getFloat("progress");
        this.extending = nbt.getBoolean("extending");
        this.isSourcePiston = nbt.getBoolean("source");
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.put("blockState", NbtUtils.writeBlockState(this.movedState));
        nbt.putInt("facing", this.direction.get3DDataValue());
        nbt.putFloat("progress", this.progressO);
        nbt.putBoolean("extending", this.extending);
        nbt.putBoolean("source", this.isSourcePiston);
    }

    public VoxelShape getCollisionShape(BlockGetter world, BlockPos pos) {
        VoxelShape voxelShape = !this.extending && this.isSourcePiston && this.movedState.getBlock() instanceof PistonBaseBlock ? ((BlockState)this.movedState.setValue(PistonBaseBlock.EXTENDED, true)).getCollisionShape(world, pos) : Shapes.empty();
        Direction direction = NOCLIP.get();
        if ((double)this.progress < 1.0 && direction == this.getMovementDirection()) {
            return voxelShape;
        }
        BlockState blockState = this.isSourcePiston() ? (BlockState)((BlockState)Blocks.PISTON_HEAD.defaultBlockState().setValue(DirectionalBlock.FACING, this.direction)).setValue(PistonHeadBlock.SHORT, this.extending != 1.0f - this.progress < 0.25f) : this.movedState;
        float f = this.getExtendedProgress(this.progress);
        double d = (float)this.direction.getStepX() * f;
        double e = (float)this.direction.getStepY() * f;
        double g = (float)this.direction.getStepZ() * f;
        return Shapes.or(voxelShape, blockState.getCollisionShape(world, pos).move(d, e, g));
    }

    public long getLastTicked() {
        return this.lastTicked;
    }

    @Override
    public void setLevel(Level world) {
        super.setLevel(world);
        if (world.holderLookup(Registries.BLOCK).get(this.movedState.getBlock().builtInRegistryHolder().key()).isEmpty()) {
            this.movedState = Blocks.AIR.defaultBlockState();
        }
    }
}

