/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.vault;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.vault.VaultClientData;
import net.minecraft.world.level.block.entity.vault.VaultConfig;
import net.minecraft.world.level.block.entity.vault.VaultServerData;
import net.minecraft.world.level.block.entity.vault.VaultSharedData;
import net.minecraft.world.level.block.entity.vault.VaultState;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class VaultBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final VaultServerData serverData = new VaultServerData();
    private final VaultSharedData sharedData = new VaultSharedData();
    private final VaultClientData clientData = new VaultClientData();
    private VaultConfig config = VaultConfig.DEFAULT;

    public VaultBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityType.VAULT, pos, state);
    }

    @Override
    @Nullable
    @Override
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return Util.make(new CompoundTag(), nbt -> nbt.put("shared_data", VaultBlockEntity.encode(VaultSharedData.CODEC, this.sharedData, registryLookup)));
    }

    @Override
    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.put("config", VaultBlockEntity.encode(VaultConfig.CODEC, this.config, registryLookup));
        nbt.put("shared_data", VaultBlockEntity.encode(VaultSharedData.CODEC, this.sharedData, registryLookup));
        nbt.put("server_data", VaultBlockEntity.encode(VaultServerData.CODEC, this.serverData, registryLookup));
    }

    private static <T> Tag encode(Codec<T> codec, T value, HolderLookup.Provider registries) {
        return (Tag)codec.encodeStart(registries.createSerializationContext(NbtOps.INSTANCE), value).getOrThrow();
    }

    @Override
    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        RegistryOps<Tag> dynamicOps = registryLookup.createSerializationContext(NbtOps.INSTANCE);
        if (nbt.contains("server_data")) {
            VaultServerData.CODEC.parse(dynamicOps, (Object)nbt.get("server_data")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this.serverData::set);
        }
        if (nbt.contains("config")) {
            VaultConfig.CODEC.parse(dynamicOps, (Object)nbt.get("config")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(config -> {
                this.config = config;
            });
        }
        if (nbt.contains("shared_data")) {
            VaultSharedData.CODEC.parse(dynamicOps, (Object)nbt.get("shared_data")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this.sharedData::set);
        }
    }

    @Nullable
    public VaultServerData getServerData() {
        return this.level == null || this.level.isClientSide ? null : this.serverData;
    }

    public VaultSharedData getSharedData() {
        return this.sharedData;
    }

    public VaultClientData getClientData() {
        return this.clientData;
    }

    public VaultConfig getConfig() {
        return this.config;
    }

    @VisibleForTesting
    public void setConfig(VaultConfig config) {
        this.config = config;
    }

    public static final class Client {
        private static final int PARTICLE_TICK_RATE = 20;
        private static final float IDLE_PARTICLE_CHANCE = 0.5f;
        private static final float AMBIENT_SOUND_CHANCE = 0.02f;
        private static final int ACTIVATION_PARTICLE_COUNT = 20;
        private static final int DEACTIVATION_PARTICLE_COUNT = 20;

        public static void tick(Level world, BlockPos pos, BlockState state, VaultClientData clientData, VaultSharedData sharedData) {
            clientData.updateDisplayItemSpin();
            if (world.getGameTime() % 20L == 0L) {
                Client.emitConnectionParticlesForNearbyPlayers(world, pos, state, sharedData);
            }
            Client.emitIdleParticles(world, pos, sharedData, state.getValue(VaultBlock.OMINOUS) != false ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.SMALL_FLAME);
            Client.playIdleSounds(world, pos, sharedData);
        }

        public static void emitActivationParticles(Level world, BlockPos pos, BlockState state, VaultSharedData sharedData, ParticleOptions particle) {
            Client.emitConnectionParticlesForNearbyPlayers(world, pos, state, sharedData);
            RandomSource randomSource = world.random;
            for (int i = 0; i < 20; ++i) {
                Vec3 vec3 = Client.randomPosInsideCage(pos, randomSource);
                world.addParticle(ParticleTypes.SMOKE, vec3.x(), vec3.y(), vec3.z(), 0.0, 0.0, 0.0);
                world.addParticle(particle, vec3.x(), vec3.y(), vec3.z(), 0.0, 0.0, 0.0);
            }
        }

        public static void emitDeactivationParticles(Level world, BlockPos pos, ParticleOptions particle) {
            RandomSource randomSource = world.random;
            for (int i = 0; i < 20; ++i) {
                Vec3 vec3 = Client.randomPosCenterOfCage(pos, randomSource);
                Vec3 vec32 = new Vec3(randomSource.nextGaussian() * 0.02, randomSource.nextGaussian() * 0.02, randomSource.nextGaussian() * 0.02);
                world.addParticle(particle, vec3.x(), vec3.y(), vec3.z(), vec32.x(), vec32.y(), vec32.z());
            }
        }

        private static void emitIdleParticles(Level world, BlockPos pos, VaultSharedData sharedData, ParticleOptions particle) {
            RandomSource randomSource = world.getRandom();
            if (randomSource.nextFloat() <= 0.5f) {
                Vec3 vec3 = Client.randomPosInsideCage(pos, randomSource);
                world.addParticle(ParticleTypes.SMOKE, vec3.x(), vec3.y(), vec3.z(), 0.0, 0.0, 0.0);
                if (Client.shouldDisplayActiveEffects(sharedData)) {
                    world.addParticle(particle, vec3.x(), vec3.y(), vec3.z(), 0.0, 0.0, 0.0);
                }
            }
        }

        private static void emitConnectionParticlesForPlayer(Level world, Vec3 pos, Player player) {
            RandomSource randomSource = world.random;
            Vec3 vec3 = pos.vectorTo(player.position().add(0.0, player.getBbHeight() / 2.0f, 0.0));
            int i = Mth.nextInt(randomSource, 2, 5);
            for (int j = 0; j < i; ++j) {
                Vec3 vec32 = vec3.offsetRandom(randomSource, 1.0f);
                world.addParticle(ParticleTypes.VAULT_CONNECTION, pos.x(), pos.y(), pos.z(), vec32.x(), vec32.y(), vec32.z());
            }
        }

        private static void emitConnectionParticlesForNearbyPlayers(Level world, BlockPos pos, BlockState state, VaultSharedData sharedData) {
            Set<UUID> set = sharedData.getConnectedPlayers();
            if (set.isEmpty()) {
                return;
            }
            Vec3 vec3 = Client.keyholePos(pos, state.getValue(VaultBlock.FACING));
            for (UUID uUID : set) {
                Player player = world.getPlayerByUUID(uUID);
                if (player == null || !Client.isWithinConnectionRange(pos, sharedData, player)) continue;
                Client.emitConnectionParticlesForPlayer(world, vec3, player);
            }
        }

        private static boolean isWithinConnectionRange(BlockPos pos, VaultSharedData sharedData, Player player) {
            return player.blockPosition().distSqr(pos) <= Mth.square(sharedData.connectedParticlesRange());
        }

        private static void playIdleSounds(Level world, BlockPos pos, VaultSharedData sharedData) {
            if (!Client.shouldDisplayActiveEffects(sharedData)) {
                return;
            }
            RandomSource randomSource = world.getRandom();
            if (randomSource.nextFloat() <= 0.02f) {
                world.playLocalSound(pos, SoundEvents.VAULT_AMBIENT, SoundSource.BLOCKS, randomSource.nextFloat() * 0.25f + 0.75f, randomSource.nextFloat() + 0.5f, false);
            }
        }

        public static boolean shouldDisplayActiveEffects(VaultSharedData sharedData) {
            return sharedData.hasDisplayItem();
        }

        private static Vec3 randomPosCenterOfCage(BlockPos pos, RandomSource random) {
            return Vec3.atLowerCornerOf(pos).add(Mth.nextDouble(random, 0.4, 0.6), Mth.nextDouble(random, 0.4, 0.6), Mth.nextDouble(random, 0.4, 0.6));
        }

        private static Vec3 randomPosInsideCage(BlockPos pos, RandomSource random) {
            return Vec3.atLowerCornerOf(pos).add(Mth.nextDouble(random, 0.1, 0.9), Mth.nextDouble(random, 0.25, 0.75), Mth.nextDouble(random, 0.1, 0.9));
        }

        private static Vec3 keyholePos(BlockPos pos, Direction direction) {
            return Vec3.atBottomCenterOf(pos).add((double)direction.getStepX() * 0.5, 1.75, (double)direction.getStepZ() * 0.5);
        }
    }

    public static final class Server {
        private static final int UNLOCKING_DELAY_TICKS = 14;
        private static final int DISPLAY_CYCLE_TICK_RATE = 20;
        private static final int INSERT_FAIL_SOUND_BUFFER_TICKS = 15;

        public static void tick(ServerLevel world, BlockPos pos, BlockState state, VaultConfig config, VaultServerData serverData, VaultSharedData sharedData) {
            VaultState vaultState = state.getValue(VaultBlock.STATE);
            if (Server.shouldCycleDisplayItem(world.getGameTime(), vaultState)) {
                Server.cycleDisplayItemFromLootTable(world, vaultState, config, sharedData, pos);
            }
            BlockState blockState = state;
            if (world.getGameTime() >= serverData.stateUpdatingResumesAt() && !state.equals(blockState = (BlockState)blockState.setValue(VaultBlock.STATE, vaultState.tickAndGetNext(world, pos, config, serverData, sharedData)))) {
                Server.setVaultState(world, pos, state, blockState, config, sharedData);
            }
            if (serverData.isDirty || sharedData.isDirty) {
                VaultBlockEntity.setChanged(world, pos, state);
                if (sharedData.isDirty) {
                    world.sendBlockUpdated(pos, state, blockState, 2);
                }
                serverData.isDirty = false;
                sharedData.isDirty = false;
            }
        }

        public static void tryInsertKey(ServerLevel world, BlockPos pos, BlockState state, VaultConfig config, VaultServerData serverData, VaultSharedData sharedData, Player player, ItemStack stack) {
            VaultState vaultState = state.getValue(VaultBlock.STATE);
            if (!Server.canEjectReward(config, vaultState)) {
                return;
            }
            if (!Server.isValidToInsert(config, stack)) {
                Server.playInsertFailSound(world, serverData, pos, SoundEvents.VAULT_INSERT_ITEM_FAIL);
                return;
            }
            if (serverData.hasRewardedPlayer(player)) {
                Server.playInsertFailSound(world, serverData, pos, SoundEvents.VAULT_REJECT_REWARDED_PLAYER);
                return;
            }
            List<ItemStack> list = Server.resolveItemsToEject(world, config, pos, player);
            if (list.isEmpty()) {
                return;
            }
            player.awardStat(Stats.ITEM_USED.get(stack.getItem()));
            stack.consume(config.keyItem().getCount(), player);
            Server.unlock(world, state, pos, config, serverData, sharedData, list);
            serverData.addToRewardedPlayers(player);
            sharedData.updateConnectedPlayersWithinRange(world, pos, serverData, config, config.deactivationRange());
        }

        static void setVaultState(ServerLevel world, BlockPos pos, BlockState oldState, BlockState newState, VaultConfig config, VaultSharedData sharedData) {
            VaultState vaultState = oldState.getValue(VaultBlock.STATE);
            VaultState vaultState2 = newState.getValue(VaultBlock.STATE);
            world.setBlock(pos, newState, 3);
            vaultState.onTransition(world, pos, vaultState2, config, sharedData, newState.getValue(VaultBlock.OMINOUS));
        }

        static void cycleDisplayItemFromLootTable(ServerLevel world, VaultState state, VaultConfig config, VaultSharedData sharedData, BlockPos pos) {
            if (!Server.canEjectReward(config, state)) {
                sharedData.setDisplayItem(ItemStack.EMPTY);
                return;
            }
            ItemStack itemStack = Server.getRandomDisplayItemFromLootTable(world, pos, config.overrideLootTableToDisplay().orElse(config.lootTable()));
            sharedData.setDisplayItem(itemStack);
        }

        private static ItemStack getRandomDisplayItemFromLootTable(ServerLevel world, BlockPos pos, ResourceKey<LootTable> lootTable) {
            LootParams lootParams;
            LootTable lootTable2 = world.getServer().reloadableRegistries().getLootTable(lootTable);
            ObjectArrayList<ItemStack> list = lootTable2.getRandomItems(lootParams = new LootParams.Builder(world).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(pos)).create(LootContextParamSets.VAULT), world.getRandom());
            if (list.isEmpty()) {
                return ItemStack.EMPTY;
            }
            return Util.getRandom(list, world.getRandom());
        }

        private static void unlock(ServerLevel world, BlockState state, BlockPos pos, VaultConfig config, VaultServerData serverData, VaultSharedData sharedData, List<ItemStack> itemsToEject) {
            serverData.setItemsToEject(itemsToEject);
            sharedData.setDisplayItem(serverData.getNextItemToEject());
            serverData.pauseStateUpdatingUntil(world.getGameTime() + 14L);
            Server.setVaultState(world, pos, state, (BlockState)state.setValue(VaultBlock.STATE, VaultState.UNLOCKING), config, sharedData);
        }

        private static List<ItemStack> resolveItemsToEject(ServerLevel world, VaultConfig config, BlockPos pos, Player player) {
            LootTable lootTable = world.getServer().reloadableRegistries().getLootTable(config.lootTable());
            LootParams lootParams = new LootParams.Builder(world).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(pos)).withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, player).create(LootContextParamSets.VAULT);
            return lootTable.getRandomItems(lootParams);
        }

        private static boolean canEjectReward(VaultConfig config, VaultState state) {
            return config.lootTable() != BuiltInLootTables.EMPTY && !config.keyItem().isEmpty() && state != VaultState.INACTIVE;
        }

        private static boolean isValidToInsert(VaultConfig config, ItemStack stack) {
            return ItemStack.isSameItemSameComponents(stack, config.keyItem()) && stack.getCount() >= config.keyItem().getCount();
        }

        private static boolean shouldCycleDisplayItem(long time, VaultState state) {
            return time % 20L == 0L && state == VaultState.ACTIVE;
        }

        private static void playInsertFailSound(ServerLevel world, VaultServerData serverData, BlockPos pos, SoundEvent sound) {
            if (world.getGameTime() >= serverData.getLastInsertFailTimestamp() + 15L) {
                world.playSound(null, pos, sound, SoundSource.BLOCKS);
                serverData.setLastInsertFailTimestamp(world.getGameTime());
            }
        }
    }
}

