/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public final class TrialSpawner {
    public static final String NORMAL_CONFIG_TAG_NAME = "normal_config";
    public static final String OMINOUS_CONFIG_TAG_NAME = "ominous_config";
    public static final int DETECT_PLAYER_SPAWN_BUFFER = 40;
    private static final int DEFAULT_TARGET_COOLDOWN_LENGTH = 36000;
    private static final int DEFAULT_PLAYER_SCAN_RANGE = 14;
    private static final int MAX_MOB_TRACKING_DISTANCE = 47;
    private static final int MAX_MOB_TRACKING_DISTANCE_SQR = Mth.square(47);
    private static final float SPAWNING_AMBIENT_SOUND_CHANCE = 0.02f;
    private final TrialSpawnerConfig normalConfig;
    private final TrialSpawnerConfig ominousConfig;
    private final TrialSpawnerData data;
    private final int requiredPlayerRange;
    private final int targetCooldownLength;
    public final StateAccessor stateAccessor;
    private PlayerDetector playerDetector;
    private final PlayerDetector.EntitySelector entitySelector;
    private boolean overridePeacefulAndMobSpawnRule;
    private boolean isOminous;

    public Codec<TrialSpawner> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)TrialSpawnerConfig.CODEC.optionalFieldOf(NORMAL_CONFIG_TAG_NAME, (Object)TrialSpawnerConfig.DEFAULT).forGetter(TrialSpawner::getNormalConfig), (App)TrialSpawnerConfig.CODEC.optionalFieldOf(OMINOUS_CONFIG_TAG_NAME, (Object)TrialSpawnerConfig.DEFAULT).forGetter(TrialSpawner::getOminousConfigForSerialization), (App)TrialSpawnerData.MAP_CODEC.forGetter(TrialSpawner::getData), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("target_cooldown_length", (Object)36000).forGetter(TrialSpawner::getTargetCooldownLength), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)14).forGetter(TrialSpawner::getRequiredPlayerRange)).apply((Applicative)instance, (config, trialSpawnerConfig, trialSpawnerData, integer, integer2) -> new TrialSpawner((TrialSpawnerConfig)config, (TrialSpawnerConfig)trialSpawnerConfig, (TrialSpawnerData)trialSpawnerData, (int)integer, (int)integer2, this.stateAccessor, this.playerDetector, this.entitySelector)));
    }

    public TrialSpawner(StateAccessor trialSpawner, PlayerDetector entityDetector, PlayerDetector.EntitySelector entitySelector) {
        this(TrialSpawnerConfig.DEFAULT, TrialSpawnerConfig.DEFAULT, new TrialSpawnerData(), 36000, 14, trialSpawner, entityDetector, entitySelector);
    }

    public TrialSpawner(TrialSpawnerConfig normalConfig, TrialSpawnerConfig ominousConfig, TrialSpawnerData data, int cooldownLength, int entityDetectionRange, StateAccessor trialSpawner, PlayerDetector entityDetector, PlayerDetector.EntitySelector entitySelector) {
        this.normalConfig = normalConfig;
        this.ominousConfig = ominousConfig;
        this.data = data;
        this.targetCooldownLength = cooldownLength;
        this.requiredPlayerRange = entityDetectionRange;
        this.stateAccessor = trialSpawner;
        this.playerDetector = entityDetector;
        this.entitySelector = entitySelector;
    }

    public TrialSpawnerConfig getConfig() {
        return this.isOminous ? this.ominousConfig : this.normalConfig;
    }

    @VisibleForTesting
    public TrialSpawnerConfig getNormalConfig() {
        return this.normalConfig;
    }

    @VisibleForTesting
    public TrialSpawnerConfig getOminousConfig() {
        return this.ominousConfig;
    }

    private TrialSpawnerConfig getOminousConfigForSerialization() {
        return !this.ominousConfig.equals(this.normalConfig) ? this.ominousConfig : TrialSpawnerConfig.DEFAULT;
    }

    public void applyOminous(ServerLevel world, BlockPos pos) {
        world.setBlock(pos, (BlockState)world.getBlockState(pos).setValue(TrialSpawnerBlock.OMINOUS, true), 3);
        world.levelEvent(3020, pos, 1);
        this.isOminous = true;
        this.data.resetAfterBecomingOminous(this, world);
    }

    public void removeOminous(ServerLevel world, BlockPos pos) {
        world.setBlock(pos, (BlockState)world.getBlockState(pos).setValue(TrialSpawnerBlock.OMINOUS, false), 3);
        this.isOminous = false;
    }

    public boolean isOminous() {
        return this.isOminous;
    }

    public TrialSpawnerData getData() {
        return this.data;
    }

    public int getTargetCooldownLength() {
        return this.targetCooldownLength;
    }

    public int getRequiredPlayerRange() {
        return this.requiredPlayerRange;
    }

    public TrialSpawnerState getState() {
        return this.stateAccessor.getState();
    }

    public void setState(Level world, TrialSpawnerState spawnerState) {
        this.stateAccessor.setState(world, spawnerState);
    }

    public void markUpdated() {
        this.stateAccessor.markUpdated();
    }

    public PlayerDetector getPlayerDetector() {
        return this.playerDetector;
    }

    public PlayerDetector.EntitySelector getEntitySelector() {
        return this.entitySelector;
    }

    public boolean canSpawnInLevel(Level world) {
        if (this.overridePeacefulAndMobSpawnRule) {
            return true;
        }
        if (world.getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        return world.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING);
    }

    public Optional<UUID> spawnMob(ServerLevel world, BlockPos pos) {
        SpawnData.CustomSpawnRules customSpawnRules;
        double f;
        RandomSource randomSource = world.getRandom();
        SpawnData spawnData = this.data.getOrCreateNextSpawnData(this, world.getRandom());
        CompoundTag compoundTag = spawnData.entityToSpawn();
        ListTag listTag = compoundTag.getList("Pos", 6);
        Optional<EntityType<?>> optional = EntityType.by(compoundTag);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        int i = listTag.size();
        double d = i >= 1 ? listTag.getDouble(0) : (double)pos.getX() + (randomSource.nextDouble() - randomSource.nextDouble()) * (double)this.getConfig().spawnRange() + 0.5;
        double e = i >= 2 ? listTag.getDouble(1) : (double)(pos.getY() + randomSource.nextInt(3) - 1);
        double d2 = f = i >= 3 ? listTag.getDouble(2) : (double)pos.getZ() + (randomSource.nextDouble() - randomSource.nextDouble()) * (double)this.getConfig().spawnRange() + 0.5;
        if (!world.noCollision(optional.get().getSpawnAABB(d, e, f))) {
            return Optional.empty();
        }
        Vec3 vec3 = new Vec3(d, e, f);
        if (!TrialSpawner.inLineOfSight(world, pos.getCenter(), vec3)) {
            return Optional.empty();
        }
        BlockPos blockPos = BlockPos.containing(vec3);
        if (!SpawnPlacements.checkSpawnRules(optional.get(), world, MobSpawnType.TRIAL_SPAWNER, blockPos, world.getRandom())) {
            return Optional.empty();
        }
        if (spawnData.getCustomSpawnRules().isPresent() && !(customSpawnRules = spawnData.getCustomSpawnRules().get()).isValidPosition(blockPos, world)) {
            return Optional.empty();
        }
        Entity entity2 = EntityType.loadEntityRecursive(compoundTag, world, entity -> {
            entity.moveTo(d, e, f, randomSource.nextFloat() * 360.0f, 0.0f);
            return entity;
        });
        if (entity2 == null) {
            return Optional.empty();
        }
        if (entity2 instanceof Mob) {
            boolean bl;
            Mob mob = (Mob)entity2;
            if (!mob.checkSpawnObstruction(world)) {
                return Optional.empty();
            }
            boolean bl2 = bl = spawnData.getEntityToSpawn().size() == 1 && spawnData.getEntityToSpawn().contains("id", 8);
            if (bl) {
                mob.finalizeSpawn(world, world.getCurrentDifficultyAt(mob.blockPosition()), MobSpawnType.TRIAL_SPAWNER, null);
            }
            mob.setPersistenceRequired();
            spawnData.getEquipment().ifPresent(mob::equip);
        }
        if (!world.tryAddFreshEntityWithPassengers(entity2)) {
            return Optional.empty();
        }
        FlameParticle flameParticle = this.isOminous ? FlameParticle.OMINOUS : FlameParticle.NORMAL;
        world.levelEvent(3011, pos, flameParticle.encode());
        world.levelEvent(3012, blockPos, flameParticle.encode());
        world.gameEvent(entity2, GameEvent.ENTITY_PLACE, blockPos);
        return Optional.of(entity2.getUUID());
    }

    public void ejectReward(ServerLevel world, BlockPos pos, ResourceKey<LootTable> lootTable) {
        LootParams lootParams;
        LootTable lootTable2 = world.getServer().reloadableRegistries().getLootTable(lootTable);
        ObjectArrayList<ItemStack> objectArrayList = lootTable2.getRandomItems(lootParams = new LootParams.Builder(world).create(LootContextParamSets.EMPTY));
        if (!objectArrayList.isEmpty()) {
            for (ItemStack itemStack : objectArrayList) {
                DefaultDispenseItemBehavior.spawnItem(world, itemStack, 2, Direction.UP, Vec3.atBottomCenterOf(pos).relative(Direction.UP, 1.2));
            }
            world.levelEvent(3014, pos, 0);
        }
    }

    public void tickClient(Level world, BlockPos pos, boolean ominous) {
        RandomSource randomSource;
        TrialSpawnerState trialSpawnerState = this.getState();
        trialSpawnerState.emitParticles(world, pos, ominous);
        if (trialSpawnerState.hasSpinningMob()) {
            double d = Math.max(0L, this.data.nextMobSpawnsAt - world.getGameTime());
            this.data.oSpin = this.data.spin;
            this.data.spin = (this.data.spin + trialSpawnerState.spinningMobSpeed() / (d + 200.0)) % 360.0;
        }
        if (trialSpawnerState.isCapableOfSpawning() && (randomSource = world.getRandom()).nextFloat() <= 0.02f) {
            SoundEvent soundEvent = ominous ? SoundEvents.TRIAL_SPAWNER_AMBIENT_OMINOUS : SoundEvents.TRIAL_SPAWNER_AMBIENT;
            world.playLocalSound(pos, soundEvent, SoundSource.BLOCKS, randomSource.nextFloat() * 0.25f + 0.75f, randomSource.nextFloat() + 0.5f, false);
        }
    }

    public void tickServer(ServerLevel world, BlockPos pos, boolean ominous) {
        TrialSpawnerState trialSpawnerState2;
        this.isOminous = ominous;
        TrialSpawnerState trialSpawnerState = this.getState();
        if (this.data.currentMobs.removeIf(uuid -> TrialSpawner.shouldMobBeUntracked(world, pos, uuid))) {
            this.data.nextMobSpawnsAt = world.getGameTime() + (long)this.getConfig().ticksBetweenSpawn();
        }
        if ((trialSpawnerState2 = trialSpawnerState.tickAndGetNext(pos, this, world)) != trialSpawnerState) {
            this.setState(world, trialSpawnerState2);
        }
    }

    private static boolean shouldMobBeUntracked(ServerLevel world, BlockPos pos, UUID uuid) {
        Entity entity = world.getEntity(uuid);
        return entity == null || !entity.isAlive() || !entity.level().dimension().equals(world.dimension()) || entity.blockPosition().distSqr(pos) > (double)MAX_MOB_TRACKING_DISTANCE_SQR;
    }

    private static boolean inLineOfSight(Level world, Vec3 spawnerPos, Vec3 spawnPos) {
        BlockHitResult blockHitResult = world.clip(new ClipContext(spawnPos, spawnerPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        return blockHitResult.getBlockPos().equals(BlockPos.containing(spawnerPos)) || blockHitResult.getType() == HitResult.Type.MISS;
    }

    public static void addSpawnParticles(Level world, BlockPos pos, RandomSource random, SimpleParticleType particle) {
        for (int i = 0; i < 20; ++i) {
            double d = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            double e = (double)pos.getY() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            double f = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            world.addParticle(ParticleTypes.SMOKE, d, e, f, 0.0, 0.0, 0.0);
            world.addParticle(particle, d, e, f, 0.0, 0.0, 0.0);
        }
    }

    public static void addBecomeOminousParticles(Level world, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 20; ++i) {
            double d = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            double e = (double)pos.getY() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            double f = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            double g = random.nextGaussian() * 0.02;
            double h = random.nextGaussian() * 0.02;
            double j = random.nextGaussian() * 0.02;
            world.addParticle(ParticleTypes.TRIAL_OMEN, d, e, f, g, h, j);
            world.addParticle(ParticleTypes.SOUL_FIRE_FLAME, d, e, f, g, h, j);
        }
    }

    public static void addDetectPlayerParticles(Level world, BlockPos pos, RandomSource random, int playerCount, ParticleOptions particle) {
        for (int i = 0; i < 30 + Math.min(playerCount, 10) * 5; ++i) {
            double d = (double)(2.0f * random.nextFloat() - 1.0f) * 0.65;
            double e = (double)(2.0f * random.nextFloat() - 1.0f) * 0.65;
            double f = (double)pos.getX() + 0.5 + d;
            double g = (double)pos.getY() + 0.1 + (double)random.nextFloat() * 0.8;
            double h = (double)pos.getZ() + 0.5 + e;
            world.addParticle(particle, f, g, h, 0.0, 0.0, 0.0);
        }
    }

    public static void addEjectItemParticles(Level world, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 20; ++i) {
            double d = (double)pos.getX() + 0.4 + random.nextDouble() * 0.2;
            double e = (double)pos.getY() + 0.4 + random.nextDouble() * 0.2;
            double f = (double)pos.getZ() + 0.4 + random.nextDouble() * 0.2;
            double g = random.nextGaussian() * 0.02;
            double h = random.nextGaussian() * 0.02;
            double j = random.nextGaussian() * 0.02;
            world.addParticle(ParticleTypes.SMALL_FLAME, d, e, f, g, h, j * 0.25);
            world.addParticle(ParticleTypes.SMOKE, d, e, f, g, h, j);
        }
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void setPlayerDetector(PlayerDetector detector) {
        this.playerDetector = detector;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void overridePeacefulAndMobSpawnRule() {
        this.overridePeacefulAndMobSpawnRule = true;
    }

    public static interface StateAccessor {
        public void setState(Level var1, TrialSpawnerState var2);

        public TrialSpawnerState getState();

        public void markUpdated();
    }

    public static enum FlameParticle {
        NORMAL(ParticleTypes.FLAME),
        OMINOUS(ParticleTypes.SOUL_FIRE_FLAME);

        public final SimpleParticleType particleType;

        private FlameParticle(SimpleParticleType particle) {
            this.particleType = particle;
        }

        public static FlameParticle decode(int index) {
            FlameParticle[] flameParticles = FlameParticle.values();
            if (index > flameParticles.length || index < 0) {
                return NORMAL;
            }
            return flameParticles[index];
        }

        public int encode() {
            return this.ordinal();
        }
    }
}

