/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.inventory.InventoryHolder;
import org.slf4j.Logger;

public abstract class BlockEntity {
    static boolean ignoreTileUpdates;
    public Timing tickTimer = MinecraftTimings.getTileEntityTimings(this);
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    public CraftPersistentDataContainer persistentDataContainer;
    private static final Logger LOGGER;
    private final BlockEntityType<?> type;
    @Nullable
    protected Level level;
    protected final BlockPos worldPosition;
    protected boolean remove;
    private net.minecraft.world.level.block.state.BlockState blockState;
    private DataComponentMap components = DataComponentMap.EMPTY;

    public BlockEntity(BlockEntityType<?> type, BlockPos pos, net.minecraft.world.level.block.state.BlockState state) {
        this.type = type;
        this.worldPosition = pos.immutable();
        this.blockState = state;
        this.persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    }

    public static BlockPos getPosFromTag(CompoundTag nbt) {
        return new BlockPos(nbt.getInt("x"), nbt.getInt("y"), nbt.getInt("z"));
    }

    @Nullable
    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level world) {
        this.level = world;
    }

    public boolean hasLevel() {
        return this.level != null;
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.persistentDataContainer.clear();
        Tag persistentDataTag = nbt.get("PublicBukkitValues");
        if (persistentDataTag instanceof CompoundTag) {
            this.persistentDataContainer.putAll((CompoundTag)persistentDataTag);
        }
    }

    public final void loadWithComponents(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.loadAdditional(nbt, registryLookup);
        ComponentHelper.COMPONENTS_CODEC.parse(registryLookup.createSerializationContext(NbtOps.INSTANCE), (Object)nbt).resultOrPartial(s -> LOGGER.warn("Failed to load components: {}", s)).ifPresent(datacomponentmap -> {
            this.components = datacomponentmap;
        });
    }

    public final void loadCustomOnly(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.loadAdditional(nbt, registryLookup);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
    }

    public final CompoundTag saveWithFullMetadata(HolderLookup.Provider registryLookup) {
        CompoundTag nbttagcompound = this.saveWithoutMetadata(registryLookup);
        this.saveMetadata(nbttagcompound);
        return nbttagcompound;
    }

    public final CompoundTag saveWithId(HolderLookup.Provider registryLookup) {
        CompoundTag nbttagcompound = this.saveWithoutMetadata(registryLookup);
        this.saveId(nbttagcompound);
        return nbttagcompound;
    }

    public final CompoundTag saveWithoutMetadata(HolderLookup.Provider registryLookup) {
        CompoundTag nbttagcompound = new CompoundTag();
        this.saveAdditional(nbttagcompound, registryLookup);
        ComponentHelper.COMPONENTS_CODEC.encodeStart(registryLookup.createSerializationContext(NbtOps.INSTANCE), (Object)this.components).resultOrPartial(s -> LOGGER.warn("Failed to save components: {}", s)).ifPresent(nbtbase -> nbttagcompound.merge((CompoundTag)nbtbase));
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            nbttagcompound.put("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return nbttagcompound;
    }

    public final CompoundTag saveCustomOnly(HolderLookup.Provider registryLookup) {
        CompoundTag nbttagcompound = new CompoundTag();
        this.saveAdditional(nbttagcompound, registryLookup);
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            nbttagcompound.put("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return nbttagcompound;
    }

    public final CompoundTag saveCustomAndMetadata(HolderLookup.Provider registryLookup) {
        CompoundTag nbttagcompound = this.saveCustomOnly(registryLookup);
        this.saveMetadata(nbttagcompound);
        return nbttagcompound;
    }

    public void saveId(CompoundTag nbt) {
        ResourceLocation minecraftkey = BlockEntityType.getKey(this.getType());
        if (minecraftkey == null) {
            throw new RuntimeException(String.valueOf(this.getClass()) + " is missing a mapping! This is a bug!");
        }
        nbt.putString("id", minecraftkey.toString());
    }

    public static void addEntityType(CompoundTag nbt, BlockEntityType<?> type) {
        nbt.putString("id", BlockEntityType.getKey(type).toString());
    }

    public void saveToItem(ItemStack stack, HolderLookup.Provider registries) {
        CompoundTag nbttagcompound = this.saveCustomOnly(registries);
        this.removeComponentsFromTag(nbttagcompound);
        BlockItem.setBlockEntityData(stack, this.getType(), nbttagcompound);
        stack.applyComponents(this.collectComponents());
    }

    private void saveMetadata(CompoundTag nbt) {
        this.saveId(nbt);
        nbt.putInt("x", this.worldPosition.getX());
        nbt.putInt("y", this.worldPosition.getY());
        nbt.putInt("z", this.worldPosition.getZ());
    }

    @Nullable
    public static BlockEntity loadStatic(BlockPos pos, net.minecraft.world.level.block.state.BlockState state, CompoundTag nbt, HolderLookup.Provider registryLookup) {
        String s = nbt.getString("id");
        ResourceLocation minecraftkey = ResourceLocation.tryParse(s);
        if (minecraftkey == null) {
            LOGGER.error("Block entity has invalid type: {}", (Object)s);
            return null;
        }
        return BuiltInRegistries.BLOCK_ENTITY_TYPE.getOptional(minecraftkey).map(tileentitytypes -> {
            try {
                return tileentitytypes.create(pos, state);
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to create block entity {}", (Object)s, (Object)throwable);
                return null;
            }
        }).map(tileentity -> {
            try {
                tileentity.loadWithComponents(nbt, registryLookup);
                return tileentity;
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to load data for block entity {}", (Object)s, (Object)throwable);
                return null;
            }
        }).orElseGet(() -> {
            LOGGER.warn("Skipping BlockEntity with id {}", (Object)s);
            return null;
        });
    }

    public void setChanged() {
        if (this.level != null) {
            if (ignoreTileUpdates) {
                return;
            }
            BlockEntity.setChanged(this.level, this.worldPosition, this.blockState);
        }
    }

    protected static void setChanged(Level world, BlockPos pos, net.minecraft.world.level.block.state.BlockState state) {
        world.blockEntityChanged(pos);
        if (!state.isAir()) {
            world.updateNeighbourForOutputSignal(pos, state.getBlock());
        }
    }

    public BlockPos getBlockPos() {
        return this.worldPosition;
    }

    public net.minecraft.world.level.block.state.BlockState getBlockState() {
        return this.blockState;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return null;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return new CompoundTag();
    }

    public boolean isRemoved() {
        return this.remove;
    }

    public void setRemoved() {
        this.remove = true;
    }

    public void clearRemoved() {
        this.remove = false;
    }

    public boolean triggerEvent(int type, int data) {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory crashReportSection) {
        crashReportSection.setDetail("Name", () -> {
            String s = String.valueOf(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(this.getType()));
            return s + " // " + this.getClass().getCanonicalName();
        });
        if (this.level != null) {
            net.minecraft.world.level.block.state.BlockState block = this.getBlockState();
            if (block != null) {
                CrashReportCategory.populateBlockDetails(crashReportSection, this.level, this.worldPosition, block);
            }
            CrashReportCategory.populateBlockDetails(crashReportSection, this.level, this.worldPosition, this.level.getBlockState(this.worldPosition));
        }
    }

    public boolean onlyOpCanSetNbt() {
        return false;
    }

    public BlockEntityType<?> getType() {
        return this.type;
    }

    @Deprecated
    public void setBlockState(net.minecraft.world.level.block.state.BlockState state) {
        this.blockState = state;
    }

    protected void applyImplicitComponents(DataComponentInput components) {
    }

    public final void applyComponentsFromItemStack(ItemStack stack) {
        this.applyComponents(stack.getPrototype(), stack.getComponentsPatch());
    }

    public final void applyComponents(DataComponentMap defaultComponents, DataComponentPatch components) {
        this.applyComponentsSet(defaultComponents, components);
    }

    public final Set<DataComponentType<?>> applyComponentsSet(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        final HashSet set = new HashSet();
        set.add(DataComponents.BLOCK_ENTITY_DATA);
        final PatchedDataComponentMap patcheddatacomponentmap = PatchedDataComponentMap.fromPatch(datacomponentmap, datacomponentpatch);
        this.applyImplicitComponents(new DataComponentInput(){

            @Override
            @Nullable
            public <T> T get(DataComponentType<T> type) {
                set.add(type);
                return patcheddatacomponentmap.get(type);
            }

            @Override
            public <T> T getOrDefault(DataComponentType<? extends T> type, T fallback) {
                set.add(type);
                return patcheddatacomponentmap.getOrDefault(type, fallback);
            }
        });
        Objects.requireNonNull(set);
        DataComponentPatch datacomponentpatch1 = datacomponentpatch.forget(set::contains);
        this.components = datacomponentpatch1.split().added();
        set.remove(DataComponents.BLOCK_ENTITY_DATA);
        return set;
    }

    protected void collectImplicitComponents(DataComponentMap.Builder componentMapBuilder) {
    }

    @Deprecated
    public void removeComponentsFromTag(CompoundTag nbt) {
    }

    public final DataComponentMap collectComponents() {
        DataComponentMap.Builder datacomponentmap_a = DataComponentMap.builder();
        datacomponentmap_a.addAll(this.components);
        this.collectImplicitComponents(datacomponentmap_a);
        return datacomponentmap_a.build();
    }

    public DataComponentMap components() {
        return this.components;
    }

    public void setComponents(DataComponentMap components) {
        this.components = components;
    }

    @Nullable
    public static Component parseCustomNameSafe(String json, HolderLookup.Provider registryLookup) {
        try {
            return Component.Serializer.fromJson(json, registryLookup);
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to parse custom name from string '{}', discarding", (Object)json, (Object)exception);
            return null;
        }
    }

    public InventoryHolder getOwner() {
        return this.getOwner(true);
    }

    public InventoryHolder getOwner(boolean useSnapshot) {
        if (this.level == null) {
            return null;
        }
        Block block = this.level.getWorld().getBlockAt(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ());
        BlockState state = block.getState(useSnapshot);
        if (state instanceof InventoryHolder) {
            return (InventoryHolder)state;
        }
        return null;
    }

    public CompoundTag sanitizeSentNbt(CompoundTag tag) {
        tag.remove("PublicBukkitValues");
        return tag;
    }

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
        LOGGER = LogUtils.getLogger();
    }

    private static class ComponentHelper {
        public static final Codec<DataComponentMap> COMPONENTS_CODEC = DataComponentMap.CODEC.optionalFieldOf("components", (Object)DataComponentMap.EMPTY).codec();

        private ComponentHelper() {
        }
    }

    protected static interface DataComponentInput {
        @Nullable
        public <T> T get(DataComponentType<T> var1);

        public <T> T getOrDefault(DataComponentType<? extends T> var1, T var2);
    }
}

