/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.craftbukkit.block.CapturedBlockState;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.event.Event;
import org.bukkit.event.world.StructureGrowEvent;

public class SaplingBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<SaplingBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TreeGrower.CODEC.fieldOf("tree").forGetter(blocksapling -> blocksapling.treeGrower), SaplingBlock.propertiesCodec()).apply((Applicative)instance, SaplingBlock::new));
    public static final IntegerProperty STAGE = BlockStateProperties.STAGE;
    protected static final float AABB_OFFSET = 6.0f;
    protected static final VoxelShape SHAPE = Block.box(2.0, 0.0, 2.0, 14.0, 12.0, 14.0);
    protected final TreeGrower treeGrower;
    public static TreeType treeType;

    public MapCodec<? extends SaplingBlock> codec() {
        return CODEC;
    }

    protected SaplingBlock(TreeGrower generator, BlockBehaviour.Properties settings) {
        super(settings);
        this.treeGrower = generator;
        this.registerDefaultState((BlockState)this.stateDefinition.any().setValue(STAGE, 0));
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.getMaxLocalRawBrightness(pos.above()) >= 9 && random.nextFloat() < (float)world.spigotConfig.saplingModifier / 700.0f) {
            this.advanceTree(world, pos, state, random);
        }
    }

    public void advanceTree(ServerLevel world, BlockPos pos, BlockState state, RandomSource random) {
        if (state.getValue(STAGE) == 0) {
            world.setBlock(pos, (BlockState)state.cycle(STAGE), 4);
        } else if (world.captureTreeGeneration) {
            this.treeGrower.growTree(world, world.getChunkSource().getGenerator(), pos, state, random);
        } else {
            world.captureTreeGeneration = true;
            this.treeGrower.growTree(world, world.getChunkSource().getGenerator(), pos, state, random);
            world.captureTreeGeneration = false;
            if (world.capturedBlockStates.size() > 0) {
                TreeType treeType = SaplingBlock.treeType;
                SaplingBlock.treeType = null;
                Location location = CraftLocation.toBukkit(pos, (World)world.getWorld());
                ArrayList<CraftBlockState> blocks = new ArrayList<CraftBlockState>(world.capturedBlockStates.values());
                world.capturedBlockStates.clear();
                StructureGrowEvent event = null;
                if (treeType != null) {
                    event = new StructureGrowEvent(location, treeType, false, null, blocks);
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event == null || !event.isCancelled()) {
                    for (org.bukkit.block.BlockState blockState : blocks) {
                        CapturedBlockState.setBlockState(blockState);
                        world.checkCapturedTreeStateForObserverNotify(pos, (CraftBlockState)blockState);
                    }
                }
            }
        }
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return true;
    }

    @Override
    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return (double)world.random.nextFloat() < 0.45;
    }

    @Override
    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        this.advanceTree(world, pos, state, random);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(STAGE);
    }
}

