/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.block.PlayerShearBlockEvent;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class PumpkinBlock
extends Block {
    public static final MapCodec<PumpkinBlock> CODEC = PumpkinBlock.simpleCodec(PumpkinBlock::new);

    public MapCodec<PumpkinBlock> codec() {
        return CODEC;
    }

    protected PumpkinBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    protected ItemInteractionResult useItemOn(net.minecraft.world.item.ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!stack.is(Items.SHEARS)) {
            return super.useItemOn(stack, state, world, pos, player, hand, hit);
        }
        if (world.isClientSide) {
            return ItemInteractionResult.sidedSuccess(world.isClientSide);
        }
        PlayerShearBlockEvent event = new PlayerShearBlockEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos), (ItemStack)CraftItemStack.asCraftMirror(stack), CraftEquipmentSlot.getHand(hand), new ArrayList());
        event.getDrops().add(CraftItemStack.asCraftMirror(new net.minecraft.world.item.ItemStack(Items.PUMPKIN_SEEDS, 4)));
        if (!event.callEvent()) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        Direction direction = hit.getDirection();
        Direction direction2 = direction.getAxis() == Direction.Axis.Y ? player.getDirection().getOpposite() : direction;
        world.playSound(null, pos, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.setBlock(pos, (BlockState)Blocks.CARVED_PUMPKIN.defaultBlockState().setValue(CarvedPumpkinBlock.FACING, direction2), 11);
        for (ItemStack item : event.getDrops()) {
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5 + (double)direction2.getStepX() * 0.65, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5 + (double)direction2.getStepZ() * 0.65, CraftItemStack.asNMSCopy(item));
            itemEntity.setDeltaMovement(0.05 * (double)direction2.getStepX() + world.random.nextDouble() * 0.02, 0.05, 0.05 * (double)direction2.getStepZ() + world.random.nextDouble() * 0.02);
            world.addFreshEntity(itemEntity);
        }
        stack.hurtAndBreak(1, player, LivingEntity.getSlotForHand(hand));
        world.gameEvent((Entity)player, GameEvent.SHEAR, pos);
        player.awardStat(Stats.ITEM_USED.get(Items.SHEARS));
        return ItemInteractionResult.sidedSuccess(world.isClientSide);
    }
}

