/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class NetherrackBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<NetherrackBlock> CODEC = NetherrackBlock.simpleCodec(NetherrackBlock::new);

    @Override
    public MapCodec<NetherrackBlock> codec() {
        return CODEC;
    }

    public NetherrackBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    @Override
    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        if (!world.getBlockState(pos.above()).propagatesSkylightDown(world, pos)) {
            return false;
        }
        for (BlockPos blockPos : BlockPos.betweenClosed(pos.offset(-1, -1, -1), pos.offset(1, 1, 1))) {
            if (!world.getBlockState(blockPos).is(BlockTags.NYLIUM)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Override
    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    @Override
    @Override
    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        boolean bl = false;
        boolean bl2 = false;
        for (BlockPos blockPos : BlockPos.betweenClosed(pos.offset(-1, -1, -1), pos.offset(1, 1, 1))) {
            BlockState blockState = world.getBlockState(blockPos);
            if (blockState.is(Blocks.WARPED_NYLIUM)) {
                bl2 = true;
            }
            if (blockState.is(Blocks.CRIMSON_NYLIUM)) {
                bl = true;
            }
            if (!bl2 || !bl) continue;
            break;
        }
        if (bl2 && bl) {
            world.setBlock(pos, random.nextBoolean() ? Blocks.WARPED_NYLIUM.defaultBlockState() : Blocks.CRIMSON_NYLIUM.defaultBlockState(), 3);
        } else if (bl2) {
            world.setBlock(pos, Blocks.WARPED_NYLIUM.defaultBlockState(), 3);
        } else if (bl) {
            world.setBlock(pos, Blocks.CRIMSON_NYLIUM.defaultBlockState(), 3);
        }
    }

    @Override
    @Override
    public BonemealableBlock.Type getType() {
        return BonemealableBlock.Type.NEIGHBOR_SPREADER;
    }
}

