/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemEntityGetter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.entity.HumanEntity;

public interface EntityGetter
extends ChunkSystemEntityGetter {
    public List<Entity> getEntities(@Nullable Entity var1, AABB var2, Predicate<? super Entity> var3);

    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> var1, AABB var2, Predicate<? super T> var3);

    default public <T extends Entity> List<T> getEntitiesOfClass(Class<T> entityClass, AABB box, Predicate<? super T> predicate) {
        return this.getEntities(EntityTypeTest.forClass(entityClass), box, predicate);
    }

    public List<? extends Player> players();

    default public List<Entity> getEntities(@Nullable Entity except, AABB box) {
        return this.getEntities(except, box, EntitySelector.NO_SPECTATORS);
    }

    @Override
    default public List<Entity> moonrise$getHardCollidingEntities(Entity entity, AABB box, Predicate<? super Entity> predicate) {
        return this.getEntities(entity, box, predicate);
    }

    default public boolean isUnobstructed(@Nullable Entity except, VoxelShape shape) {
        if (shape.isEmpty()) {
            return true;
        }
        for (Entity entity : this.getEntities(except, shape.bounds())) {
            if (entity.isRemoved() || !entity.blocksBuilding || except != null && entity.isPassengerOfSameVehicle(except) || !Shapes.joinIsNotEmpty(shape, Shapes.create(entity.getBoundingBox()), BooleanOp.AND)) continue;
            return false;
        }
        return true;
    }

    default public <T extends Entity> List<T> getEntitiesOfClass(Class<T> entityClass, AABB box) {
        return this.getEntitiesOfClass(entityClass, box, EntitySelector.NO_SPECTATORS);
    }

    default public List<VoxelShape> getEntityCollisions(@Nullable Entity entity, AABB box) {
        if (box.getSize() < 1.0E-7) {
            return List.of();
        }
        Predicate<Entity> predicate = entity == null ? EntitySelector.CAN_BE_COLLIDED_WITH : EntitySelector.NO_SPECTATORS.and(entity::canCollideWith);
        List<Entity> list = this.getEntities(entity, box.inflate(1.0E-7), predicate);
        if (list.isEmpty()) {
            return List.of();
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)list.size());
        for (Entity entity2 : list) {
            builder.add((Object)Shapes.create(entity2.getBoundingBox()));
        }
        return builder.build();
    }

    @Nullable
    default public Player findNearbyPlayer(Entity entity, double maxDistance, @Nullable Predicate<Entity> predicate) {
        return this.getNearestPlayer(entity.getX(), entity.getY(), entity.getZ(), maxDistance, predicate);
    }

    @Nullable
    default public Player getNearestPlayer(double x, double y, double z, double maxDistance, @Nullable Predicate<Entity> targetPredicate) {
        double d = -1.0;
        Player player = null;
        for (Player player2 : this.players()) {
            if (targetPredicate != null && !targetPredicate.test(player2)) continue;
            double e = player2.distanceToSqr(x, y, z);
            if (!(maxDistance < 0.0) && !(e < maxDistance * maxDistance) || d != -1.0 && !(e < d)) continue;
            d = e;
            player = player2;
        }
        return player;
    }

    default public List<HumanEntity> findNearbyBukkitPlayers(double x, double y, double z, double radius, boolean notSpectator) {
        return this.findNearbyBukkitPlayers(x, y, z, radius, notSpectator ? EntitySelector.NO_SPECTATORS : EntitySelector.NO_CREATIVE_OR_SPECTATOR);
    }

    default public List<HumanEntity> findNearbyBukkitPlayers(double x, double y, double z, double radius, @Nullable Predicate<Entity> predicate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Player player : this.players()) {
            if (predicate != null && !predicate.test(player)) continue;
            double distanceSquared = player.distanceToSqr(x, y, z);
            if (!(radius < 0.0) && !(distanceSquared < radius * radius)) continue;
            builder.add((Object)player.getBukkitEntity());
        }
        return builder.build();
    }

    @Nullable
    default public Player getNearestPlayer(Entity entity, double maxDistance) {
        return this.getNearestPlayer(entity.getX(), entity.getY(), entity.getZ(), maxDistance, false);
    }

    @Nullable
    default public Player getNearestPlayer(double x, double y, double z, double maxDistance, boolean ignoreCreative) {
        Predicate<Entity> predicate = ignoreCreative ? EntitySelector.NO_CREATIVE_OR_SPECTATOR : EntitySelector.NO_SPECTATORS;
        return this.getNearestPlayer(x, y, z, maxDistance, predicate);
    }

    default public boolean hasNearbyAlivePlayerThatAffectsSpawning(double x, double y, double z, double range) {
        for (Player player : this.players()) {
            if (!EntitySelector.PLAYER_AFFECTS_SPAWNING.test(player)) continue;
            double distanceSqr = player.distanceToSqr(x, y, z);
            if (!(range < 0.0) && !(distanceSqr < range * range)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasNearbyAlivePlayer(double x, double y, double z, double range) {
        for (Player player : this.players()) {
            if (!EntitySelector.NO_SPECTATORS.test(player) || !EntitySelector.LIVING_ENTITY_STILL_ALIVE.test(player)) continue;
            double d = player.distanceToSqr(x, y, z);
            if (!(range < 0.0) && !(d < range * range)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public Player getNearestPlayer(TargetingConditions targetPredicate, LivingEntity entity) {
        return this.getNearestEntity(this.players(), targetPredicate, entity, entity.getX(), entity.getY(), entity.getZ());
    }

    @Nullable
    default public Player getNearestPlayer(TargetingConditions targetPredicate, LivingEntity entity, double x, double y, double z) {
        return this.getNearestEntity(this.players(), targetPredicate, entity, x, y, z);
    }

    @Nullable
    default public Player getNearestPlayer(TargetingConditions targetPredicate, double x, double y, double z) {
        return this.getNearestEntity(this.players(), targetPredicate, null, x, y, z);
    }

    @Nullable
    default public <T extends LivingEntity> T getNearestEntity(Class<? extends T> entityClass, TargetingConditions targetPredicate, @Nullable LivingEntity entity, double x, double y, double z, AABB box) {
        return (T)this.getNearestEntity(this.getEntitiesOfClass(entityClass, box, entityOfClass -> true), targetPredicate, entity, x, y, z);
    }

    @Nullable
    default public <T extends LivingEntity> T getNearestEntity(List<? extends T> entityList, TargetingConditions targetPredicate, @Nullable LivingEntity entity, double x, double y, double z) {
        double d = -1.0;
        LivingEntity livingEntity = null;
        for (LivingEntity livingEntity2 : entityList) {
            if (!targetPredicate.test(entity, livingEntity2)) continue;
            double e = livingEntity2.distanceToSqr(x, y, z);
            if (d != -1.0 && !(e < d)) continue;
            d = e;
            livingEntity = livingEntity2;
        }
        return (T)livingEntity;
    }

    default public List<Player> getNearbyPlayers(TargetingConditions targetPredicate, LivingEntity entity, AABB box) {
        ArrayList list = Lists.newArrayList();
        for (Player player : this.players()) {
            if (!box.contains(player.getX(), player.getY(), player.getZ()) || !targetPredicate.test(entity, player)) continue;
            list.add(player);
        }
        return list;
    }

    default public <T extends LivingEntity> List<T> getNearbyEntities(Class<T> entityClass, TargetingConditions targetPredicate, LivingEntity targetingEntity, AABB box) {
        List<LivingEntity> list = this.getEntitiesOfClass(entityClass, box, livingEntityx -> true);
        ArrayList list2 = Lists.newArrayList();
        for (LivingEntity livingEntity : list) {
            if (!targetPredicate.test(targetingEntity, livingEntity)) continue;
            list2.add(livingEntity);
        }
        return list2;
    }

    @Nullable
    default public Player getPlayerByUUID(UUID uuid) {
        for (int i = 0; i < this.players().size(); ++i) {
            Player player = this.players().get(i);
            if (!uuid.equals(player.getUUID())) continue;
            return player;
        }
        return null;
    }

    @Nullable
    default public Player getGlobalPlayerByUUID(UUID uuid) {
        return this.getPlayerByUUID(uuid);
    }
}

