/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockCollisions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface CollisionGetter
extends BlockGetter {
    public WorldBorder getWorldBorder();

    @Nullable
    public BlockGetter getChunkForCollisions(int var1, int var2);

    default public boolean isUnobstructed(@Nullable Entity except, VoxelShape shape) {
        return true;
    }

    default public boolean isUnobstructed(BlockState state, BlockPos pos, CollisionContext context) {
        VoxelShape voxelShape = state.getCollisionShape(this, pos, context);
        return voxelShape.isEmpty() || this.isUnobstructed(null, voxelShape.move(pos.getX(), pos.getY(), pos.getZ()));
    }

    default public boolean isUnobstructed(Entity entity) {
        return this.isUnobstructed(entity, Shapes.create(entity.getBoundingBox()));
    }

    default public boolean noCollision(AABB box) {
        return this.noCollision(null, box);
    }

    default public boolean noCollision(Entity entity) {
        return this.noCollision(entity, entity.getBoundingBox());
    }

    default public boolean noCollision(@Nullable Entity entity, AABB box) {
        for (VoxelShape voxelShape : this.getBlockCollisions(entity, box)) {
            if (voxelShape.isEmpty()) continue;
            return false;
        }
        if (!this.getEntityCollisions(entity, box).isEmpty()) {
            return false;
        }
        if (entity != null) {
            VoxelShape voxelShape2 = this.borderCollision(entity, box);
            return voxelShape2 == null || !Shapes.joinIsNotEmpty(voxelShape2, Shapes.create(box), BooleanOp.AND);
        }
        return true;
    }

    default public boolean noBlockCollision(@Nullable Entity entity, AABB box) {
        for (VoxelShape voxelShape : this.getBlockCollisions(entity, box)) {
            if (voxelShape.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public List<VoxelShape> getEntityCollisions(@Nullable Entity var1, AABB var2);

    default public Iterable<VoxelShape> getCollisions(@Nullable Entity entity, AABB box) {
        List<VoxelShape> list = this.getEntityCollisions(entity, box);
        Iterable iterable = this.getBlockCollisions(entity, box);
        return list.isEmpty() ? iterable : Iterables.concat(list, iterable);
    }

    default public Iterable<VoxelShape> getBlockCollisions(@Nullable Entity entity, AABB box) {
        return () -> new BlockCollisions<VoxelShape>(this, entity, box, false, (pos, voxelShape) -> voxelShape);
    }

    @Nullable
    private VoxelShape borderCollision(Entity entity, AABB box) {
        WorldBorder worldBorder = this.getWorldBorder();
        return worldBorder.isInsideCloseToBorder(entity, box) ? worldBorder.getCollisionShape() : null;
    }

    default public boolean collidesWithSuffocatingBlock(@Nullable Entity entity, AABB box) {
        BlockCollisions<VoxelShape> blockCollisions = new BlockCollisions<VoxelShape>(this, entity, box, true, (pos, voxelShape) -> voxelShape);
        while (blockCollisions.hasNext()) {
            if (((VoxelShape)blockCollisions.next()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    default public Optional<BlockPos> findSupportingBlock(Entity entity, AABB box) {
        BlockPos blockPos = null;
        double d = Double.MAX_VALUE;
        BlockCollisions<BlockPos> blockCollisions = new BlockCollisions<BlockPos>(this, entity, box, false, (pos, voxelShape) -> pos);
        while (blockCollisions.hasNext()) {
            BlockPos blockPos2 = (BlockPos)blockCollisions.next();
            double e = blockPos2.distToCenterSqr(entity.position());
            if (!(e < d) && (e != d || blockPos != null && blockPos.compareTo(blockPos2) >= 0)) continue;
            blockPos = blockPos2.immutable();
            d = e;
        }
        return Optional.ofNullable(blockPos);
    }

    default public Optional<Vec3> findFreePosition(@Nullable Entity entity, VoxelShape shape, Vec3 target, double x, double y, double z) {
        if (shape.isEmpty()) {
            return Optional.empty();
        }
        AABB aABB2 = shape.bounds().inflate(x, y, z);
        VoxelShape voxelShape2 = StreamSupport.stream(this.getBlockCollisions(entity, aABB2).spliterator(), false).filter(voxelShape -> this.getWorldBorder() == null || this.getWorldBorder().isWithinBounds(voxelShape.bounds())).flatMap(voxelShape -> voxelShape.toAabbs().stream()).map(aABB -> aABB.inflate(x / 2.0, y / 2.0, z / 2.0)).map(Shapes::create).reduce(Shapes.empty(), Shapes::or);
        VoxelShape voxelShape22 = Shapes.join(shape, voxelShape2, BooleanOp.ONLY_FIRST);
        return voxelShape22.closestPointTo(target);
    }
}

