/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.weather.LightningStrikeEvent;

public record SummonEntityEffect(HolderSet<EntityType<?>> entityTypes, boolean joinTeam) implements EnchantmentEntityEffect
{
    public static final MapCodec<SummonEntityEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList(Registries.ENTITY_TYPE).fieldOf("entity").forGetter(SummonEntityEffect::entityTypes), (App)Codec.BOOL.optionalFieldOf("join_team", (Object)false).forGetter(SummonEntityEffect::joinTeam)).apply((Applicative)instance, SummonEntityEffect::new));

    @Override
    public void apply(ServerLevel world, int level, EnchantedItemInUse context, Entity user, Vec3 pos) {
        Object entity1;
        Optional<Holder<EntityType<?>>> optional;
        BlockPos blockposition = BlockPos.containing(pos);
        if (Level.isInSpawnableBounds(blockposition) && !(optional = this.entityTypes().getRandomElement(world.getRandom())).isEmpty() && (entity1 = optional.get().value().create(world, null, blockposition, MobSpawnType.TRIGGERED, false, false)) != null) {
            if (entity1 instanceof LightningBolt) {
                LightningBolt entitylightning = (LightningBolt)entity1;
                LivingEntity entityliving = context.owner();
                if (entityliving instanceof ServerPlayer) {
                    ServerPlayer entityplayer = (ServerPlayer)entityliving;
                    entitylightning.setCause(entityplayer);
                }
                world.strikeLightning((Entity)entity1, context.itemStack().getItem() == Items.TRIDENT ? LightningStrikeEvent.Cause.TRIDENT : LightningStrikeEvent.Cause.ENCHANTMENT);
            } else {
                world.addFreshEntityWithPassengers(user, CreatureSpawnEvent.SpawnReason.ENCHANTMENT);
            }
            if (this.joinTeam && user.getTeam() != null) {
                world.getScoreboard().addPlayerToTeam(((Entity)entity1).getScoreboardName(), user.getTeam());
            }
            ((Entity)entity1).moveTo(pos.x, pos.y, pos.z, ((Entity)entity1).getYRot(), ((Entity)entity1).getXRot());
        }
    }

    public MapCodec<SummonEntityEffect> codec() {
        return CODEC;
    }
}

