/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record SpawnParticlesEffect(ParticleOptions particle, PositionSource horizontalPosition, PositionSource verticalPosition, VelocitySource horizontalVelocity, VelocitySource verticalVelocity, FloatProvider speed) implements EnchantmentEntityEffect
{
    public static final MapCodec<SpawnParticlesEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ParticleTypes.CODEC.fieldOf("particle").forGetter(SpawnParticlesEffect::particle), (App)PositionSource.CODEC.fieldOf("horizontal_position").forGetter(SpawnParticlesEffect::horizontalPosition), (App)PositionSource.CODEC.fieldOf("vertical_position").forGetter(SpawnParticlesEffect::verticalPosition), (App)VelocitySource.CODEC.fieldOf("horizontal_velocity").forGetter(SpawnParticlesEffect::horizontalVelocity), (App)VelocitySource.CODEC.fieldOf("vertical_velocity").forGetter(SpawnParticlesEffect::verticalVelocity), (App)FloatProvider.CODEC.optionalFieldOf("speed", (Object)ConstantFloat.ZERO).forGetter(SpawnParticlesEffect::speed)).apply((Applicative)instance, SpawnParticlesEffect::new));

    public static PositionSource offsetFromEntityPosition(float offset) {
        return new PositionSource(PositionSourceType.ENTITY_POSITION, offset, 1.0f);
    }

    public static PositionSource inBoundingBox() {
        return new PositionSource(PositionSourceType.BOUNDING_BOX, 0.0f, 1.0f);
    }

    public static VelocitySource movementScaled(float movementScale) {
        return new VelocitySource(movementScale, ConstantFloat.ZERO);
    }

    public static VelocitySource fixedVelocity(FloatProvider base) {
        return new VelocitySource(0.0f, base);
    }

    @Override
    @Override
    public void apply(ServerLevel world, int level, EnchantedItemInUse context, Entity user, Vec3 pos) {
        RandomSource randomSource = user.getRandom();
        Vec3 vec3 = user.getKnownMovement();
        float f = user.getBbWidth();
        float g = user.getBbHeight();
        world.sendParticles(this.particle, this.horizontalPosition.getCoordinate(pos.x(), pos.x(), f, randomSource), this.verticalPosition.getCoordinate(pos.y(), pos.y() + (double)(g / 2.0f), g, randomSource), this.horizontalPosition.getCoordinate(pos.z(), pos.z(), f, randomSource), 0, this.horizontalVelocity.getVelocity(vec3.x(), randomSource), this.verticalVelocity.getVelocity(vec3.y(), randomSource), this.horizontalVelocity.getVelocity(vec3.z(), randomSource), this.speed.sample(randomSource));
    }

    @Override
    public MapCodec<SpawnParticlesEffect> codec() {
        return CODEC;
    }

    public record PositionSource(PositionSourceType type, float offset, float scale) {
        public static final MapCodec<PositionSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PositionSourceType.CODEC.fieldOf("type").forGetter(PositionSource::type), (App)Codec.FLOAT.optionalFieldOf("offset", (Object)Float.valueOf(0.0f)).forGetter(PositionSource::offset), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(PositionSource::scale)).apply((Applicative)instance, PositionSource::new)).validate(source -> {
            if (source.type() == PositionSourceType.ENTITY_POSITION && source.scale() != 1.0f) {
                return DataResult.error(() -> "Cannot scale an entity position coordinate source");
            }
            return DataResult.success((Object)source);
        });

        public double getCoordinate(double entityPosition, double boundingBoxCenter, float boundingBoxSize, RandomSource random) {
            return this.type.getCoordinate(entityPosition, boundingBoxCenter, boundingBoxSize * this.scale, random) + (double)this.offset;
        }
    }

    public record VelocitySource(float movementScale, FloatProvider base) {
        public static final MapCodec<VelocitySource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("movement_scale", (Object)Float.valueOf(0.0f)).forGetter(VelocitySource::movementScale), (App)FloatProvider.CODEC.optionalFieldOf("base", (Object)ConstantFloat.ZERO).forGetter(VelocitySource::base)).apply((Applicative)instance, VelocitySource::new));

        public double getVelocity(double entityVelocity, RandomSource random) {
            return entityVelocity * (double)this.movementScale + (double)this.base.sample(random);
        }
    }

    public static enum PositionSourceType implements StringRepresentable
    {
        ENTITY_POSITION("entity_position", (entityPosition, boundingBoxCenter, boundingBoxSize, random) -> entityPosition),
        BOUNDING_BOX("in_bounding_box", (entityPosition, boundingBoxCenter, boundingBoxSize, random) -> boundingBoxCenter + (random.nextDouble() - 0.5) * (double)boundingBoxSize);

        public static final Codec<PositionSourceType> CODEC;
        private final String id;
        private final CoordinateSource source;

        private PositionSourceType(String id, CoordinateSource coordinateSource) {
            this.id = id;
            this.source = coordinateSource;
        }

        public double getCoordinate(double entityPosition, double boundingBoxCenter, float boundingBoxSize, RandomSource random) {
            return this.source.getCoordinate(entityPosition, boundingBoxCenter, boundingBoxSize, random);
        }

        @Override
        @Override
        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(PositionSourceType::values);
        }

        @FunctionalInterface
        static interface CoordinateSource {
            public double getCoordinate(double var1, double var3, float var5, RandomSource var6);
        }
    }
}

