/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public class RecipeManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final HolderLookup.Provider registries;
    public Multimap<RecipeType<?>, RecipeHolder<?>> byType = ImmutableMultimap.of();
    public Map<ResourceLocation, RecipeHolder<?>> byName = ImmutableMap.of();
    private boolean hasErrors;

    public RecipeManager(HolderLookup.Provider registryLookup) {
        super(GSON, Registries.elementsDirPath(Registries.RECIPE));
        this.registries = registryLookup;
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager manager, ProfilerFiller profiler) {
        this.hasErrors = false;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ImmutableMap.Builder com_google_common_collect_immutablemap_builder = ImmutableMap.builder();
        RegistryOps registryops = this.registries.createSerializationContext(JsonOps.INSTANCE);
        for (Map.Entry<ResourceLocation, JsonElement> entry : prepared.entrySet()) {
            ResourceLocation minecraftkey = entry.getKey();
            try {
                Recipe irecipe = (Recipe)Recipe.CODEC.parse(registryops, (Object)entry.getValue()).getOrThrow(JsonParseException::new);
                RecipeHolder<Recipe> recipeholder = new RecipeHolder<Recipe>(minecraftkey, irecipe);
                builder.put(irecipe.getType(), recipeholder);
                com_google_common_collect_immutablemap_builder.put((Object)minecraftkey, recipeholder);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                LOGGER.error("Parsing error loading recipe {}", (Object)minecraftkey, (Object)jsonparseexception);
            }
        }
        this.byType = LinkedHashMultimap.create((Multimap)builder.build());
        this.byName = Maps.newHashMap((Map)com_google_common_collect_immutablemap_builder.build());
        LOGGER.info("Loaded {} recipes", (Object)this.byName.size());
    }

    public void addRecipe(RecipeHolder<?> irecipe) {
        AsyncCatcher.catchOp("Recipe Add");
        Collection map = this.byType.get(irecipe.value().getType());
        if (this.byName.containsKey(irecipe.id())) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + String.valueOf(irecipe.id()));
        }
        map.add(irecipe);
        this.byName.put(irecipe.id(), irecipe);
    }

    public boolean hadErrorsLoading() {
        return this.hasErrors;
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> type, I input, Level world) {
        return this.getRecipeFor(type, input, world, (RecipeHolder)null);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> type, I input, Level world, @Nullable ResourceLocation id) {
        RecipeHolder<T> recipeholder = id != null ? this.byKeyTyped(type, id) : null;
        return this.getRecipeFor(type, input, world, recipeholder);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> type, I input, Level world, @Nullable RecipeHolder<T> recipe) {
        if (input.isEmpty()) {
            return Optional.empty();
        }
        if (recipe != null && recipe.value().matches(input, world)) {
            return Optional.of(recipe);
        }
        List<RecipeHolder> list = this.byType(type).stream().filter(recipeholder1 -> recipeholder1.value().matches((RecipeInput)input, world)).toList();
        return list.isEmpty() ? Optional.empty() : Optional.of(list.getLast());
    }

    public <I extends RecipeInput, T extends Recipe<I>> List<RecipeHolder<T>> getAllRecipesFor(RecipeType<T> type) {
        return List.copyOf(this.byType(type));
    }

    public <I extends RecipeInput, T extends Recipe<I>> List<RecipeHolder<T>> getRecipesFor(RecipeType<T> type, I input, Level world) {
        return this.byType(type).stream().filter(recipeholder -> recipeholder.value().matches((RecipeInput)input, world)).sorted(Comparator.comparing(recipeholder -> recipeholder.value().getResultItem(world.registryAccess()).getDescriptionId())).collect(Collectors.toList());
    }

    private <I extends RecipeInput, T extends Recipe<I>> Collection<RecipeHolder<T>> byType(RecipeType<T> type) {
        return this.byType.get(type);
    }

    public <I extends RecipeInput, T extends Recipe<I>> NonNullList<ItemStack> getRemainingItemsFor(RecipeType<T> type, I input, Level world) {
        return this.getRemainingItemsFor(type, input, world, null);
    }

    public <I extends RecipeInput, T extends Recipe<I>> NonNullList<ItemStack> getRemainingItemsFor(RecipeType<T> type, I input, Level world, @Nullable RecipeHolder<T> previousRecipe) {
        Optional<RecipeHolder<T>> optional = this.getRecipeFor(type, input, world, previousRecipe);
        if (optional.isPresent()) {
            return optional.get().value().getRemainingItems(input);
        }
        NonNullList<ItemStack> nonnulllist = NonNullList.withSize(input.size(), ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, input.getItem(i));
        }
        return nonnulllist;
    }

    public Optional<RecipeHolder<?>> byKey(ResourceLocation id) {
        return Optional.ofNullable(this.byName.get(id));
    }

    @Nullable
    private <T extends Recipe<?>> RecipeHolder<T> byKeyTyped(RecipeType<T> type, ResourceLocation id) {
        RecipeHolder<?> recipeholder = this.byName.get(id);
        return recipeholder != null && recipeholder.value().getType().equals(type) ? recipeholder : null;
    }

    public Collection<RecipeHolder<?>> getOrderedRecipes() {
        return this.byType.values();
    }

    public Collection<RecipeHolder<?>> getRecipes() {
        return this.byName.values();
    }

    public Stream<ResourceLocation> getRecipeIds() {
        return this.byName.keySet().stream();
    }

    @VisibleForTesting
    protected static RecipeHolder<?> fromJson(ResourceLocation id, JsonObject json, HolderLookup.Provider registryLookup) {
        Recipe irecipe = (Recipe)Recipe.CODEC.parse(registryLookup.createSerializationContext(JsonOps.INSTANCE), (Object)json).getOrThrow(JsonParseException::new);
        return new RecipeHolder<Recipe>(id, irecipe);
    }

    public void replaceRecipes(Iterable<RecipeHolder<?>> recipes) {
        this.hasErrors = false;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ImmutableMap.Builder com_google_common_collect_immutablemap_builder = ImmutableMap.builder();
        for (RecipeHolder<?> recipeholder : recipes) {
            RecipeType<?> recipes1 = recipeholder.value().getType();
            builder.put(recipes1, recipeholder);
            com_google_common_collect_immutablemap_builder.put((Object)recipeholder.id(), recipeholder);
        }
        this.byType = LinkedHashMultimap.create((Multimap)builder.build());
        this.byName = Maps.newHashMap((Map)com_google_common_collect_immutablemap_builder.build());
    }

    public boolean removeRecipe(ResourceLocation mcKey) {
        Iterator iter = this.byType.values().iterator();
        while (iter.hasNext()) {
            RecipeHolder recipe = (RecipeHolder)iter.next();
            if (!recipe.id().equals(mcKey)) continue;
            iter.remove();
        }
        return this.byName.remove(mcKey) != null;
    }

    public void clearRecipes() {
        this.byType = LinkedHashMultimap.create();
        this.byName = Maps.newHashMap();
    }

    public static <I extends RecipeInput, T extends Recipe<I>> CachedCheck<I, T> createCheck(final RecipeType<T> type) {
        return new CachedCheck<I, T>(){
            @Nullable
            private ResourceLocation lastRecipe;

            @Override
            public Optional<RecipeHolder<T>> getRecipeFor(I input, Level world) {
                RecipeManager craftingmanager = world.getRecipeManager();
                Optional optional = craftingmanager.getRecipeFor(type, input, world, this.lastRecipe);
                if (optional.isPresent()) {
                    RecipeHolder recipeholder = optional.get();
                    this.lastRecipe = recipeholder.id();
                    return Optional.of(recipeholder);
                }
                return Optional.empty();
            }
        };
    }

    public static interface CachedCheck<I extends RecipeInput, T extends Recipe<I>> {
        public Optional<RecipeHolder<T>> getRecipeFor(I var1, Level var2);
    }
}

