/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public record Tool(List<Rule> rules, float defaultMiningSpeed, int damagePerBlock) {
    public static final Codec<Tool> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Rule.CODEC.listOf().fieldOf("rules").forGetter(Tool::rules), (App)Codec.FLOAT.optionalFieldOf("default_mining_speed", (Object)Float.valueOf(1.0f)).forGetter(Tool::defaultMiningSpeed), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("damage_per_block", (Object)1).forGetter(Tool::damagePerBlock)).apply((Applicative)instance, Tool::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Tool> STREAM_CODEC = StreamCodec.composite(Rule.STREAM_CODEC.apply(ByteBufCodecs.list()), Tool::rules, ByteBufCodecs.FLOAT, Tool::defaultMiningSpeed, ByteBufCodecs.VAR_INT, Tool::damagePerBlock, Tool::new);

    public float getMiningSpeed(BlockState state) {
        for (Rule rule : this.rules) {
            if (!rule.speed.isPresent() || !state.is(rule.blocks)) continue;
            return rule.speed.get().floatValue();
        }
        return this.defaultMiningSpeed;
    }

    public boolean isCorrectForDrops(BlockState state) {
        for (Rule rule : this.rules) {
            if (!rule.correctForDrops.isPresent() || !state.is(rule.blocks)) continue;
            return rule.correctForDrops.get();
        }
        return false;
    }

    public record Rule(HolderSet<Block> blocks, Optional<Float> speed, Optional<Boolean> correctForDrops) {
        public static final Codec<Rule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.homogeneousList(Registries.BLOCK).fieldOf("blocks").forGetter(Rule::blocks), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("speed").forGetter(Rule::speed), (App)Codec.BOOL.optionalFieldOf("correct_for_drops").forGetter(Rule::correctForDrops)).apply((Applicative)instance, Rule::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Rule> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.holderSet(Registries.BLOCK), Rule::blocks, ByteBufCodecs.FLOAT.apply(ByteBufCodecs::optional), Rule::speed, ByteBufCodecs.BOOL.apply(ByteBufCodecs::optional), Rule::correctForDrops, Rule::new);

        public static Rule minesAndDrops(List<Block> blocks, float speed) {
            return Rule.forBlocks(blocks, Optional.of(Float.valueOf(speed)), Optional.of(true));
        }

        public static Rule minesAndDrops(TagKey<Block> blocks, float speed) {
            return Rule.forTag(blocks, Optional.of(Float.valueOf(speed)), Optional.of(true));
        }

        public static Rule deniesDrops(TagKey<Block> tag) {
            return Rule.forTag(tag, Optional.empty(), Optional.of(false));
        }

        public static Rule overrideSpeed(TagKey<Block> tag, float speed) {
            return Rule.forTag(tag, Optional.of(Float.valueOf(speed)), Optional.empty());
        }

        public static Rule overrideSpeed(List<Block> blocks, float speed) {
            return Rule.forBlocks(blocks, Optional.of(Float.valueOf(speed)), Optional.empty());
        }

        private static Rule forTag(TagKey<Block> tag, Optional<Float> speed, Optional<Boolean> correctForDrops) {
            return new Rule(BuiltInRegistries.BLOCK.getOrCreateTag(tag), speed, correctForDrops);
        }

        private static Rule forBlocks(List<Block> blocks, Optional<Float> speed, Optional<Boolean> correctForDrops) {
            return new Rule(HolderSet.direct(blocks.stream().map(Block::builtInRegistryHolder).collect(Collectors.toList())), speed, correctForDrops);
        }
    }
}

