/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public record ItemAttributeModifiers(List<Entry> modifiers, boolean showInTooltip) {
    public static final ItemAttributeModifiers EMPTY = new ItemAttributeModifiers(List.of(), true);
    private static final Codec<ItemAttributeModifiers> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Entry.CODEC.listOf().fieldOf("modifiers").forGetter(ItemAttributeModifiers::modifiers), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(ItemAttributeModifiers::showInTooltip)).apply((Applicative)instance, ItemAttributeModifiers::new));
    public static final Codec<ItemAttributeModifiers> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)Entry.CODEC.listOf(), attributeModifiers -> new ItemAttributeModifiers((List<Entry>)attributeModifiers, true));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemAttributeModifiers> STREAM_CODEC = StreamCodec.composite(Entry.STREAM_CODEC.apply(ByteBufCodecs.list()), ItemAttributeModifiers::modifiers, ByteBufCodecs.BOOL, ItemAttributeModifiers::showInTooltip, ItemAttributeModifiers::new);
    public static final DecimalFormat ATTRIBUTE_MODIFIER_FORMAT = Util.make(new DecimalFormat("#.##"), format -> format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    public ItemAttributeModifiers withTooltip(boolean showInTooltip) {
        return new ItemAttributeModifiers(this.modifiers, showInTooltip);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ItemAttributeModifiers withModifierAdded(Holder<Attribute> attribute, AttributeModifier modifier, EquipmentSlotGroup slot) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        for (Entry entry : this.modifiers) {
            if (entry.matches(attribute, modifier.id())) continue;
            builder.add((Object)entry);
        }
        builder.add((Object)new Entry(attribute, modifier, slot));
        return new ItemAttributeModifiers((List<Entry>)builder.build(), this.showInTooltip);
    }

    public void forEach(EquipmentSlotGroup slot, BiConsumer<Holder<Attribute>, AttributeModifier> attributeConsumer) {
        for (Entry entry : this.modifiers) {
            if (!entry.slot.equals(slot)) continue;
            attributeConsumer.accept(entry.attribute, entry.modifier);
        }
    }

    public void forEach(EquipmentSlot slot, BiConsumer<Holder<Attribute>, AttributeModifier> attributeConsumer) {
        for (Entry entry : this.modifiers) {
            if (!entry.slot.test(slot)) continue;
            attributeConsumer.accept(entry.attribute, entry.modifier);
        }
    }

    public double compute(double base, EquipmentSlot slot) {
        double d = base;
        for (Entry entry : this.modifiers) {
            if (!entry.slot.test(slot)) continue;
            double e = entry.modifier.amount();
            d += (switch (entry.modifier.operation()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.ADD_VALUE -> e;
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> e * base;
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> e * d;
            });
        }
        return d;
    }

    public static class Builder {
        private final ImmutableList.Builder<Entry> entries = ImmutableList.builder();

        Builder() {
        }

        public Builder add(Holder<Attribute> attribute, AttributeModifier modifier, EquipmentSlotGroup slot) {
            this.entries.add((Object)new Entry(attribute, modifier, slot));
            return this;
        }

        public ItemAttributeModifiers build() {
            return new ItemAttributeModifiers((List<Entry>)this.entries.build(), true);
        }
    }

    public record Entry(Holder<Attribute> attribute, AttributeModifier modifier, EquipmentSlotGroup slot) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Attribute.CODEC.fieldOf("type").forGetter(Entry::attribute), (App)AttributeModifier.MAP_CODEC.forGetter(Entry::modifier), (App)EquipmentSlotGroup.CODEC.optionalFieldOf("slot", (Object)EquipmentSlotGroup.ANY).forGetter(Entry::slot)).apply((Applicative)instance, Entry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = StreamCodec.composite(Attribute.STREAM_CODEC, Entry::attribute, AttributeModifier.STREAM_CODEC, Entry::modifier, EquipmentSlotGroup.STREAM_CODEC, Entry::slot, Entry::new);

        public boolean matches(Holder<Attribute> attribute, ResourceLocation modifierId) {
            return attribute.equals(this.attribute) && this.modifier.is(modifierId);
        }
    }
}

