/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public final class BundleContents
implements TooltipComponent {
    public static final BundleContents EMPTY = new BundleContents(List.of());
    public static final Codec<BundleContents> CODEC = ItemStack.CODEC.listOf().xmap(BundleContents::new, component -> component.items);
    public static final StreamCodec<RegistryFriendlyByteBuf, BundleContents> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(BundleContents::new, component -> component.items);
    private static final Fraction BUNDLE_IN_BUNDLE_WEIGHT = Fraction.getFraction((int)1, (int)16);
    private static final int NO_STACK_INDEX = -1;
    final List<ItemStack> items;
    final Fraction weight;

    BundleContents(List<ItemStack> stacks, Fraction occupancy) {
        this.items = stacks;
        this.weight = occupancy;
    }

    public BundleContents(List<ItemStack> stacks) {
        this(stacks, BundleContents.computeContentWeight(stacks));
    }

    private static Fraction computeContentWeight(List<ItemStack> stacks) {
        Fraction fraction = Fraction.ZERO;
        for (ItemStack itemStack : stacks) {
            fraction = fraction.add(BundleContents.getWeight(itemStack).multiplyBy(Fraction.getFraction((int)itemStack.getCount(), (int)1)));
        }
        return fraction;
    }

    static Fraction getWeight(ItemStack stack) {
        BundleContents bundleContents = stack.get(DataComponents.BUNDLE_CONTENTS);
        if (bundleContents != null) {
            return BUNDLE_IN_BUNDLE_WEIGHT.add(bundleContents.weight());
        }
        List list = stack.getOrDefault(DataComponents.BEES, List.of());
        if (!list.isEmpty()) {
            return Fraction.ONE;
        }
        return Fraction.getFraction((int)1, (int)stack.getMaxStackSize());
    }

    public ItemStack getItemUnsafe(int index) {
        return this.items.get(index);
    }

    public Stream<ItemStack> itemCopyStream() {
        return this.items.stream().map(ItemStack::copy);
    }

    public Iterable<ItemStack> items() {
        return this.items;
    }

    public Iterable<ItemStack> itemsCopy() {
        return Lists.transform(this.items, ItemStack::copy);
    }

    public int size() {
        return this.items.size();
    }

    public Fraction weight() {
        return this.weight;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BundleContents) {
            BundleContents bundleContents = (BundleContents)object;
            return this.weight.equals((Object)bundleContents.weight) && ItemStack.listMatches(this.items, bundleContents.items);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ItemStack.hashStackList(this.items);
    }

    @Override
    public String toString() {
        return "BundleContents" + String.valueOf(this.items);
    }

    public static class Mutable {
        private final List<ItemStack> items;
        private Fraction weight;

        public Mutable(BundleContents base) {
            this.items = new ArrayList<ItemStack>(base.items);
            this.weight = base.weight;
        }

        public Mutable clearItems() {
            this.items.clear();
            this.weight = Fraction.ZERO;
            return this;
        }

        private int findStackIndex(ItemStack stack) {
            if (!stack.isStackable()) {
                return -1;
            }
            for (int i = 0; i < this.items.size(); ++i) {
                if (!ItemStack.isSameItemSameComponents(this.items.get(i), stack)) continue;
                return i;
            }
            return -1;
        }

        private int getMaxAmountToAdd(ItemStack stack) {
            Fraction fraction = Fraction.ONE.subtract(this.weight);
            return Math.max(fraction.divideBy(BundleContents.getWeight(stack)).intValue(), 0);
        }

        public int tryInsert(ItemStack stack) {
            if (stack.isEmpty() || !stack.getItem().canFitInsideContainerItems()) {
                return 0;
            }
            int i = Math.min(stack.getCount(), this.getMaxAmountToAdd(stack));
            if (i == 0) {
                return 0;
            }
            this.weight = this.weight.add(BundleContents.getWeight(stack).multiplyBy(Fraction.getFraction((int)i, (int)1)));
            int j = this.findStackIndex(stack);
            if (j != -1) {
                ItemStack itemStack = this.items.remove(j);
                ItemStack itemStack2 = itemStack.copyWithCount(itemStack.getCount() + i);
                stack.shrink(i);
                this.items.add(0, itemStack2);
            } else {
                this.items.add(0, stack.split(i));
            }
            return i;
        }

        public int tryTransfer(Slot slot, Player player) {
            ItemStack itemStack = slot.getItem();
            int i = this.getMaxAmountToAdd(itemStack);
            return this.tryInsert(slot.safeTake(itemStack.getCount(), i, player));
        }

        @Nullable
        public ItemStack removeOne() {
            if (this.items.isEmpty()) {
                return null;
            }
            ItemStack itemStack = this.items.remove(0).copy();
            this.weight = this.weight.subtract(BundleContents.getWeight(itemStack).multiplyBy(Fraction.getFraction((int)itemStack.getCount(), (int)1)));
            return itemStack;
        }

        public Fraction weight() {
            return this.weight;
        }

        public BundleContents toImmutable() {
            return new BundleContents(List.copyOf(this.items), this.weight);
        }
    }
}

