/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.destroystokyo.paper.event.player.PlayerLaunchProjectileEvent;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Projectile;

public class TridentItem
extends Item
implements ProjectileItem {
    public static final int THROW_THRESHOLD_TIME = 10;
    public static final float BASE_DAMAGE = 8.0f;
    public static final float SHOOT_POWER = 2.5f;

    public TridentItem(Item.Properties settings) {
        super(settings);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, 8.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, -2.9f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    @Override
    public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player miner) {
        return !miner.isCreative();
    }

    @Override
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }

    @Override
    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            float f;
            Player entityhuman = (Player)user;
            int j = this.getUseDuration(stack, user) - remainingUseTicks;
            if (j >= 10 && ((f = EnchantmentHelper.getTridentSpinAttackStrength(stack, entityhuman)) <= 0.0f || entityhuman.isInWaterOrRain()) && !TridentItem.isTooDamagedToUse(stack)) {
                Holder<SoundEvent> holder = EnchantmentHelper.pickHighestLevel(stack, EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
                if (!world.isClientSide) {
                    if (f == 0.0f) {
                        PlayerLaunchProjectileEvent event;
                        ThrownTrident entitythrowntrident = new ThrownTrident(world, entityhuman, stack);
                        entitythrowntrident.shootFromRotation(entityhuman, entityhuman.getXRot(), entityhuman.getYRot(), 0.0f, 2.5f, 1.0f);
                        if (entityhuman.hasInfiniteMaterials()) {
                            entitythrowntrident.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        if (!(event = new PlayerLaunchProjectileEvent((org.bukkit.entity.Player)entityhuman.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(stack), (Projectile)entitythrowntrident.getBukkitEntity())).callEvent() || !world.addFreshEntity(entitythrowntrident)) {
                            if (entityhuman instanceof ServerPlayer) {
                                ((ServerPlayer)entityhuman).getBukkitEntity().updateInventory();
                            }
                            return;
                        }
                        if (event.shouldConsume()) {
                            stack.hurtAndBreak(1, entityhuman, LivingEntity.getSlotForHand(user.getUsedItemHand()));
                        }
                        entitythrowntrident.pickupItemStack = stack.copy();
                        world.playSound((Player)null, entitythrowntrident, holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (event.shouldConsume() && !entityhuman.hasInfiniteMaterials()) {
                            entityhuman.getInventory().removeItem(stack);
                        }
                    } else {
                        stack.hurtAndBreak(1, entityhuman, LivingEntity.getSlotForHand(user.getUsedItemHand()));
                    }
                }
                entityhuman.awardStat(Stats.ITEM_USED.get(this));
                if (f > 0.0f) {
                    float f1 = entityhuman.getYRot();
                    float f2 = entityhuman.getXRot();
                    float f3 = -Mth.sin(f1 * ((float)Math.PI / 180)) * Mth.cos(f2 * ((float)Math.PI / 180));
                    float f4 = -Mth.sin(f2 * ((float)Math.PI / 180));
                    float f5 = Mth.cos(f1 * ((float)Math.PI / 180)) * Mth.cos(f2 * ((float)Math.PI / 180));
                    float f6 = Mth.sqrt(f3 * f3 + f4 * f4 + f5 * f5);
                    CraftEventFactory.callPlayerRiptideEvent(entityhuman, stack, f3 *= f / f6, f4 *= f / f6, f5 *= f / f6);
                    entityhuman.push(f3, f4, f5);
                    entityhuman.startAutoSpinAttack(20, 8.0f, stack);
                    if (entityhuman.onGround()) {
                        float f7 = 1.1999999f;
                        entityhuman.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    world.playSound((Player)null, entityhuman, holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemstack = user.getItemInHand(hand);
        if (TridentItem.isTooDamagedToUse(itemstack)) {
            return InteractionResultHolder.fail(itemstack);
        }
        if (EnchantmentHelper.getTridentSpinAttackStrength(itemstack, user) > 0.0f && !user.isInWaterOrRain()) {
            return InteractionResultHolder.fail(itemstack);
        }
        user.startUsingItem(hand);
        return InteractionResultHolder.consume(itemstack);
    }

    private static boolean isTooDamagedToUse(ItemStack stack) {
        return stack.getDamageValue() >= stack.getMaxDamage() - 1;
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return true;
    }

    @Override
    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }

    @Override
    public int getEnchantmentValue() {
        return 1;
    }

    @Override
    public net.minecraft.world.entity.projectile.Projectile asProjectile(Level world, Position pos, ItemStack stack, Direction direction) {
        ThrownTrident entitythrowntrident = new ThrownTrident(world, pos.x(), pos.y(), pos.z(), stack.copyWithCount(1));
        entitythrowntrident.pickup = AbstractArrow.Pickup.ALLOWED;
        return entitythrowntrident;
    }
}

