/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;

public class TieredItem
extends Item {
    private final Tier tier;

    public TieredItem(Tier material, Item.Properties settings) {
        super(settings.durability(material.getUses()));
        this.tier = material;
    }

    public Tier getTier() {
        return this.tier;
    }

    @Override
    @Override
    public int getEnchantmentValue() {
        return this.tier.getEnchantmentValue();
    }

    @Override
    @Override
    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        return this.tier.getRepairIngredient().test(ingredient) || super.isValidRepairItem(stack, ingredient);
    }
}

