/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemUtils {
    public static InteractionResultHolder<ItemStack> startUsingInstantly(Level world, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResultHolder.consume(player.getItemInHand(hand));
    }

    public static ItemStack createFilledResult(ItemStack inputStack, Player player, ItemStack outputStack, boolean creativeOverride) {
        boolean bl = player.hasInfiniteMaterials();
        if (creativeOverride && bl) {
            if (!player.getInventory().contains(outputStack)) {
                player.getInventory().add(outputStack);
            }
            return inputStack;
        }
        inputStack.consume(1, player);
        if (inputStack.isEmpty()) {
            return outputStack;
        }
        if (!player.getInventory().add(outputStack)) {
            player.drop(outputStack, false);
        }
        return inputStack;
    }

    public static ItemStack createFilledResult(ItemStack inputStack, Player player, ItemStack outputStack) {
        return ItemUtils.createFilledResult(inputStack, player, outputStack, true);
    }

    public static void onContainerDestroyed(ItemEntity itemEntity, Iterable<ItemStack> contents) {
        Level level = itemEntity.level();
        if (level.isClientSide) {
            return;
        }
        contents.forEach(stack -> level.addFreshEntity(new ItemEntity(level, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), (ItemStack)stack)));
    }
}

