/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.destroystokyo.paper.event.player.PlayerLaunchProjectileEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;

public class EnderpearlItem
extends Item {
    public EnderpearlItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, net.minecraft.world.entity.player.Player user, InteractionHand hand) {
        ItemStack itemstack = user.getItemInHand(hand);
        if (!world.isClientSide) {
            ThrownEnderpearl entityenderpearl = new ThrownEnderpearl(world, user);
            entityenderpearl.setItem(itemstack);
            entityenderpearl.shootFromRotation(user, user.getXRot(), user.getYRot(), 0.0f, 1.5f, 1.0f);
            PlayerLaunchProjectileEvent event = new PlayerLaunchProjectileEvent((Player)user.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(itemstack), (Projectile)entityenderpearl.getBukkitEntity());
            if (event.callEvent() && world.addFreshEntity(entityenderpearl)) {
                if (event.shouldConsume()) {
                    itemstack.consume(1, user);
                } else if (user instanceof ServerPlayer) {
                    ((ServerPlayer)user).getBukkitEntity().updateInventory();
                }
                world.playSound((net.minecraft.world.entity.player.Player)null, user.getX(), user.getY(), user.getZ(), SoundEvents.ENDER_PEARL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (Entity.SHARED_RANDOM.nextFloat() * 0.4f + 0.8f));
                user.awardStat(Stats.ITEM_USED.get(this));
                user.getCooldowns().addCooldown(this, 20);
            } else {
                if (user instanceof ServerPlayer) {
                    ((ServerPlayer)user).getBukkitEntity().updateInventory();
                }
                return InteractionResultHolder.fail(itemstack);
            }
        }
        return InteractionResultHolder.sidedSuccess(itemstack, world.isClientSide());
    }
}

