/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class BoatItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private final Boat.Type type;
    private final boolean hasChest;

    public BoatItem(boolean chest, Boat.Type type, Item.Properties settings) {
        super(settings);
        this.hasChest = chest;
        this.type = type;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemstack = user.getItemInHand(hand);
        BlockHitResult movingobjectpositionblock = BoatItem.getPlayerPOVHitResult(world, user, ClipContext.Fluid.ANY);
        if (movingobjectpositionblock.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass(itemstack);
        }
        Vec3 vec3d = user.getViewVector(1.0f);
        double d0 = 5.0;
        List<Entity> list = world.getEntities(user, user.getBoundingBox().expandTowards(vec3d.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec3d1 = user.getEyePosition();
            for (Entity entity : list) {
                AABB axisalignedbb = entity.getBoundingBox().inflate(entity.getPickRadius());
                if (!axisalignedbb.contains(vec3d1)) continue;
                return InteractionResultHolder.pass(itemstack);
            }
        }
        if (movingobjectpositionblock.getType() == HitResult.Type.BLOCK) {
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(user, Action.RIGHT_CLICK_BLOCK, movingobjectpositionblock.getBlockPos(), movingobjectpositionblock.getDirection(), itemstack, false, hand, movingobjectpositionblock.getLocation());
            if (event.isCancelled()) {
                return InteractionResultHolder.pass(itemstack);
            }
            Boat entityboat = this.getBoat(world, movingobjectpositionblock, itemstack, user);
            entityboat.setVariant(this.type);
            entityboat.setYRot(user.getYRot());
            if (!world.noCollision(entityboat, entityboat.getBoundingBox())) {
                return InteractionResultHolder.fail(itemstack);
            }
            if (!world.isClientSide) {
                if (CraftEventFactory.callEntityPlaceEvent(world, movingobjectpositionblock.getBlockPos(), movingobjectpositionblock.getDirection(), user, entityboat, hand).isCancelled()) {
                    return InteractionResultHolder.fail(itemstack);
                }
                if (!world.addFreshEntity(entityboat)) {
                    return InteractionResultHolder.pass(itemstack);
                }
                world.gameEvent((Entity)user, GameEvent.ENTITY_PLACE, movingobjectpositionblock.getLocation());
                itemstack.consume(1, user);
            }
            user.awardStat(Stats.ITEM_USED.get(this));
            return InteractionResultHolder.sidedSuccess(itemstack, world.isClientSide());
        }
        return InteractionResultHolder.pass(itemstack);
    }

    private Boat getBoat(Level world, HitResult hitResult, ItemStack stack, Player player) {
        Boat object;
        Vec3 vec3d = hitResult.getLocation();
        Boat boat = object = this.hasChest ? new ChestBoat(world, vec3d.x, vec3d.y, vec3d.z) : new Boat(world, vec3d.x, vec3d.y, vec3d.z);
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            EntityType.createDefaultStackConfig(worldserver, stack, player).accept((ChestBoat)object);
        }
        return object;
    }
}

