/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;

public class ItemCombinerMenuSlotDefinition {
    private final List<SlotDefinition> slots;
    private final SlotDefinition resultSlot;

    ItemCombinerMenuSlotDefinition(List<SlotDefinition> inputSlots, SlotDefinition resultSlot) {
        if (inputSlots.isEmpty() || resultSlot.equals(SlotDefinition.EMPTY)) {
            throw new IllegalArgumentException("Need to define both inputSlots and resultSlot");
        }
        this.slots = inputSlots;
        this.resultSlot = resultSlot;
    }

    public static Builder create() {
        return new Builder();
    }

    public boolean hasSlot(int index) {
        return this.slots.size() >= index;
    }

    public SlotDefinition getSlot(int index) {
        return this.slots.get(index);
    }

    public SlotDefinition getResultSlot() {
        return this.resultSlot;
    }

    public List<SlotDefinition> getSlots() {
        return this.slots;
    }

    public int getNumOfInputSlots() {
        return this.slots.size();
    }

    public int getResultSlotIndex() {
        return this.getNumOfInputSlots();
    }

    public List<Integer> getInputSlotIndexes() {
        return this.slots.stream().map(SlotDefinition::slotIndex).collect(Collectors.toList());
    }

    public record SlotDefinition(int slotIndex, int x, int y, Predicate<ItemStack> mayPlace) {
        static final SlotDefinition EMPTY = new SlotDefinition(0, 0, 0, stack -> true);
    }

    public static class Builder {
        private final List<SlotDefinition> slots = new ArrayList<SlotDefinition>();
        private SlotDefinition resultSlot = SlotDefinition.EMPTY;

        public Builder withSlot(int slotId, int x, int y, Predicate<ItemStack> mayPlace) {
            this.slots.add(new SlotDefinition(slotId, x, y, mayPlace));
            return this;
        }

        public Builder withResultSlot(int slotId, int x, int y) {
            this.resultSlot = new SlotDefinition(slotId, x, y, stack -> false);
            return this;
        }

        public ItemCombinerMenuSlotDefinition build() {
            return new ItemCombinerMenuSlotDefinition(this.slots, this.resultSlot);
        }
    }
}

