/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class MinecartSpawner
extends AbstractMinecart {
    private final BaseSpawner spawner = new BaseSpawner(){

        @Override
        @Override
        public void broadcastEvent(Level world, BlockPos pos, int status) {
            world.broadcastEntityEvent(MinecartSpawner.this, (byte)status);
        }
    };
    private final Runnable ticker;

    public MinecartSpawner(EntityType<? extends MinecartSpawner> type, Level world) {
        super(type, world);
        this.ticker = this.createTicker(world);
    }

    public MinecartSpawner(Level world, double x, double y, double z) {
        super(EntityType.SPAWNER_MINECART, world, x, y, z);
        this.ticker = this.createTicker(world);
    }

    @Override
    @Override
    protected Item getDropItem() {
        return Items.MINECART;
    }

    private Runnable createTicker(Level world) {
        return world instanceof ServerLevel ? () -> this.spawner.serverTick((ServerLevel)world, this.blockPosition()) : () -> this.spawner.clientTick(world, this.blockPosition());
    }

    @Override
    @Override
    public AbstractMinecart.Type getMinecartType() {
        return AbstractMinecart.Type.SPAWNER;
    }

    @Override
    @Override
    public BlockState getDefaultDisplayBlockState() {
        return Blocks.SPAWNER.defaultBlockState();
    }

    @Override
    @Override
    protected void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.spawner.load(this.level(), this.blockPosition(), nbt);
    }

    @Override
    @Override
    protected void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        this.spawner.save(nbt);
    }

    @Override
    @Override
    public void handleEntityEvent(byte status) {
        this.spawner.onEventTriggered(this.level(), status);
    }

    @Override
    @Override
    public void tick() {
        super.tick();
        this.ticker.run();
    }

    public BaseSpawner getSpawner() {
        return this.spawner;
    }

    @Override
    @Override
    public boolean onlyOpCanSetNbt() {
        return true;
    }
}

