/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftItem;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;

public abstract class AbstractArrow
extends Projectile {
    private static final double ARROW_BASE_DAMAGE = 2.0;
    private static final EntityDataAccessor<Byte> ID_FLAGS = SynchedEntityData.defineId(AbstractArrow.class, EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> PIERCE_LEVEL = SynchedEntityData.defineId(AbstractArrow.class, EntityDataSerializers.BYTE);
    private static final int FLAG_CRIT = 1;
    private static final int FLAG_NOPHYSICS = 2;
    @Nullable
    private BlockState lastState;
    public boolean inGround;
    protected int inGroundTime;
    public Pickup pickup = Pickup.DISALLOWED;
    public int shakeTime;
    public int life;
    private double baseDamage = 2.0;
    public SoundEvent soundEvent = this.getDefaultHitGroundSoundEvent();
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    @Nullable
    private List<Entity> piercedAndKilledEntities;
    public ItemStack pickupItemStack = this.getDefaultPickupItem();
    @Nullable
    public ItemStack firedFromWeapon = null;

    @Override
    public void inactiveTick() {
        if (this.inGround) {
            ++this.life;
        }
        super.inactiveTick();
    }

    protected AbstractArrow(EntityType<? extends AbstractArrow> type, Level world) {
        super((EntityType<? extends Projectile>)type, world);
    }

    protected AbstractArrow(EntityType<? extends AbstractArrow> type, double x, double y, double z, Level world, ItemStack stack, @Nullable ItemStack weapon) {
        this(type, x, y, z, world, stack, weapon, null);
    }

    protected AbstractArrow(EntityType<? extends AbstractArrow> entitytypes, double d0, double d1, double d2, Level world, ItemStack itemstack, @Nullable ItemStack itemstack1, @Nullable LivingEntity ownerEntity) {
        this(entitytypes, world);
        this.setOwner(ownerEntity);
        this.pickupItemStack = itemstack.copy();
        this.setCustomName(itemstack.get(DataComponents.CUSTOM_NAME));
        Unit unit = itemstack.remove(DataComponents.INTANGIBLE_PROJECTILE);
        if (unit != null) {
            this.pickup = Pickup.CREATIVE_ONLY;
        }
        this.setPos(d0, d1, d2);
        if (itemstack1 != null && world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (itemstack1.isEmpty()) {
                throw new IllegalArgumentException("Invalid weapon firing an arrow");
            }
            this.firedFromWeapon = itemstack1.copy();
            int i = EnchantmentHelper.getPiercingCount(worldserver, itemstack1, this.pickupItemStack);
            if (i > 0) {
                this.setPierceLevel((byte)i);
            }
            EnchantmentHelper.onProjectileSpawned(worldserver, itemstack1, this, item -> {
                this.firedFromWeapon = null;
            });
        }
    }

    protected AbstractArrow(EntityType<? extends AbstractArrow> type, LivingEntity owner, Level world, ItemStack stack, @Nullable ItemStack shotFrom) {
        this(type, owner.getX(), owner.getEyeY() - (double)0.1f, owner.getZ(), world, stack, shotFrom, owner);
    }

    public void setSoundEvent(SoundEvent sound) {
        this.soundEvent = sound;
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double distance) {
        double d1 = this.getBoundingBox().getSize() * 10.0;
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return distance < (d1 *= 64.0 * AbstractArrow.getViewScale()) * d1;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ID_FLAGS, (byte)0);
        builder.define(PIERCE_LEVEL, (byte)0);
    }

    @Override
    public void shoot(double x, double y, double z, float power, float uncertainty) {
        super.shoot(x, y, z, power, uncertainty);
        this.life = 0;
    }

    @Override
    public void lerpTo(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.setPos(x, y, z);
        this.setRot(yaw, pitch);
    }

    @Override
    public void lerpMotion(double x, double y, double z) {
        super.lerpMotion(x, y, z);
        this.life = 0;
    }

    @Override
    public void tick() {
        Vec3 vec3d1;
        VoxelShape voxelshape;
        super.tick();
        boolean flag = this.isNoPhysics();
        Vec3 vec3d = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double d0 = vec3d.horizontalDistance();
            this.setYRot((float)(Mth.atan2(vec3d.x, vec3d.z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2(vec3d.y, d0) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        BlockPos blockposition = this.blockPosition();
        BlockState iblockdata = this.level().getBlockState(blockposition);
        if (!(iblockdata.isAir() || flag || (voxelshape = iblockdata.getCollisionShape(this.level(), blockposition)).isEmpty())) {
            vec3d1 = this.position();
            for (AABB axisalignedbb : voxelshape.toAabbs()) {
                if (!axisalignedbb.move(blockposition).contains(vec3d1)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (this.isInWaterOrRain() || iblockdata.is(Blocks.POWDER_SNOW)) {
            this.clearFire();
        }
        if (this.inGround && !flag) {
            if (this.lastState != iblockdata && this.shouldFall()) {
                this.startFalling();
            } else if (!this.level().isClientSide) {
                this.tickDespawn();
            }
            ++this.inGroundTime;
        } else {
            if (this.tickCount > 200) {
                this.tickDespawn();
            }
            this.inGroundTime = 0;
            Vec3 vec3d2 = this.position();
            vec3d1 = vec3d2.add(vec3d);
            HitResult object = this.level().clip(new ClipContext(vec3d2, vec3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this));
            if (((HitResult)object).getType() != HitResult.Type.MISS) {
                vec3d1 = ((HitResult)object).getLocation();
            }
            while (!this.isRemoved()) {
                EntityHitResult movingobjectpositionentity = this.findHitEntity(vec3d2, vec3d1);
                if (movingobjectpositionentity != null) {
                    object = movingobjectpositionentity;
                }
                if (object != null && ((HitResult)object).getType() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)object).getEntity();
                    Entity entity1 = this.getOwner();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).canHarmPlayer((Player)entity)) {
                        object = null;
                        movingobjectpositionentity = null;
                    }
                }
                if (object != null && !flag) {
                    ProjectileDeflection projectiledeflection = this.preHitTargetOrDeflectSelf(object);
                    this.hasImpulse = true;
                    if (projectiledeflection != ProjectileDeflection.NONE) break;
                }
                if (movingobjectpositionentity == null || this.getPierceLevel() <= 0) break;
                object = null;
            }
            vec3d = this.getDeltaMovement();
            double d1 = vec3d.x;
            double d2 = vec3d.y;
            double d3 = vec3d.z;
            if (this.isCritArrow()) {
                for (int i = 0; i < 4; ++i) {
                    this.level().addParticle(ParticleTypes.CRIT, this.getX() + d1 * (double)i / 4.0, this.getY() + d2 * (double)i / 4.0, this.getZ() + d3 * (double)i / 4.0, -d1, -d2 + 0.2, -d3);
                }
            }
            double d4 = this.getX() + d1;
            double d5 = this.getY() + d2;
            double d6 = this.getZ() + d3;
            double d7 = vec3d.horizontalDistance();
            if (flag) {
                this.setYRot((float)(Mth.atan2(-d1, -d3) * 57.2957763671875));
            } else {
                this.setYRot((float)(Mth.atan2(d1, d3) * 57.2957763671875));
            }
            this.setXRot((float)(Mth.atan2(d2, d7) * 57.2957763671875));
            this.setXRot(AbstractArrow.lerpRotation(this.xRotO, this.getXRot()));
            this.setYRot(AbstractArrow.lerpRotation(this.yRotO, this.getYRot()));
            float f = 0.99f;
            if (this.isInWater()) {
                for (int j = 0; j < 4; ++j) {
                    float f1 = 0.25f;
                    this.level().addParticle(ParticleTypes.BUBBLE, d4 - d1 * 0.25, d5 - d2 * 0.25, d6 - d3 * 0.25, d1, d2, d3);
                }
                f = this.getWaterInertia();
            }
            this.setDeltaMovement(vec3d.scale(f));
            if (!flag) {
                this.applyGravity();
            }
            this.setPos(d4, d5, d6);
            this.checkInsideBlocks();
        }
    }

    @Override
    public ProjectileDeflection preHitTargetOrDeflectSelf(HitResult hitResult) {
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            if (this.hitCancelled && this.getPierceLevel() > 0) {
                if (this.piercingIgnoreEntityIds == null) {
                    this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
                }
                this.piercingIgnoreEntityIds.add(entityHitResult.getEntity().getId());
            }
        }
        return super.preHitTargetOrDeflectSelf(hitResult);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.05;
    }

    private boolean shouldFall() {
        return this.inGround && this.level().noCollision(new AABB(this.position(), this.position()).inflate(0.06));
    }

    private void startFalling() {
        this.inGround = false;
        Vec3 vec3d = this.getDeltaMovement();
        this.setDeltaMovement(vec3d.multiply(this.random.nextFloat() * 0.2f, this.random.nextFloat() * 0.2f, this.random.nextFloat() * 0.2f));
        this.life = 0;
    }

    @Override
    public void move(MoverType movementType, Vec3 movement) {
        super.move(movementType, movement);
        if (movementType != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    protected void tickDespawn() {
        ++this.life;
        if (this.life >= (this.pickup == Pickup.CREATIVE_ONLY ? this.level().paperConfig().entities.spawning.creativeArrowDespawnRate.value() : (this.pickup == Pickup.DISALLOWED ? this.level().paperConfig().entities.spawning.nonPlayerArrowDespawnRate.value() : (this instanceof ThrownTrident ? this.level().spigotConfig.tridentDespawnRate : this.level().spigotConfig.arrowDespawnRate)))) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    private void resetPiercedEntities() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        Level world;
        super.onHitEntity(entityHitResult);
        Entity entity = entityHitResult.getEntity();
        float f = (float)this.getDeltaMovement().length();
        double d0 = this.baseDamage;
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().arrow(this, entity1 != null ? entity1 : this);
        if (this.getWeaponItem() != null && (world = this.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            d0 = EnchantmentHelper.modifyDamage(worldserver, this.getWeaponItem(), entity, damagesource, (float)d0);
        }
        int i = Mth.ceil(Mth.clamp((double)f * d0, 0.0, 2.147483647E9));
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1) {
                this.discard(EntityRemoveEvent.Cause.HIT);
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.getId());
        }
        if (this.isCritArrow()) {
            long j = this.random.nextInt(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        if (entity1 instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)entity1;
            entityliving.setLastHurtMob(entity);
        }
        if (this.isCritArrow()) {
            damagesource = damagesource.critical();
        }
        boolean flag = entity.getType() == EntityType.ENDERMAN;
        int k = entity.getRemainingFireTicks();
        if (this.isOnFire() && !flag) {
            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5.0f);
            Bukkit.getPluginManager().callEvent((Event)combustEvent);
            if (!combustEvent.isCancelled()) {
                entity.igniteForSeconds(combustEvent.getDuration(), false);
            }
        }
        if (entity.hurt(damagesource, i)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity entityliving1 = (LivingEntity)entity;
                if (!this.level().isClientSide && this.getPierceLevel() <= 0) {
                    entityliving1.setArrowCount(entityliving1.getArrowCount() + 1);
                }
                this.doKnockback(entityliving1, damagesource);
                Level world1 = this.level();
                if (world1 instanceof ServerLevel) {
                    ServerLevel worldserver1 = (ServerLevel)world1;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource(worldserver1, entityliving1, damagesource, this.getWeaponItem());
                }
                this.doPostHurtEffects(entityliving1);
                if (entityliving1 != entity1 && entityliving1 instanceof Player && entity1 instanceof ServerPlayer && !this.isSilent()) {
                    ((ServerPlayer)entity1).connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                }
                if (!entity.isAlive() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add(entityliving1);
                }
                if (!this.level().isClientSide && entity1 instanceof ServerPlayer) {
                    ServerPlayer entityplayer = (ServerPlayer)entity1;
                    if (this.piercedAndKilledEntities != null && this.shotFromCrossbow()) {
                        CriteriaTriggers.KILLED_BY_CROSSBOW.trigger(entityplayer, this.piercedAndKilledEntities);
                    } else if (!entity.isAlive() && this.shotFromCrossbow()) {
                        CriteriaTriggers.KILLED_BY_CROSSBOW.trigger(entityplayer, Arrays.asList(entity));
                    }
                }
            }
            this.playSound(this.soundEvent, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.discard(EntityRemoveEvent.Cause.HIT);
            }
        } else {
            entity.setRemainingFireTicks(k);
            this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), false);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                if (this.pickup == Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard(EntityRemoveEvent.Cause.HIT);
            }
        }
    }

    protected void doKnockback(LivingEntity target, DamageSource source) {
        float f;
        Level world;
        if (this.firedFromWeapon != null && (world = this.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            f = EnchantmentHelper.modifyKnockback(worldserver, this.firedFromWeapon, target, source, 0.0f);
        } else {
            f = 0.0f;
        }
        double d0 = f;
        if (d0 > 0.0) {
            double d1 = Math.max(0.0, 1.0 - target.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3d = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(d0 * 0.6 * d1);
            if (vec3d.lengthSqr() > 0.0) {
                target.push(vec3d.x, 0.1, vec3d.z, this);
            }
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult blockHitResult) {
        this.lastState = this.level().getBlockState(blockHitResult.getBlockPos());
        super.onHitBlock(blockHitResult);
        Vec3 vec3d = blockHitResult.getLocation().subtract(this.getX(), this.getY(), this.getZ());
        this.setDeltaMovement(vec3d);
        ItemStack itemstack = this.getWeaponItem();
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (itemstack != null) {
                this.hitBlockEnchantmentEffects(worldserver, blockHitResult, itemstack);
            }
        }
        Vec3 vec3d1 = vec3d.normalize().scale(0.05f);
        this.setPosRaw(this.getX() - vec3d1.x, this.getY() - vec3d1.y, this.getZ() - vec3d1.z);
        this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        this.inGround = true;
        this.shakeTime = 7;
        this.setCritArrow(false);
        this.setPierceLevel((byte)0);
        this.setSoundEvent(SoundEvents.ARROW_HIT);
        this.resetPiercedEntities();
    }

    protected void hitBlockEnchantmentEffects(ServerLevel world, BlockHitResult blockHitResult, ItemStack weaponStack) {
        LivingEntity entityliving1;
        Vec3 vec3d = blockHitResult.getBlockPos().clampLocationWithin(blockHitResult.getLocation());
        Entity entity = this.getOwner();
        LivingEntity entityliving = entity instanceof LivingEntity ? (entityliving1 = (LivingEntity)entity) : null;
        EnchantmentHelper.onHitBlock(world, weaponStack, entityliving, this, null, vec3d, world.getBlockState(blockHitResult.getBlockPos()), item -> {
            this.firedFromWeapon = null;
        });
    }

    @Override
    public ItemStack getWeaponItem() {
        return this.firedFromWeapon;
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.ARROW_HIT;
    }

    protected final SoundEvent getHitGroundSoundEvent() {
        return this.soundEvent;
    }

    protected void doPostHurtEffects(LivingEntity target) {
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 currentPosition, Vec3 nextPosition) {
        return ProjectileUtil.getEntityHitResult(this.level(), this, currentPosition, nextPosition, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), this::canHitEntity);
    }

    @Override
    public boolean canHitEntity(Entity entity) {
        return super.canHitEntity(entity) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(entity.getId()));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putShort("life", (short)this.life);
        if (this.lastState != null) {
            nbt.put("inBlockState", NbtUtils.writeBlockState(this.lastState));
        }
        nbt.putByte("shake", (byte)this.shakeTime);
        nbt.putBoolean("inGround", this.inGround);
        nbt.putByte("pickup", (byte)this.pickup.ordinal());
        nbt.putDouble("damage", this.baseDamage);
        nbt.putBoolean("crit", this.isCritArrow());
        nbt.putByte("PierceLevel", this.getPierceLevel());
        nbt.putString("SoundEvent", BuiltInRegistries.SOUND_EVENT.getKey(this.soundEvent).toString());
        nbt.put("item", this.pickupItemStack.save(this.registryAccess()));
        if (this.firedFromWeapon != null) {
            nbt.put("weapon", this.firedFromWeapon.save(this.registryAccess(), new CompoundTag()));
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.life = nbt.getShort("life");
        if (nbt.contains("inBlockState", 10)) {
            this.lastState = NbtUtils.readBlockState(this.level().holderLookup(Registries.BLOCK), nbt.getCompound("inBlockState"));
        }
        this.shakeTime = nbt.getByte("shake") & 0xFF;
        this.inGround = nbt.getBoolean("inGround");
        if (nbt.contains("damage", 99)) {
            this.baseDamage = nbt.getDouble("damage");
        }
        this.pickup = Pickup.byOrdinal(nbt.getByte("pickup"));
        this.setCritArrow(nbt.getBoolean("crit"));
        this.setPierceLevel(nbt.getByte("PierceLevel"));
        if (nbt.contains("SoundEvent", 8)) {
            this.soundEvent = BuiltInRegistries.SOUND_EVENT.getOptional(ResourceLocation.tryParse(nbt.getString("SoundEvent"))).orElse(this.getDefaultHitGroundSoundEvent());
        }
        if (nbt.contains("item", 10)) {
            this.setPickupItemStack(ItemStack.parse(this.registryAccess(), nbt.getCompound("item")).orElse(this.getDefaultPickupItem()));
        } else {
            this.setPickupItemStack(this.getDefaultPickupItem());
        }
        this.firedFromWeapon = nbt.contains("weapon", 10) ? (ItemStack)ItemStack.parse(this.registryAccess(), nbt.getCompound("weapon")).orElse(null) : null;
    }

    @Override
    public void setOwner(@Nullable Entity entity) {
        super.setOwner(entity);
        Entity entity1 = entity;
        boolean b0 = false;
        Pickup entityarrow_pickupstatus = this.pickup;
        Entity entity2 = entity1;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Player.class, OminousItemSpawner.class}, (Object)entity2, n)) {
            case 0: {
                Player entityhuman = (Player)entity2;
                if (this.pickup != Pickup.DISALLOWED) {
                    b0 = true;
                    break;
                }
                entityarrow_pickupstatus = Pickup.ALLOWED;
                break;
            }
            case 1: {
                OminousItemSpawner ominousitemspawner = (OminousItemSpawner)entity2;
                entityarrow_pickupstatus = Pickup.DISALLOWED;
                break;
            }
            default: {
                entityarrow_pickupstatus = this.pickup;
                break;
            }
        }
        this.pickup = entityarrow_pickupstatus;
    }

    @Override
    public void playerTouch(Player player) {
        if (!this.level().isClientSide && (this.inGround || this.isNoPhysics()) && this.shakeTime <= 0) {
            ItemStack itemstack = this.getPickupItem();
            if (this.pickup == Pickup.ALLOWED && !itemstack.isEmpty() && player.getInventory().canHold(itemstack) > 0) {
                ItemEntity item = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), itemstack);
                PlayerPickupArrowEvent event = new PlayerPickupArrowEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (Item)new CraftItem(this.level().getCraftServer(), item), (org.bukkit.entity.AbstractArrow)this.getBukkitEntity());
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = item.getItem();
            }
            if (this.pickup == Pickup.ALLOWED && player.getInventory().add(itemstack) || this.pickup == Pickup.CREATIVE_ONLY && player.getAbilities().instabuild) {
                player.take(this, 1);
                this.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    protected boolean tryPickup(Player player) {
        return switch (this.pickup.ordinal()) {
            case 0 -> false;
            case 1 -> player.getInventory().add(this.getPickupItem());
            case 2 -> player.hasInfiniteMaterials();
            default -> throw new MatchException(null, null);
        };
    }

    public ItemStack getPickupItem() {
        return this.pickupItemStack.copy();
    }

    protected abstract ItemStack getDefaultPickupItem();

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public ItemStack getPickupItemStackOrigin() {
        return this.pickupItemStack;
    }

    public void setBaseDamage(double damage) {
        this.baseDamage = damage;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    @Override
    public boolean isAttackable() {
        return this.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE);
    }

    public void setCritArrow(boolean critical) {
        this.setFlag(1, critical);
    }

    public void setPierceLevel(byte level) {
        this.entityData.set(PIERCE_LEVEL, level);
    }

    private void setFlag(int index, boolean flag) {
        byte b0 = this.entityData.get(ID_FLAGS);
        if (flag) {
            this.entityData.set(ID_FLAGS, (byte)(b0 | index));
        } else {
            this.entityData.set(ID_FLAGS, (byte)(b0 & ~index));
        }
    }

    public void setPickupItemStack(ItemStack stack) {
        this.pickupItemStack = !stack.isEmpty() ? stack : this.getDefaultPickupItem();
    }

    public boolean isCritArrow() {
        byte b0 = this.entityData.get(ID_FLAGS);
        return (b0 & 1) != 0;
    }

    public boolean shotFromCrossbow() {
        return this.firedFromWeapon != null && this.firedFromWeapon.is(Items.CROSSBOW);
    }

    public byte getPierceLevel() {
        return this.entityData.get(PIERCE_LEVEL);
    }

    public void setBaseDamageFromMob(float damageModifier) {
        this.setBaseDamage((double)(damageModifier * 2.0f) + this.random.triangle((double)this.level().getDifficulty().getId() * 0.11, 0.57425));
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public void setNoPhysics(boolean noClip) {
        this.noPhysics = noClip;
        this.setFlag(2, noClip);
    }

    public boolean isNoPhysics() {
        return !this.level().isClientSide ? this.noPhysics : (this.entityData.get(ID_FLAGS) & 2) != 0;
    }

    @Override
    public boolean isPickable() {
        return super.isPickable() && !this.inGround;
    }

    @Override
    public SlotAccess getSlot(int mappedIndex) {
        return mappedIndex == 0 ? SlotAccess.of(this::getPickupItemStackOrigin, this::setPickupItemStack) : super.getSlot(mappedIndex);
    }

    public static enum Pickup {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY;


        public static Pickup byOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal > Pickup.values().length) {
                ordinal = 0;
            }
            return Pickup.values()[ordinal];
        }
    }
}

