/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import io.papermc.paper.event.entity.ShulkerDuplicateEvent;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Shulker
extends AbstractGolem
implements VariantHolder<Optional<DyeColor>>,
Enemy {
    private static final ResourceLocation COVERED_ARMOR_MODIFIER_ID = ResourceLocation.withDefaultNamespace("covered");
    private static final AttributeModifier COVERED_ARMOR_MODIFIER = new AttributeModifier(COVERED_ARMOR_MODIFIER_ID, 20.0, AttributeModifier.Operation.ADD_VALUE);
    protected static final EntityDataAccessor<Direction> DATA_ATTACH_FACE_ID = SynchedEntityData.defineId(Shulker.class, EntityDataSerializers.DIRECTION);
    protected static final EntityDataAccessor<Byte> DATA_PEEK_ID = SynchedEntityData.defineId(Shulker.class, EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Byte> DATA_COLOR_ID = SynchedEntityData.defineId(Shulker.class, EntityDataSerializers.BYTE);
    private static final int TELEPORT_STEPS = 6;
    private static final byte NO_COLOR = 16;
    private static final byte DEFAULT_COLOR = 16;
    private static final int MAX_TELEPORT_DISTANCE = 8;
    private static final int OTHER_SHULKER_SCAN_RADIUS = 8;
    private static final int OTHER_SHULKER_LIMIT = 5;
    private static final float PEEK_PER_TICK = 0.05f;
    static final Vector3f FORWARD = Util.make(() -> {
        Vec3i baseblockposition = Direction.SOUTH.getNormal();
        return new Vector3f((float)baseblockposition.getX(), (float)baseblockposition.getY(), (float)baseblockposition.getZ());
    });
    private static final float MAX_SCALE = 3.0f;
    private float currentPeekAmountO;
    private float currentPeekAmount;
    @Nullable
    private BlockPos clientOldAttachPosition;
    private int clientSideTeleportInterpolation;
    private static final float MAX_LID_OPEN = 1.0f;

    public Shulker(EntityType<? extends Shulker> type, Level world) {
        super((EntityType<? extends AbstractGolem>)type, world);
        this.xpReward = 5;
        this.lookControl = new ShulkerLookControl(this);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new LookAtPlayerGoal(this, Player.class, 8.0f, 0.02f, true));
        this.goalSelector.addGoal(4, new ShulkerAttackGoal());
        this.goalSelector.addGoal(7, new ShulkerPeekGoal());
        this.goalSelector.addGoal(8, new RandomLookAroundGoal(this));
        this.targetSelector.addGoal(1, new HurtByTargetGoal(this, this.getClass()).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, new ShulkerNearestAttackGoal(this));
        this.targetSelector.addGoal(3, new ShulkerDefenseAttackGoal(this));
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.SHULKER_AMBIENT;
    }

    @Override
    public void playAmbientSound() {
        if (!this.isClosed()) {
            super.playAmbientSound();
        }
    }

    @Override
    public SoundEvent getDeathSound() {
        return SoundEvents.SHULKER_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return this.isClosed() ? SoundEvents.SHULKER_HURT_CLOSED : SoundEvents.SHULKER_HURT;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ATTACH_FACE_ID, Direction.DOWN);
        builder.define(DATA_PEEK_ID, (byte)0);
        builder.define(DATA_COLOR_ID, (byte)16);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0);
    }

    @Override
    protected BodyRotationControl createBodyControl() {
        return new ShulkerBodyRotationControl(this);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setAttachFace(Direction.from3DDataValue(nbt.getByte("AttachFace")));
        this.entityData.set(DATA_PEEK_ID, nbt.getByte("Peek"));
        if (nbt.contains("Color", 99)) {
            this.entityData.set(DATA_COLOR_ID, nbt.getByte("Color"));
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putByte("AttachFace", (byte)this.getAttachFace().get3DDataValue());
        nbt.putByte("Peek", this.entityData.get(DATA_PEEK_ID));
        nbt.putByte("Color", this.entityData.get(DATA_COLOR_ID));
    }

    @Override
    public void tick() {
        super.tick();
        if (!(this.level().isClientSide || this.isPassenger() || this.canStayAt(this.blockPosition(), this.getAttachFace()))) {
            this.findNewAttachment();
        }
        if (this.updatePeekAmount()) {
            this.onPeekAmountChange();
        }
        if (this.level().isClientSide) {
            if (this.clientSideTeleportInterpolation > 0) {
                --this.clientSideTeleportInterpolation;
            } else {
                this.clientOldAttachPosition = null;
            }
        }
    }

    private void findNewAttachment() {
        Direction enumdirection = this.findAttachableSurface(this.blockPosition());
        if (enumdirection != null) {
            this.setAttachFace(enumdirection);
        } else {
            this.teleportSomewhere();
        }
    }

    @Override
    protected AABB makeBoundingBox() {
        float f = Shulker.getPhysicalPeek(this.currentPeekAmount);
        Direction enumdirection = this.getAttachFace().getOpposite();
        float f1 = this.getBbWidth() / 2.0f;
        return Shulker.getProgressAabb(this.getScale(), enumdirection, f).move(this.getX() - (double)f1, this.getY(), this.getZ() - (double)f1);
    }

    private static float getPhysicalPeek(float openProgress) {
        return 0.5f - Mth.sin((0.5f + openProgress) * (float)Math.PI) * 0.5f;
    }

    private boolean updatePeekAmount() {
        this.currentPeekAmountO = this.currentPeekAmount;
        float f = (float)this.getRawPeekAmount() * 0.01f;
        if (this.currentPeekAmount == f) {
            return false;
        }
        this.currentPeekAmount = this.currentPeekAmount > f ? Mth.clamp(this.currentPeekAmount - 0.05f, f, 1.0f) : Mth.clamp(this.currentPeekAmount + 0.05f, 0.0f, f);
        return true;
    }

    private void onPeekAmountChange() {
        this.reapplyPosition();
        float f = Shulker.getPhysicalPeek(this.currentPeekAmount);
        float f1 = Shulker.getPhysicalPeek(this.currentPeekAmountO);
        Direction enumdirection = this.getAttachFace().getOpposite();
        float f2 = (f - f1) * this.getScale();
        if (f2 > 0.0f) {
            List<Entity> list = this.level().getEntities(this, Shulker.getProgressDeltaAabb(this.getScale(), enumdirection, f1, f).move(this.getX() - 0.5, this.getY(), this.getZ() - 0.5), EntitySelector.NO_SPECTATORS.and(entity -> !entity.isPassengerOfSameVehicle(this)));
            for (Entity entity2 : list) {
                if (entity2 instanceof Shulker || entity2.noPhysics) continue;
                entity2.move(MoverType.SHULKER, new Vec3(f2 * (float)enumdirection.getStepX(), f2 * (float)enumdirection.getStepY(), f2 * (float)enumdirection.getStepZ()));
            }
        }
    }

    public static AABB getProgressAabb(float scale, Direction facing, float extraLength) {
        return Shulker.getProgressDeltaAabb(scale, facing, -1.0f, extraLength);
    }

    public static AABB getProgressDeltaAabb(float scale, Direction facing, float prevExtraLength, float extraLength) {
        AABB axisalignedbb = new AABB(0.0, 0.0, 0.0, scale, scale, scale);
        double d0 = Math.max(prevExtraLength, extraLength);
        double d1 = Math.min(prevExtraLength, extraLength);
        return axisalignedbb.expandTowards((double)facing.getStepX() * d0 * (double)scale, (double)facing.getStepY() * d0 * (double)scale, (double)facing.getStepZ() * d0 * (double)scale).contract((double)(-facing.getStepX()) * (1.0 + d1) * (double)scale, (double)(-facing.getStepY()) * (1.0 + d1) * (double)scale, (double)(-facing.getStepZ()) * (1.0 + d1) * (double)scale);
    }

    @Override
    public boolean startRiding(Entity entity, boolean force) {
        if (this.level().isClientSide()) {
            this.clientOldAttachPosition = null;
            this.clientSideTeleportInterpolation = 0;
        }
        this.setAttachFace(Direction.DOWN);
        return super.startRiding(entity, force);
    }

    @Override
    public void stopRiding() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        super.stopRiding(suppressCancellation);
        if (this.level().isClientSide) {
            this.clientOldAttachPosition = this.blockPosition();
        }
        this.yBodyRotO = 0.0f;
        this.yBodyRot = 0.0f;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        this.setYRot(0.0f);
        this.yHeadRot = this.getYRot();
        this.setOldPosAndRot();
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    @Override
    public void move(MoverType movementType, Vec3 movement) {
        if (movementType == MoverType.SHULKER_BOX) {
            this.teleportSomewhere();
        } else {
            super.move(movementType, movement);
        }
    }

    @Override
    public Vec3 getDeltaMovement() {
        return Vec3.ZERO;
    }

    @Override
    public void setDeltaMovement(Vec3 velocity) {
    }

    @Override
    public void setPos(double x, double y, double z) {
        BlockPos blockposition1;
        BlockPos blockposition = this.blockPosition();
        if (this.isPassenger()) {
            super.setPos(x, y, z);
        } else {
            super.setPos((double)Mth.floor(x) + 0.5, Mth.floor(y + 0.5), (double)Mth.floor(z) + 0.5);
        }
        if (this.tickCount != 0 && !(blockposition1 = this.blockPosition()).equals(blockposition)) {
            this.entityData.set(DATA_PEEK_ID, (byte)0);
            this.hasImpulse = true;
            if (this.level().isClientSide && !this.isPassenger() && !blockposition1.equals(this.clientOldAttachPosition)) {
                this.clientOldAttachPosition = blockposition;
                this.clientSideTeleportInterpolation = 6;
                this.xOld = this.getX();
                this.yOld = this.getY();
                this.zOld = this.getZ();
            }
        }
    }

    @Nullable
    protected Direction findAttachableSurface(BlockPos pos) {
        for (Direction enumdirection : Direction.values()) {
            if (!this.canStayAt(pos, enumdirection)) continue;
            return enumdirection;
        }
        return null;
    }

    boolean canStayAt(BlockPos pos, Direction direction) {
        if (this.isPositionBlocked(pos)) {
            return false;
        }
        Direction enumdirection1 = direction.getOpposite();
        if (!this.level().loadedAndEntityCanStandOnFace(pos.relative(direction), this, enumdirection1)) {
            return false;
        }
        AABB axisalignedbb = Shulker.getProgressAabb(this.getScale(), enumdirection1, 1.0f).move(pos).deflate(1.0E-6);
        return this.level().noCollision(this, axisalignedbb);
    }

    private boolean isPositionBlocked(BlockPos pos) {
        BlockState iblockdata = this.level().getBlockState(pos);
        if (iblockdata.isAir()) {
            return false;
        }
        boolean flag = iblockdata.is(Blocks.MOVING_PISTON) && pos.equals(this.blockPosition());
        return !flag;
    }

    protected boolean teleportSomewhere() {
        if (!this.isNoAi() && this.isAlive()) {
            BlockPos blockposition = this.blockPosition();
            for (int i = 0; i < 5; ++i) {
                Direction enumdirection;
                BlockPos blockposition1 = blockposition.offset(Mth.randomBetweenInclusive(this.random, -8, 8), Mth.randomBetweenInclusive(this.random, -8, 8), Mth.randomBetweenInclusive(this.random, -8, 8));
                if (blockposition1.getY() <= this.level().getMinBuildHeight() || !this.level().isEmptyBlock(blockposition1) || !this.level().getWorldBorder().isWithinBounds(blockposition1) || !this.level().noCollision(this, new AABB(blockposition1).deflate(1.0E-6)) || (enumdirection = this.findAttachableSurface(blockposition1)) == null) continue;
                EntityTeleportEvent teleportEvent = CraftEventFactory.callEntityTeleportEvent(this, blockposition1.getX(), blockposition1.getY(), blockposition1.getZ());
                if (teleportEvent.isCancelled() || teleportEvent.getTo() == null) {
                    return false;
                }
                blockposition1 = CraftLocation.toBlockPosition(teleportEvent.getTo());
                this.unRide();
                this.setAttachFace(enumdirection);
                this.playSound(SoundEvents.SHULKER_TELEPORT, 1.0f, 1.0f);
                this.setPos((double)blockposition1.getX() + 0.5, blockposition1.getY(), (double)blockposition1.getZ() + 0.5);
                this.level().gameEvent(GameEvent.TELEPORT, blockposition, GameEvent.Context.of(this));
                this.entityData.set(DATA_PEEK_ID, (byte)0);
                this.setTarget(null);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void lerpTo(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.lerpSteps = 0;
        this.setPos(x, y, z);
        this.setRot(yaw, pitch);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        Entity entity;
        if (this.isClosed() && (entity = source.getDirectEntity()) instanceof AbstractArrow) {
            return false;
        }
        if (!super.hurt(source, amount)) {
            return false;
        }
        if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.5 && this.random.nextInt(4) == 0) {
            this.teleportSomewhere();
        } else if (source.is(DamageTypeTags.IS_PROJECTILE) && (entity = source.getDirectEntity()) != null && entity.getType() == EntityType.SHULKER_BULLET) {
            this.hitByShulkerBullet();
        }
        return true;
    }

    private boolean isClosed() {
        return this.getRawPeekAmount() == 0;
    }

    private void hitByShulkerBullet() {
        Vec3 vec3d = this.position();
        AABB axisalignedbb = this.getBoundingBox();
        if (!this.isClosed() && this.teleportSomewhere()) {
            Shulker entityshulker;
            int i = this.level().getEntities(EntityType.SHULKER, axisalignedbb.inflate(8.0), Entity::isAlive).size();
            float f = (float)(i - 1) / 5.0f;
            if (this.level().random.nextFloat() >= f && (entityshulker = EntityType.SHULKER.create(this.level())) != null) {
                entityshulker.setVariant((Optional<DyeColor>)this.getVariant());
                entityshulker.moveTo(vec3d);
                if (!new ShulkerDuplicateEvent((org.bukkit.entity.Shulker)entityshulker.getBukkitEntity(), (org.bukkit.entity.Shulker)this.getBukkitEntity()).callEvent()) {
                    return;
                }
                this.level().addFreshEntity(entityshulker, CreatureSpawnEvent.SpawnReason.BREEDING);
            }
        }
    }

    @Override
    public boolean canBeCollidedWith() {
        return this.isAlive();
    }

    public Direction getAttachFace() {
        return this.entityData.get(DATA_ATTACH_FACE_ID);
    }

    public void setAttachFace(Direction face) {
        this.entityData.set(DATA_ATTACH_FACE_ID, face);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (DATA_ATTACH_FACE_ID.equals(data)) {
            this.setBoundingBox(this.makeBoundingBox());
        }
        super.onSyncedDataUpdated(data);
    }

    public int getRawPeekAmount() {
        return this.entityData.get(DATA_PEEK_ID).byteValue();
    }

    public void setRawPeekAmount(int peekAmount) {
        if (!this.level().isClientSide) {
            this.getAttribute(Attributes.ARMOR).removeModifier(COVERED_ARMOR_MODIFIER_ID);
            if (peekAmount == 0) {
                this.getAttribute(Attributes.ARMOR).addPermanentModifier(COVERED_ARMOR_MODIFIER);
                this.playSound(SoundEvents.SHULKER_CLOSE, 1.0f, 1.0f);
                this.gameEvent(GameEvent.CONTAINER_CLOSE);
            } else {
                this.playSound(SoundEvents.SHULKER_OPEN, 1.0f, 1.0f);
                this.gameEvent(GameEvent.CONTAINER_OPEN);
            }
        }
        this.entityData.set(DATA_PEEK_ID, (byte)peekAmount);
    }

    public float getClientPeekAmount(float delta) {
        return Mth.lerp(delta, this.currentPeekAmountO, this.currentPeekAmount);
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        this.yBodyRot = 0.0f;
        this.yBodyRotO = 0.0f;
    }

    @Override
    public int getMaxHeadXRot() {
        return 180;
    }

    @Override
    public int getMaxHeadYRot() {
        return 180;
    }

    @Override
    public void push(Entity entity) {
    }

    public Optional<Vec3> getRenderPosition(float tickDelta) {
        if (this.clientOldAttachPosition != null && this.clientSideTeleportInterpolation > 0) {
            double d0 = (double)((float)this.clientSideTeleportInterpolation - tickDelta) / 6.0;
            d0 *= d0;
            BlockPos blockposition = this.blockPosition();
            double d1 = (double)(blockposition.getX() - this.clientOldAttachPosition.getX()) * d0;
            double d2 = (double)(blockposition.getY() - this.clientOldAttachPosition.getY()) * d0;
            double d3 = (double)(blockposition.getZ() - this.clientOldAttachPosition.getZ()) * d0;
            return Optional.of(new Vec3(-d1, -d2, -d3));
        }
        return Optional.empty();
    }

    @Override
    protected float sanitizeScale(float scale) {
        return Math.min(scale, 3.0f);
    }

    @Override
    public void setVariant(Optional<DyeColor> variant) {
        this.entityData.set(DATA_COLOR_ID, variant.map(enumcolor -> (byte)enumcolor.getId()).orElse((byte)16));
    }

    @Override
    public Optional<DyeColor> getVariant() {
        return Optional.ofNullable(this.getColor());
    }

    @Nullable
    public DyeColor getColor() {
        byte b0 = this.entityData.get(DATA_COLOR_ID);
        return b0 != 16 && b0 <= 15 ? DyeColor.byId(b0) : null;
    }

    private class ShulkerLookControl
    extends LookControl {
        public ShulkerLookControl(Mob entity) {
            super(entity);
        }

        @Override
        protected void clampHeadRotationToBody() {
        }

        @Override
        protected Optional<Float> getYRotD() {
            Direction enumdirection = Shulker.this.getAttachFace().getOpposite();
            Vector3f vector3f = enumdirection.getRotation().transform(new Vector3f((Vector3fc)FORWARD));
            Vec3i baseblockposition = enumdirection.getNormal();
            Vector3f vector3f1 = new Vector3f((float)baseblockposition.getX(), (float)baseblockposition.getY(), (float)baseblockposition.getZ());
            vector3f1.cross((Vector3fc)vector3f);
            double d0 = this.wantedX - this.mob.getX();
            double d1 = this.wantedY - this.mob.getEyeY();
            double d2 = this.wantedZ - this.mob.getZ();
            Vector3f vector3f2 = new Vector3f((float)d0, (float)d1, (float)d2);
            float f = vector3f1.dot((Vector3fc)vector3f2);
            float f1 = vector3f.dot((Vector3fc)vector3f2);
            return Math.abs(f) <= 1.0E-5f && Math.abs(f1) <= 1.0E-5f ? Optional.empty() : Optional.of(Float.valueOf((float)(Mth.atan2(-f, f1) * 57.2957763671875)));
        }

        @Override
        protected Optional<Float> getXRotD() {
            return Optional.of(Float.valueOf(0.0f));
        }
    }

    private class ShulkerAttackGoal
    extends Goal {
        private int attackTime;

        public ShulkerAttackGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean canUse() {
            LivingEntity entityliving = Shulker.this.getTarget();
            return entityliving != null && entityliving.isAlive() ? Shulker.this.level().getDifficulty() != Difficulty.PEACEFUL : false;
        }

        @Override
        public void start() {
            this.attackTime = 20;
            Shulker.this.setRawPeekAmount(100);
        }

        @Override
        public void stop() {
            Shulker.this.setRawPeekAmount(0);
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            if (Shulker.this.level().getDifficulty() != Difficulty.PEACEFUL) {
                --this.attackTime;
                LivingEntity entityliving = Shulker.this.getTarget();
                if (entityliving != null) {
                    Shulker.this.getLookControl().setLookAt(entityliving, 180.0f, 180.0f);
                    double d0 = Shulker.this.distanceToSqr(entityliving);
                    if (d0 < 400.0) {
                        if (this.attackTime <= 0) {
                            this.attackTime = 20 + Shulker.this.random.nextInt(10) * 20 / 2;
                            Shulker.this.level().addFreshEntity(new ShulkerBullet(Shulker.this.level(), Shulker.this, entityliving, Shulker.this.getAttachFace().getAxis()));
                            Shulker.this.playSound(SoundEvents.SHULKER_SHOOT, 2.0f, (Shulker.this.random.nextFloat() - Shulker.this.random.nextFloat()) * 0.2f + 1.0f);
                        }
                    } else {
                        Shulker.this.setTarget(null);
                    }
                    super.tick();
                }
            }
        }
    }

    private class ShulkerPeekGoal
    extends Goal {
        private int peekTime;

        ShulkerPeekGoal() {
        }

        @Override
        public boolean canUse() {
            return Shulker.this.getTarget() == null && Shulker.this.random.nextInt(ShulkerPeekGoal.reducedTickDelay(40)) == 0 && Shulker.this.canStayAt(Shulker.this.blockPosition(), Shulker.this.getAttachFace());
        }

        @Override
        public boolean canContinueToUse() {
            return Shulker.this.getTarget() == null && this.peekTime > 0;
        }

        @Override
        public void start() {
            this.peekTime = this.adjustedTickDelay(20 * (1 + Shulker.this.random.nextInt(3)));
            Shulker.this.setRawPeekAmount(30);
        }

        @Override
        public void stop() {
            if (Shulker.this.getTarget() == null) {
                Shulker.this.setRawPeekAmount(0);
            }
        }

        @Override
        public void tick() {
            --this.peekTime;
        }
    }

    private class ShulkerNearestAttackGoal
    extends NearestAttackableTargetGoal<Player> {
        public ShulkerNearestAttackGoal(Shulker entityshulker) {
            super((Mob)entityshulker, Player.class, true);
        }

        @Override
        public boolean canUse() {
            return Shulker.this.level().getDifficulty() == Difficulty.PEACEFUL ? false : super.canUse();
        }

        @Override
        protected AABB getTargetSearchArea(double distance) {
            Direction enumdirection = ((Shulker)this.mob).getAttachFace();
            return enumdirection.getAxis() == Direction.Axis.X ? this.mob.getBoundingBox().inflate(4.0, distance, distance) : (enumdirection.getAxis() == Direction.Axis.Z ? this.mob.getBoundingBox().inflate(distance, distance, 4.0) : this.mob.getBoundingBox().inflate(distance, 4.0, distance));
        }
    }

    private static class ShulkerDefenseAttackGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public ShulkerDefenseAttackGoal(Shulker shulker) {
            super(shulker, LivingEntity.class, 10, true, false, entityliving -> entityliving instanceof Enemy);
        }

        @Override
        public boolean canUse() {
            return this.mob.getTeam() == null ? false : super.canUse();
        }

        @Override
        protected AABB getTargetSearchArea(double distance) {
            Direction enumdirection = ((Shulker)this.mob).getAttachFace();
            return enumdirection.getAxis() == Direction.Axis.X ? this.mob.getBoundingBox().inflate(4.0, distance, distance) : (enumdirection.getAxis() == Direction.Axis.Z ? this.mob.getBoundingBox().inflate(distance, distance, 4.0) : this.mob.getBoundingBox().inflate(distance, 4.0, distance));
        }
    }

    private static class ShulkerBodyRotationControl
    extends BodyRotationControl {
        public ShulkerBodyRotationControl(Mob entity) {
            super(entity);
        }

        @Override
        public void clientTick() {
        }
    }
}

