/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Rotations;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.ItemStack;

public class ArmorStand
extends LivingEntity {
    public static final int WOBBLE_TIME = 5;
    private static final boolean ENABLE_ARMS = true;
    private static final Rotations DEFAULT_HEAD_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_BODY_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFT_ARM_POSE = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations DEFAULT_RIGHT_ARM_POSE = new Rotations(-15.0f, 0.0f, 10.0f);
    private static final Rotations DEFAULT_LEFT_LEG_POSE = new Rotations(-1.0f, 0.0f, -1.0f);
    private static final Rotations DEFAULT_RIGHT_LEG_POSE = new Rotations(1.0f, 0.0f, 1.0f);
    private static final EntityDimensions MARKER_DIMENSIONS = EntityDimensions.fixed(0.0f, 0.0f);
    private static final EntityDimensions BABY_DIMENSIONS = EntityType.ARMOR_STAND.getDimensions().scale(0.5f).withEyeHeight(0.9875f);
    private static final double FEET_OFFSET = 0.1;
    private static final double CHEST_OFFSET = 0.9;
    private static final double LEGS_OFFSET = 0.4;
    private static final double HEAD_OFFSET = 1.6;
    public static final int DISABLE_TAKING_OFFSET = 8;
    public static final int DISABLE_PUTTING_OFFSET = 16;
    public static final int CLIENT_FLAG_SMALL = 1;
    public static final int CLIENT_FLAG_SHOW_ARMS = 4;
    public static final int CLIENT_FLAG_NO_BASEPLATE = 8;
    public static final int CLIENT_FLAG_MARKER = 16;
    public static final EntityDataAccessor<Byte> DATA_CLIENT_FLAGS = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Rotations> DATA_HEAD_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_BODY_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_ARM_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_ARM_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_LEG_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_LEG_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    private static final Predicate<Entity> RIDABLE_MINECARTS = entity -> entity instanceof AbstractMinecart && ((AbstractMinecart)entity).getMinecartType() == AbstractMinecart.Type.RIDEABLE;
    private final NonNullList<net.minecraft.world.item.ItemStack> handItems;
    private final NonNullList<net.minecraft.world.item.ItemStack> armorItems;
    private boolean invisible;
    public long lastHit;
    public int disabledSlots;
    public Rotations headPose;
    public Rotations bodyPose;
    public Rotations leftArmPose;
    public Rotations rightArmPose;
    public Rotations leftLegPose;
    public Rotations rightLegPose;
    public boolean canMove = true;
    public boolean canTick = true;
    public boolean canTickSetByAPI = false;
    private boolean noTickPoseDirty = false;
    private boolean noTickEquipmentDirty = false;

    public ArmorStand(EntityType<? extends ArmorStand> type, Level world) {
        super((EntityType<? extends LivingEntity>)type, world);
        if (world != null) {
            this.canTick = world.paperConfig().entities.armorStands.tick;
        }
        this.handItems = NonNullList.withSize(2, net.minecraft.world.item.ItemStack.EMPTY);
        this.armorItems = NonNullList.withSize(4, net.minecraft.world.item.ItemStack.EMPTY);
        this.headPose = DEFAULT_HEAD_POSE;
        this.bodyPose = DEFAULT_BODY_POSE;
        this.leftArmPose = DEFAULT_LEFT_ARM_POSE;
        this.rightArmPose = DEFAULT_RIGHT_ARM_POSE;
        this.leftLegPose = DEFAULT_LEFT_LEG_POSE;
        this.rightLegPose = DEFAULT_RIGHT_LEG_POSE;
    }

    public ArmorStand(Level world, double x, double y, double z) {
        this((EntityType<? extends ArmorStand>)EntityType.ARMOR_STAND, world);
        this.setPos(x, y, z);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return ArmorStand.createLivingAttributes().add(Attributes.STEP_HEIGHT, 0.0);
    }

    @Override
    public float getBukkitYaw() {
        return this.getYRot();
    }

    @Override
    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    private boolean hasPhysics() {
        return !this.isMarker() && !this.isNoGravity();
    }

    @Override
    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && this.hasPhysics();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CLIENT_FLAGS, (byte)0);
        builder.define(DATA_HEAD_POSE, DEFAULT_HEAD_POSE);
        builder.define(DATA_BODY_POSE, DEFAULT_BODY_POSE);
        builder.define(DATA_LEFT_ARM_POSE, DEFAULT_LEFT_ARM_POSE);
        builder.define(DATA_RIGHT_ARM_POSE, DEFAULT_RIGHT_ARM_POSE);
        builder.define(DATA_LEFT_LEG_POSE, DEFAULT_LEFT_LEG_POSE);
        builder.define(DATA_RIGHT_LEG_POSE, DEFAULT_RIGHT_LEG_POSE);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> getHandSlots() {
        return this.handItems;
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> getArmorSlots() {
        return this.armorItems;
    }

    @Override
    public net.minecraft.world.item.ItemStack getItemBySlot(EquipmentSlot slot) {
        switch (slot.getType()) {
            case HAND: {
                return this.handItems.get(slot.getIndex());
            }
            case HUMANOID_ARMOR: {
                return this.armorItems.get(slot.getIndex());
            }
        }
        return net.minecraft.world.item.ItemStack.EMPTY;
    }

    @Override
    public boolean canUseSlot(EquipmentSlot slot) {
        return slot != EquipmentSlot.BODY;
    }

    @Override
    public void setItemSlot(EquipmentSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EquipmentSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.verifyEquippedItem(itemstack);
        switch (enumitemslot.getType()) {
            case HAND: {
                this.onEquipItem(enumitemslot, this.handItems.set(enumitemslot.getIndex(), itemstack), itemstack, silent);
                break;
            }
            case HUMANOID_ARMOR: {
                this.onEquipItem(enumitemslot, this.armorItems.set(enumitemslot.getIndex(), itemstack), itemstack, silent);
            }
        }
        this.noTickEquipmentDirty = true;
    }

    @Override
    public boolean canTakeItem(net.minecraft.world.item.ItemStack stack) {
        EquipmentSlot enumitemslot = this.getEquipmentSlotForItem(stack);
        return this.getItemBySlot(enumitemslot).isEmpty() && !this.isDisabled(enumitemslot);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        ListTag nbttaglist = new ListTag();
        for (net.minecraft.world.item.ItemStack itemstack : this.armorItems) {
            nbttaglist.add(itemstack.saveOptional(this.registryAccess()));
        }
        nbt.put("ArmorItems", nbttaglist);
        ListTag nbttaglist1 = new ListTag();
        for (net.minecraft.world.item.ItemStack itemstack1 : this.handItems) {
            nbttaglist1.add(itemstack1.saveOptional(this.registryAccess()));
        }
        nbt.put("HandItems", nbttaglist1);
        nbt.putBoolean("Invisible", this.isInvisible());
        nbt.putBoolean("Small", this.isSmall());
        nbt.putBoolean("ShowArms", this.isShowArms());
        nbt.putInt("DisabledSlots", this.disabledSlots);
        nbt.putBoolean("NoBasePlate", this.isNoBasePlate());
        if (this.isMarker()) {
            nbt.putBoolean("Marker", this.isMarker());
        }
        nbt.put("Pose", this.writePose());
        if (this.canTickSetByAPI) {
            nbt.putBoolean("Paper.CanTickOverride", this.canTick);
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        CompoundTag nbttagcompound1;
        int i;
        ListTag nbttaglist;
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("ArmorItems", 9)) {
            nbttaglist = nbt.getList("ArmorItems", 10);
            for (i = 0; i < this.armorItems.size(); ++i) {
                nbttagcompound1 = nbttaglist.getCompound(i);
                this.armorItems.set(i, net.minecraft.world.item.ItemStack.parseOptional(this.registryAccess(), nbttagcompound1));
            }
        }
        if (nbt.contains("HandItems", 9)) {
            nbttaglist = nbt.getList("HandItems", 10);
            for (i = 0; i < this.handItems.size(); ++i) {
                nbttagcompound1 = nbttaglist.getCompound(i);
                this.handItems.set(i, net.minecraft.world.item.ItemStack.parseOptional(this.registryAccess(), nbttagcompound1));
            }
        }
        this.setInvisible(nbt.getBoolean("Invisible"));
        this.setSmall(nbt.getBoolean("Small"));
        this.setShowArms(nbt.getBoolean("ShowArms"));
        this.disabledSlots = nbt.getInt("DisabledSlots");
        this.setNoBasePlate(nbt.getBoolean("NoBasePlate"));
        this.setMarker(nbt.getBoolean("Marker"));
        boolean bl = this.noPhysics = !this.hasPhysics();
        if (nbt.contains("Paper.CanTickOverride")) {
            this.canTick = nbt.getBoolean("Paper.CanTickOverride");
            this.canTickSetByAPI = true;
        }
        CompoundTag nbttagcompound2 = nbt.getCompound("Pose");
        this.readPose(nbttagcompound2);
    }

    private void readPose(CompoundTag nbt) {
        ListTag nbttaglist = nbt.getList("Head", 5);
        this.setHeadPose(nbttaglist.isEmpty() ? DEFAULT_HEAD_POSE : new Rotations(nbttaglist));
        ListTag nbttaglist1 = nbt.getList("Body", 5);
        this.setBodyPose(nbttaglist1.isEmpty() ? DEFAULT_BODY_POSE : new Rotations(nbttaglist1));
        ListTag nbttaglist2 = nbt.getList("LeftArm", 5);
        this.setLeftArmPose(nbttaglist2.isEmpty() ? DEFAULT_LEFT_ARM_POSE : new Rotations(nbttaglist2));
        ListTag nbttaglist3 = nbt.getList("RightArm", 5);
        this.setRightArmPose(nbttaglist3.isEmpty() ? DEFAULT_RIGHT_ARM_POSE : new Rotations(nbttaglist3));
        ListTag nbttaglist4 = nbt.getList("LeftLeg", 5);
        this.setLeftLegPose(nbttaglist4.isEmpty() ? DEFAULT_LEFT_LEG_POSE : new Rotations(nbttaglist4));
        ListTag nbttaglist5 = nbt.getList("RightLeg", 5);
        this.setRightLegPose(nbttaglist5.isEmpty() ? DEFAULT_RIGHT_LEG_POSE : new Rotations(nbttaglist5));
    }

    private CompoundTag writePose() {
        CompoundTag nbttagcompound = new CompoundTag();
        if (!DEFAULT_HEAD_POSE.equals(this.headPose)) {
            nbttagcompound.put("Head", this.headPose.save());
        }
        if (!DEFAULT_BODY_POSE.equals(this.bodyPose)) {
            nbttagcompound.put("Body", this.bodyPose.save());
        }
        if (!DEFAULT_LEFT_ARM_POSE.equals(this.leftArmPose)) {
            nbttagcompound.put("LeftArm", this.leftArmPose.save());
        }
        if (!DEFAULT_RIGHT_ARM_POSE.equals(this.rightArmPose)) {
            nbttagcompound.put("RightArm", this.rightArmPose.save());
        }
        if (!DEFAULT_LEFT_LEG_POSE.equals(this.leftLegPose)) {
            nbttagcompound.put("LeftLeg", this.leftLegPose.save());
        }
        if (!DEFAULT_RIGHT_LEG_POSE.equals(this.rightLegPose)) {
            nbttagcompound.put("RightLeg", this.rightLegPose.save());
        }
        return nbttagcompound;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    @Override
    protected void doPush(Entity entity) {
    }

    @Override
    protected void pushEntities() {
        if (!this.level().paperConfig().entities.armorStands.doCollisionEntityLookups) {
            return;
        }
        List<Entity> list = this.level().getEntities(this, this.getBoundingBox(), RIDABLE_MINECARTS);
        for (Entity entity : list) {
            if (!(this.distanceToSqr(entity) <= 0.2)) continue;
            entity.push(this);
        }
    }

    @Override
    public InteractionResult interactAt(Player player, Vec3 hitPos, InteractionHand hand) {
        net.minecraft.world.item.ItemStack itemstack = player.getItemInHand(hand);
        if (!this.isMarker() && !itemstack.is(Items.NAME_TAG)) {
            if (player.isSpectator()) {
                return InteractionResult.SUCCESS;
            }
            if (player.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
            EquipmentSlot enumitemslot = this.getEquipmentSlotForItem(itemstack);
            if (itemstack.isEmpty()) {
                EquipmentSlot enumitemslot2;
                EquipmentSlot enumitemslot1 = this.getClickedSlot(hitPos);
                EquipmentSlot equipmentSlot = enumitemslot2 = this.isDisabled(enumitemslot1) ? enumitemslot : enumitemslot1;
                if (this.hasItemInSlot(enumitemslot2) && this.swapItem(player, enumitemslot2, itemstack, hand)) {
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (this.isDisabled(enumitemslot)) {
                    return InteractionResult.FAIL;
                }
                if (enumitemslot.getType() == EquipmentSlot.Type.HAND && !this.isShowArms()) {
                    return InteractionResult.FAIL;
                }
                if (this.swapItem(player, enumitemslot, itemstack, hand)) {
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EquipmentSlot getClickedSlot(Vec3 hitPos) {
        EquipmentSlot enumitemslot = EquipmentSlot.MAINHAND;
        boolean flag = this.isSmall();
        double d0 = hitPos.y / (double)(this.getScale() * this.getAgeScale());
        EquipmentSlot enumitemslot1 = EquipmentSlot.FEET;
        if (d0 >= 0.1) {
            double d = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d && this.hasItemInSlot(enumitemslot1)) {
                return EquipmentSlot.FEET;
            }
        }
        double d = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d) {
            double d2 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d2 && this.hasItemInSlot(EquipmentSlot.CHEST)) {
                return EquipmentSlot.CHEST;
            }
        }
        if (d0 >= 0.4) {
            double d3 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d3 && this.hasItemInSlot(EquipmentSlot.LEGS)) {
                return EquipmentSlot.LEGS;
            }
        }
        if (d0 >= 1.6 && this.hasItemInSlot(EquipmentSlot.HEAD)) {
            return EquipmentSlot.HEAD;
        }
        if (this.hasItemInSlot(EquipmentSlot.MAINHAND)) return enumitemslot;
        if (!this.hasItemInSlot(EquipmentSlot.OFFHAND)) return enumitemslot;
        return EquipmentSlot.OFFHAND;
    }

    public boolean isDisabled(EquipmentSlot slot) {
        return (this.disabledSlots & 1 << slot.getFilterFlag()) != 0 || slot.getType() == EquipmentSlot.Type.HAND && !this.isShowArms();
    }

    private boolean swapItem(Player player, EquipmentSlot slot, net.minecraft.world.item.ItemStack stack, InteractionHand hand) {
        net.minecraft.world.item.ItemStack itemstack1 = this.getItemBySlot(slot);
        if (!itemstack1.isEmpty() && (this.disabledSlots & 1 << slot.getFilterFlag() + 8) != 0) {
            return false;
        }
        if (itemstack1.isEmpty() && (this.disabledSlots & 1 << slot.getFilterFlag() + 16) != 0) {
            return false;
        }
        CraftItemStack armorStandItem = CraftItemStack.asCraftMirror(itemstack1);
        CraftItemStack playerHeldItem = CraftItemStack.asCraftMirror(stack);
        org.bukkit.entity.Player player1 = (org.bukkit.entity.Player)player.getBukkitEntity();
        org.bukkit.entity.ArmorStand self = (org.bukkit.entity.ArmorStand)this.getBukkitEntity();
        org.bukkit.inventory.EquipmentSlot slot1 = CraftEquipmentSlot.getSlot(slot);
        org.bukkit.inventory.EquipmentSlot hand1 = CraftEquipmentSlot.getHand(hand);
        PlayerArmorStandManipulateEvent armorStandManipulateEvent = new PlayerArmorStandManipulateEvent(player1, self, (ItemStack)playerHeldItem, (ItemStack)armorStandItem, slot1, hand1);
        this.level().getCraftServer().getPluginManager().callEvent((Event)armorStandManipulateEvent);
        if (armorStandManipulateEvent.isCancelled()) {
            return true;
        }
        if (player.hasInfiniteMaterials() && itemstack1.isEmpty() && !stack.isEmpty()) {
            this.setItemSlot(slot, stack.copyWithCount(1));
            return true;
        }
        if (!stack.isEmpty() && stack.getCount() > 1) {
            if (!itemstack1.isEmpty()) {
                return false;
            }
            this.setItemSlot(slot, stack.split(1));
            return true;
        }
        this.setItemSlot(slot, stack);
        player.setItemInHand(hand, itemstack1);
        return true;
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (this.isRemoved()) {
            return false;
        }
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount)) {
                    return false;
                }
                this.kill(source);
                return false;
            }
            if (!this.isInvulnerableTo(source) && !this.isMarker()) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, true, this.invisible)) {
                    return false;
                }
                if (source.is(DamageTypeTags.IS_EXPLOSION)) {
                    EntityDeathEvent event = this.brokenByAnything(worldserver, source);
                    if (!event.isCancelled()) {
                        this.kill(source, false);
                    }
                    return false;
                }
                if (source.is(DamageTypeTags.IGNITES_ARMOR_STANDS)) {
                    if (this.isOnFire()) {
                        this.causeDamage(worldserver, source, 0.15f);
                    } else {
                        this.igniteForSeconds(5.0f);
                    }
                    return false;
                }
                if (source.is(DamageTypeTags.BURNS_ARMOR_STANDS) && this.getHealth() > 0.5f) {
                    this.causeDamage(worldserver, source, 4.0f);
                    return false;
                }
                boolean flag = source.is(DamageTypeTags.CAN_BREAK_ARMOR_STAND);
                boolean flag1 = source.is(DamageTypeTags.ALWAYS_KILLS_ARMOR_STANDS);
                if (!flag && !flag1) {
                    return false;
                }
                Entity entity = source.getEntity();
                if (entity instanceof Player) {
                    Player entityhuman = (Player)entity;
                    if (!entityhuman.getAbilities().mayBuild) {
                        return false;
                    }
                }
                if (source.isCreativePlayer()) {
                    this.playBrokenSound();
                    this.showBreakingParticles();
                    this.kill(source);
                    return true;
                }
                long i = worldserver.getGameTime();
                if (i - this.lastHit > 5L && !flag1) {
                    worldserver.broadcastEntityEvent(this, (byte)32);
                    this.gameEvent(GameEvent.ENTITY_DAMAGE, source.getEntity());
                    this.lastHit = i;
                } else {
                    EntityDeathEvent event = this.brokenByPlayer(worldserver, source);
                    this.showBreakingParticles();
                    if (!event.isCancelled()) {
                        this.kill(source, false);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void handleEntityEvent(byte status) {
        if (status == 32) {
            if (this.level().isClientSide) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_HIT, this.getSoundSource(), 0.3f, 1.0f, false);
                this.lastHit = this.level().getGameTime();
            }
        } else {
            super.handleEntityEvent(status);
        }
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double distance) {
        double d1 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d1) || d1 == 0.0) {
            d1 = 4.0;
        }
        return distance < (d1 *= 64.0) * d1;
    }

    private void showBreakingParticles() {
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles(new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_PLANKS.defaultBlockState()), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, this.getBbWidth() / 4.0f, this.getBbHeight() / 4.0f, this.getBbWidth() / 4.0f, 0.05);
        }
    }

    private void causeDamage(ServerLevel world, DamageSource damageSource, float amount) {
        float f1 = this.getHealth();
        if ((f1 -= amount) <= 0.5f) {
            EntityDeathEvent event = this.brokenByAnything(world, damageSource);
            if (!event.isCancelled()) {
                this.kill(damageSource, false);
            }
        } else {
            this.setHealth(f1);
            this.gameEvent(GameEvent.ENTITY_DAMAGE, damageSource.getEntity());
        }
    }

    private EntityDeathEvent brokenByPlayer(ServerLevel world, DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemstack = new net.minecraft.world.item.ItemStack(Items.ARMOR_STAND);
        itemstack.set(DataComponents.CUSTOM_NAME, this.getCustomName());
        this.drops.add(new Entity.DefaultDrop(itemstack, stack -> Block.popResource(this.level(), this.blockPosition(), stack)));
        return this.brokenByAnything(world, damageSource);
    }

    private EntityDeathEvent brokenByAnything(ServerLevel world, DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemstack;
        int i;
        this.playBrokenSound();
        for (i = 0; i < this.handItems.size(); ++i) {
            itemstack = this.handItems.get(i);
            if (itemstack.isEmpty()) continue;
            this.drops.add(new Entity.DefaultDrop(itemstack, stack -> Block.popResource(this.level(), this.blockPosition().above(), stack)));
            this.handItems.set(i, net.minecraft.world.item.ItemStack.EMPTY);
        }
        for (i = 0; i < this.armorItems.size(); ++i) {
            itemstack = this.armorItems.get(i);
            if (itemstack.isEmpty()) continue;
            this.drops.add(new Entity.DefaultDrop(itemstack, stack -> Block.popResource(this.level(), this.blockPosition().above(), stack)));
            this.armorItems.set(i, net.minecraft.world.item.ItemStack.EMPTY);
        }
        return this.dropAllDeathLoot(world, damageSource);
    }

    private void playBrokenSound() {
        this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }

    @Override
    protected float tickHeadTurn(float bodyRotation, float headRotation) {
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
        return 0.0f;
    }

    @Override
    public void travel(Vec3 movementInput) {
        if (this.hasPhysics()) {
            super.travel(movementInput);
        }
    }

    @Override
    public void setYBodyRot(float bodyYaw) {
        this.yBodyRotO = this.yRotO = bodyYaw;
        this.yHeadRotO = this.yHeadRot = bodyYaw;
    }

    @Override
    public void setYHeadRot(float headYaw) {
        this.yBodyRotO = this.yRotO = headYaw;
        this.yHeadRotO = this.yHeadRot = headYaw;
    }

    @Override
    public void tick() {
        if (!this.canTick) {
            if (this.noTickPoseDirty) {
                this.noTickPoseDirty = false;
                this.updatePose();
            }
            if (this.noTickEquipmentDirty) {
                this.noTickEquipmentDirty = false;
                this.detectEquipmentUpdatesPublic();
            }
            return;
        }
        super.tick();
        this.updatePose();
    }

    public void updatePose() {
        Rotations vector3f5;
        Rotations vector3f4;
        Rotations vector3f3;
        Rotations vector3f2;
        Rotations vector3f1;
        Rotations vector3f = this.entityData.get(DATA_HEAD_POSE);
        if (!this.headPose.equals(vector3f)) {
            this.setHeadPose(vector3f);
        }
        if (!this.bodyPose.equals(vector3f1 = this.entityData.get(DATA_BODY_POSE))) {
            this.setBodyPose(vector3f1);
        }
        if (!this.leftArmPose.equals(vector3f2 = this.entityData.get(DATA_LEFT_ARM_POSE))) {
            this.setLeftArmPose(vector3f2);
        }
        if (!this.rightArmPose.equals(vector3f3 = this.entityData.get(DATA_RIGHT_ARM_POSE))) {
            this.setRightArmPose(vector3f3);
        }
        if (!this.leftLegPose.equals(vector3f4 = this.entityData.get(DATA_LEFT_LEG_POSE))) {
            this.setLeftLegPose(vector3f4);
        }
        if (!this.rightLegPose.equals(vector3f5 = this.entityData.get(DATA_RIGHT_LEG_POSE))) {
            this.setRightLegPose(vector3f5);
        }
    }

    @Override
    protected void updateInvisibilityStatus() {
        this.setInvisible(this.invisible);
    }

    @Override
    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
        super.setInvisible(invisible);
    }

    @Override
    public boolean isBaby() {
        return this.isSmall();
    }

    @Override
    public boolean shouldDropExperience() {
        return true;
    }

    @Override
    public void kill() {
        this.kill(null);
    }

    public void kill(DamageSource damageSource) {
        this.kill(damageSource, true);
    }

    public void kill(DamageSource damageSource, boolean callEvent) {
        EntityDeathEvent event;
        if (callEvent && (event = CraftEventFactory.callEntityDeathEvent(this, damageSource == null ? this.damageSources().genericKill() : damageSource, this.drops)).isCancelled()) {
            return;
        }
        this.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
        this.gameEvent(GameEvent.ENTITY_DIE);
    }

    @Override
    public boolean ignoreExplosion(Explosion explosion) {
        return this.isInvisible();
    }

    @Override
    public PushReaction getPistonPushReaction() {
        return this.isMarker() ? PushReaction.IGNORE : super.getPistonPushReaction();
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return this.isMarker();
    }

    public void setSmall(boolean small) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 1, small));
    }

    public boolean isSmall() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 1) != 0;
    }

    public void setShowArms(boolean showArms) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 4, showArms));
    }

    public boolean isShowArms() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 4) != 0;
    }

    public void setNoBasePlate(boolean hideBasePlate) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 8, hideBasePlate));
    }

    public boolean isNoBasePlate() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 8) != 0;
    }

    public void setMarker(boolean marker) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 16, marker));
    }

    public boolean isMarker() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 0x10) != 0;
    }

    private byte setBit(byte value, int bitField, boolean set) {
        value = set ? (byte)(value | bitField) : (byte)(value & ~bitField);
        return value;
    }

    public void setHeadPose(Rotations angle) {
        this.headPose = angle;
        this.entityData.set(DATA_HEAD_POSE, angle);
        this.noTickPoseDirty = true;
    }

    public void setBodyPose(Rotations angle) {
        this.bodyPose = angle;
        this.entityData.set(DATA_BODY_POSE, angle);
        this.noTickPoseDirty = true;
    }

    public void setLeftArmPose(Rotations angle) {
        this.leftArmPose = angle;
        this.entityData.set(DATA_LEFT_ARM_POSE, angle);
        this.noTickPoseDirty = true;
    }

    public void setRightArmPose(Rotations angle) {
        this.rightArmPose = angle;
        this.entityData.set(DATA_RIGHT_ARM_POSE, angle);
        this.noTickPoseDirty = true;
    }

    public void setLeftLegPose(Rotations angle) {
        this.leftLegPose = angle;
        this.entityData.set(DATA_LEFT_LEG_POSE, angle);
        this.noTickPoseDirty = true;
    }

    public void setRightLegPose(Rotations angle) {
        this.rightLegPose = angle;
        this.entityData.set(DATA_RIGHT_LEG_POSE, angle);
        this.noTickPoseDirty = true;
    }

    public Rotations getHeadPose() {
        return this.headPose;
    }

    public Rotations getBodyPose() {
        return this.bodyPose;
    }

    public Rotations getLeftArmPose() {
        return this.leftArmPose;
    }

    public Rotations getRightArmPose() {
        return this.rightArmPose;
    }

    public Rotations getLeftLegPose() {
        return this.leftLegPose;
    }

    public Rotations getRightLegPose() {
        return this.rightLegPose;
    }

    @Override
    public boolean isPickable() {
        return super.isPickable() && !this.isMarker();
    }

    @Override
    public boolean skipAttackInteraction(Entity attacker) {
        return attacker instanceof Player && !this.level().mayInteract((Player)attacker, this.blockPosition());
    }

    @Override
    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    @Override
    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.ARMOR_STAND_FALL, SoundEvents.ARMOR_STAND_FALL);
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.ARMOR_STAND_HIT;
    }

    @Override
    @Nullable
    public SoundEvent getDeathSound() {
        return SoundEvents.ARMOR_STAND_BREAK;
    }

    @Override
    public void thunderHit(ServerLevel world, LightningBolt lightning) {
    }

    @Override
    public boolean isAffectedByPotions() {
        return false;
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (DATA_CLIENT_FLAGS.equals(data)) {
            this.refreshDimensions();
            this.blocksBuilding = !this.isMarker();
        }
        super.onSyncedDataUpdated(data);
    }

    @Override
    public boolean attackable() {
        return false;
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.getDimensionsMarker(this.isMarker());
    }

    private EntityDimensions getDimensionsMarker(boolean marker) {
        return marker ? MARKER_DIMENSIONS : (this.isBaby() ? BABY_DIMENSIONS : this.getType().getDimensions());
    }

    @Override
    public Vec3 getLightProbePosition(float tickDelta) {
        if (this.isMarker()) {
            AABB axisalignedbb = this.getDimensionsMarker(false).makeBoundingBox(this.position());
            BlockPos blockposition = this.blockPosition();
            int i = Integer.MIN_VALUE;
            for (BlockPos blockposition1 : BlockPos.betweenClosed(BlockPos.containing(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ), BlockPos.containing(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ))) {
                int j = Math.max(this.level().getBrightness(LightLayer.BLOCK, blockposition1), this.level().getBrightness(LightLayer.SKY, blockposition1));
                if (j == 15) {
                    return Vec3.atCenterOf(blockposition1);
                }
                if (j <= i) continue;
                i = j;
                blockposition = blockposition1.immutable();
            }
            return Vec3.atCenterOf(blockposition);
        }
        return super.getLightProbePosition(tickDelta);
    }

    @Override
    public net.minecraft.world.item.ItemStack getPickResult() {
        return new net.minecraft.world.item.ItemStack(Items.ARMOR_STAND);
    }

    @Override
    public boolean canBeSeenByAnyone() {
        return !this.isInvisible() && !this.isMarker();
    }

    @Override
    public void move(MoverType type, Vec3 movement) {
        if (this.canMove) {
            super.move(type, movement);
        }
    }
}

