/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerBucketEntityEvent;

public interface Bucketable {
    public boolean fromBucket();

    public void setFromBucket(boolean var1);

    public void saveToBucketTag(ItemStack var1);

    public void loadFromBucketTag(CompoundTag var1);

    public ItemStack getBucketItemStack();

    public SoundEvent getPickupSound();

    @Deprecated
    public static void saveDefaultDataToBucketTag(Mob entity, ItemStack stack) {
        stack.set(DataComponents.CUSTOM_NAME, entity.getCustomName());
        CustomData.update(DataComponents.BUCKET_ENTITY_DATA, stack, nbttagcompound -> {
            if (entity.isNoAi()) {
                nbttagcompound.putBoolean("NoAI", entity.isNoAi());
            }
            if (entity.isSilent()) {
                nbttagcompound.putBoolean("Silent", entity.isSilent());
            }
            if (entity.isNoGravity()) {
                nbttagcompound.putBoolean("NoGravity", entity.isNoGravity());
            }
            if (entity.hasGlowingTag()) {
                nbttagcompound.putBoolean("Glowing", entity.hasGlowingTag());
            }
            if (entity.isInvulnerable()) {
                nbttagcompound.putBoolean("Invulnerable", entity.isInvulnerable());
            }
            nbttagcompound.putFloat("Health", entity.getHealth());
        });
    }

    @Deprecated
    public static void loadDefaultDataFromBucketTag(Mob entity, CompoundTag nbt) {
        if (nbt.contains("NoAI")) {
            entity.setNoAi(nbt.getBoolean("NoAI"));
        }
        if (nbt.contains("Silent")) {
            entity.setSilent(nbt.getBoolean("Silent"));
        }
        if (nbt.contains("NoGravity")) {
            entity.setNoGravity(nbt.getBoolean("NoGravity"));
        }
        if (nbt.contains("Glowing")) {
            entity.setGlowingTag(nbt.getBoolean("Glowing"));
        }
        if (nbt.contains("Invulnerable")) {
            entity.setInvulnerable(nbt.getBoolean("Invulnerable"));
        }
        if (nbt.contains("Health", 99)) {
            entity.setHealth(nbt.getFloat("Health"));
        }
    }

    public static <T extends LivingEntity> Optional<InteractionResult> bucketMobPickup(Player player, InteractionHand hand, T entity) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.getItem() == Items.WATER_BUCKET && entity.isAlive()) {
            ItemStack itemstack1 = ((Bucketable)((Object)entity)).getBucketItemStack();
            ((Bucketable)((Object)entity)).saveToBucketTag(itemstack1);
            PlayerBucketEntityEvent playerBucketFishEvent = CraftEventFactory.callPlayerFishBucketEvent(entity, player, itemstack, itemstack1, hand);
            itemstack1 = CraftItemStack.asNMSCopy(playerBucketFishEvent.getEntityBucket());
            if (playerBucketFishEvent.isCancelled()) {
                ((ServerPlayer)player).containerMenu.sendAllDataToRemote();
                entity.resendPossiblyDesyncedEntityData((ServerPlayer)player);
                return Optional.of(InteractionResult.FAIL);
            }
            entity.playSound(((Bucketable)((Object)entity)).getPickupSound(), 1.0f, 1.0f);
            ItemStack itemstack2 = ItemUtils.createFilledResult(itemstack, player, itemstack1, false);
            player.setItemInHand(hand, itemstack2);
            Level world = entity.level();
            if (!world.isClientSide) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, itemstack1);
            }
            entity.discard(EntityRemoveEvent.Cause.PICKUP);
            return Optional.of(InteractionResult.sidedSuccess(world.isClientSide));
        }
        return Optional.empty();
    }
}

