/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import ca.spottedleaf.moonrise.common.misc.Delayed26WayDistancePropagator3D;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.io.RegionFileIOThread;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.ChunkSystemPoiManager;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.PoiChunk;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.util.TickThread;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.SectionTracker;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SectionStorage;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;

public class PoiManager
extends SectionStorage<PoiSection>
implements ChunkSystemPoiManager {
    public static final int MAX_VILLAGE_DISTANCE = 6;
    public static final int VILLAGE_SECTION_SIZE = 1;
    private final DistanceTracker distanceTracker;
    private final LongSet loadedChunks = new LongOpenHashSet();
    private final ServerLevel world;
    private final Delayed26WayDistancePropagator3D villageDistanceTracker = new Delayed26WayDistancePropagator3D();
    private static final int POI_DATA_SOURCE = 7;

    private static int convertBetweenLevels(int level) {
        return 7 - level;
    }

    private void updateDistanceTracking(long section) {
        if (this.isVillageCenter(section)) {
            this.villageDistanceTracker.setSource(section, 7);
        } else {
            this.villageDistanceTracker.removeSource(section);
        }
    }

    @Override
    public Optional<PoiSection> get(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread(this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        ChunkHolderManager manager = this.world.moonrise$getChunkTaskScheduler().chunkHolderManager;
        PoiChunk ret = manager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
        return ret == null ? Optional.empty() : ret.getSectionForVanilla(chunkY);
    }

    @Override
    public Optional<PoiSection> getOrLoad(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread(this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        ChunkHolderManager manager = this.world.moonrise$getChunkTaskScheduler().chunkHolderManager;
        if (chunkY >= WorldUtil.getMinSection(this.world) && chunkY <= WorldUtil.getMaxSection(this.world)) {
            PoiChunk ret = manager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
            if (ret != null) {
                return ret.getSectionForVanilla(chunkY);
            }
            return manager.loadPoiChunk(chunkX, chunkZ).getSectionForVanilla(chunkY);
        }
        return Optional.empty();
    }

    @Override
    protected PoiSection getOrCreate(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread(this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        ChunkHolderManager manager = this.world.moonrise$getChunkTaskScheduler().chunkHolderManager;
        PoiChunk ret = manager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
        if (ret != null) {
            return ret.getOrCreateSection(chunkY);
        }
        return manager.loadPoiChunk(chunkX, chunkZ).getOrCreateSection(chunkY);
    }

    @Override
    public final ServerLevel moonrise$getWorld() {
        return this.world;
    }

    @Override
    public final void moonrise$onUnload(long coordinate) {
        int chunkX = CoordinateUtils.getChunkX(coordinate);
        int chunkZ = CoordinateUtils.getChunkZ(coordinate);
        TickThread.ensureTickThread(this.world, chunkX, chunkZ, "Unloading poi chunk off-main");
        for (int section = this.levelHeightAccessor.getMinSection(); section < this.levelHeightAccessor.getMaxSection(); ++section) {
            long sectionPos = SectionPos.asLong(chunkX, section, chunkZ);
            this.updateDistanceTracking(sectionPos);
        }
    }

    @Override
    public final void moonrise$loadInPoiChunk(PoiChunk poiChunk) {
        int chunkX = poiChunk.chunkX;
        int chunkZ = poiChunk.chunkZ;
        TickThread.ensureTickThread(this.world, chunkX, chunkZ, "Loading poi chunk off-main");
        for (int sectionY = this.levelHeightAccessor.getMinSection(); sectionY < this.levelHeightAccessor.getMaxSection(); ++sectionY) {
            PoiSection section = poiChunk.getSection(sectionY);
            if (section == null || section.moonrise$isEmpty()) continue;
            this.onSectionLoad(SectionPos.asLong(chunkX, sectionY, chunkZ));
        }
    }

    @Override
    public final void moonrise$checkConsistency(ChunkAccess chunk) {
        int chunkX = chunk.getPos().x;
        int chunkZ = chunk.getPos().z;
        int minY = WorldUtil.getMinSection(chunk);
        int maxY = WorldUtil.getMaxSection(chunk);
        LevelChunkSection[] sections = chunk.getSections();
        for (int section = minY; section <= maxY; ++section) {
            this.checkConsistencyWithBlocks(SectionPos.of(chunkX, section, chunkZ), sections[section - minY]);
        }
    }

    @Override
    public final void moonrise$close() throws IOException {
    }

    @Override
    public final CompoundTag moonrise$read(int chunkX, int chunkZ) throws IOException {
        if (!RegionFileIOThread.isRegionFileThread()) {
            return RegionFileIOThread.loadData(this.world, chunkX, chunkZ, RegionFileIOThread.RegionFileType.POI_DATA, RegionFileIOThread.getIOBlockingPriorityForCurrentThread());
        }
        return this.moonrise$getRegionStorage().read(new ChunkPos(chunkX, chunkZ));
    }

    @Override
    public final void moonrise$write(int chunkX, int chunkZ, CompoundTag data) throws IOException {
        if (!RegionFileIOThread.isRegionFileThread()) {
            RegionFileIOThread.scheduleSave(this.world, chunkX, chunkZ, data, RegionFileIOThread.RegionFileType.POI_DATA);
            return;
        }
        this.moonrise$getRegionStorage().write(new ChunkPos(chunkX, chunkZ), data);
    }

    public PoiManager(RegionStorageInfo storageKey, Path directory, DataFixer dataFixer, boolean dsync, RegistryAccess registryManager, ChunkIOErrorReporter errorHandler, LevelHeightAccessor world) {
        super(new SimpleRegionStorage(storageKey, directory, dataFixer, dsync, DataFixTypes.POI_CHUNK), PoiSection::codec, PoiSection::new, registryManager, errorHandler, world);
        this.distanceTracker = new DistanceTracker();
        this.world = (ServerLevel)world;
    }

    public void add(BlockPos pos, Holder<PoiType> type) {
        this.getOrCreate(SectionPos.asLong(pos)).add(pos, type);
    }

    public void remove(BlockPos pos) {
        this.getOrLoad(SectionPos.asLong(pos)).ifPresent(poiSet -> poiSet.remove(pos));
    }

    public long getCountInRange(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int radius, Occupancy occupationStatus) {
        return this.getInRange(typePredicate, pos, radius, occupationStatus).count();
    }

    public boolean existsAtPosition(ResourceKey<PoiType> type, BlockPos pos) {
        return this.exists(pos, entry -> entry.is(type));
    }

    public Stream<PoiRecord> getInSquare(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int radius, Occupancy occupationStatus) {
        int i = Math.floorDiv(radius, 16) + 1;
        return ChunkPos.rangeClosed(new ChunkPos(pos), i).flatMap(chunkPos -> this.getInChunk(typePredicate, (ChunkPos)chunkPos, occupationStatus)).filter(poi -> {
            BlockPos blockPos2 = poi.getPos();
            return Math.abs(blockPos2.getX() - pos.getX()) <= radius && Math.abs(blockPos2.getZ() - pos.getZ()) <= radius;
        });
    }

    public Stream<PoiRecord> getInRange(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int radius, Occupancy occupationStatus) {
        int i = radius * radius;
        return this.getInSquare(typePredicate, pos, radius, occupationStatus).filter(poi -> poi.getPos().distSqr(pos) <= (double)i);
    }

    @VisibleForDebug
    public Stream<PoiRecord> getInChunk(Predicate<Holder<PoiType>> typePredicate, ChunkPos chunkPos, Occupancy occupationStatus) {
        return IntStream.range(this.levelHeightAccessor.getMinSection(), this.levelHeightAccessor.getMaxSection()).boxed().map(integer -> this.getOrLoad(SectionPos.of(chunkPos, integer).asLong())).filter(Optional::isPresent).flatMap(optional -> ((PoiSection)optional.get()).getRecords(typePredicate, occupationStatus));
    }

    public Stream<BlockPos> findAll(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, Occupancy occupationStatus) {
        return this.getInRange(typePredicate, pos, radius, occupationStatus).map(PoiRecord::getPos).filter(posPredicate);
    }

    public Stream<Pair<Holder<PoiType>, BlockPos>> findAllWithType(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, Occupancy occupationStatus) {
        return this.getInRange(typePredicate, pos, radius, occupationStatus).filter(poi -> posPredicate.test(poi.getPos())).map(poi -> Pair.of(poi.getPoiType(), (Object)poi.getPos()));
    }

    public Stream<Pair<Holder<PoiType>, BlockPos>> findAllClosestFirstWithType(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, Occupancy occupationStatus) {
        return this.findAllWithType(typePredicate, posPredicate, pos, radius, occupationStatus).sorted(Comparator.comparingDouble(pair -> ((BlockPos)pair.getSecond()).distSqr(pos)));
    }

    public Optional<BlockPos> find(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, Occupancy occupationStatus) {
        return this.findAll(typePredicate, posPredicate, pos, radius, occupationStatus).findFirst();
    }

    public Optional<BlockPos> findClosest(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int radius, Occupancy occupationStatus) {
        return this.getInRange(typePredicate, pos, radius, occupationStatus).map(PoiRecord::getPos).min(Comparator.comparingDouble(blockPos2 -> blockPos2.distSqr(pos)));
    }

    public Optional<Pair<Holder<PoiType>, BlockPos>> findClosestWithType(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int radius, Occupancy occupationStatus) {
        return this.getInRange(typePredicate, pos, radius, occupationStatus).min(Comparator.comparingDouble(poi -> poi.getPos().distSqr(pos))).map(poi -> Pair.of(poi.getPoiType(), (Object)poi.getPos()));
    }

    public Optional<BlockPos> findClosest(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, Occupancy occupationStatus) {
        return this.getInRange(typePredicate, pos, radius, occupationStatus).map(PoiRecord::getPos).filter(posPredicate).min(Comparator.comparingDouble(blockPos2 -> blockPos2.distSqr(pos)));
    }

    public Optional<BlockPos> take(Predicate<Holder<PoiType>> typePredicate, BiPredicate<Holder<PoiType>, BlockPos> biPredicate, BlockPos pos, int radius) {
        return this.getInRange(typePredicate, pos, radius, Occupancy.HAS_SPACE).filter(poi -> biPredicate.test(poi.getPoiType(), poi.getPos())).findFirst().map(poi -> {
            poi.acquireTicket();
            return poi.getPos();
        });
    }

    public Optional<BlockPos> getRandom(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> positionPredicate, Occupancy occupationStatus, BlockPos pos, int radius, RandomSource random) {
        List<PoiRecord> list = Util.toShuffledList(this.getInRange(typePredicate, pos, radius, occupationStatus), random);
        return list.stream().filter(poi -> positionPredicate.test(poi.getPos())).findFirst().map(PoiRecord::getPos);
    }

    public boolean release(BlockPos pos) {
        return this.getOrLoad(SectionPos.asLong(pos)).map(poiSet -> poiSet.release(pos)).orElseThrow(() -> Util.pauseInIde(new IllegalStateException("POI never registered at " + String.valueOf(pos))));
    }

    public boolean exists(BlockPos pos, Predicate<Holder<PoiType>> predicate) {
        return this.getOrLoad(SectionPos.asLong(pos)).map(poiSet -> poiSet.exists(pos, predicate)).orElse(false);
    }

    public Optional<Holder<PoiType>> getType(BlockPos pos) {
        return this.getOrLoad(SectionPos.asLong(pos)).flatMap(poiSet -> poiSet.getType(pos));
    }

    @Deprecated
    @VisibleForDebug
    public int getFreeTickets(BlockPos pos) {
        return this.getOrLoad(SectionPos.asLong(pos)).map(poiSet -> poiSet.getFreeTickets(pos)).orElse(0);
    }

    public int sectionsToVillage(SectionPos pos) {
        this.villageDistanceTracker.propagateUpdates();
        return PoiManager.convertBetweenLevels(this.villageDistanceTracker.getLevel(CoordinateUtils.getChunkSectionKey(pos)));
    }

    boolean isVillageCenter(long pos) {
        Optional<PoiSection> optional = this.get(pos);
        return optional != null && optional.map(poiSet -> poiSet.getRecords(entry -> entry.is(PoiTypeTags.VILLAGE), Occupancy.IS_OCCUPIED).findAny().isPresent()).orElse(false) != false;
    }

    @Override
    public void tick(BooleanSupplier shouldKeepTicking) {
        this.villageDistanceTracker.propagateUpdates();
    }

    @Override
    public void setDirty(long pos) {
        int chunkZ;
        ChunkHolderManager manager = this.world.moonrise$getChunkTaskScheduler().chunkHolderManager;
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        PoiChunk chunk = manager.getPoiChunkIfLoaded(chunkX, chunkZ = CoordinateUtils.getChunkSectionZ(pos), false);
        if (chunk != null) {
            chunk.setDirty(true);
        }
        this.updateDistanceTracking(pos);
    }

    @Override
    protected void onSectionLoad(long pos) {
        this.updateDistanceTracking(pos);
    }

    public void checkConsistencyWithBlocks(SectionPos sectionPos, LevelChunkSection chunkSection) {
        Util.ifElse(this.getOrLoad(sectionPos.asLong()), poiSet -> poiSet.refresh(populator -> {
            if (PoiManager.mayHavePoi(chunkSection)) {
                this.updateFromSection(chunkSection, sectionPos, (BiConsumer<BlockPos, Holder<PoiType>>)populator);
            }
        }), () -> {
            if (PoiManager.mayHavePoi(chunkSection)) {
                PoiSection poiSection = this.getOrCreate(sectionPos.asLong());
                this.updateFromSection(chunkSection, sectionPos, poiSection::add);
            }
        });
    }

    private static boolean mayHavePoi(LevelChunkSection chunkSection) {
        return chunkSection.maybeHas(PoiTypes::hasPoi);
    }

    private void updateFromSection(LevelChunkSection chunkSection, SectionPos sectionPos, BiConsumer<BlockPos, Holder<PoiType>> populator) {
        sectionPos.blocksInside().forEach(pos -> {
            BlockState blockState = chunkSection.getBlockState(SectionPos.sectionRelative(pos.getX()), SectionPos.sectionRelative(pos.getY()), SectionPos.sectionRelative(pos.getZ()));
            PoiTypes.forState(blockState).ifPresent(poiType -> populator.accept((BlockPos)pos, (Holder<PoiType>)poiType));
        });
    }

    public void ensureLoadedAndValid(LevelReader world, BlockPos pos, int radius) {
        SectionPos.aroundChunk(new ChunkPos(pos), Math.floorDiv(radius, 16), this.levelHeightAccessor.getMinSection(), this.levelHeightAccessor.getMaxSection()).map(sectionPos -> Pair.of((Object)sectionPos, this.getOrLoad(sectionPos.asLong()))).filter(pair -> ((Optional)pair.getSecond()).map(PoiSection::isValid).orElse(false) == false).map(pair -> ((SectionPos)pair.getFirst()).chunk()).forEach(chunkPos -> world.getChunk(chunkPos.x, chunkPos.z, ChunkStatus.EMPTY));
    }

    final class DistanceTracker
    extends SectionTracker {
        private final Long2ByteMap levels;

        protected DistanceTracker() {
            super(7, 16, 256);
            this.levels = new Long2ByteOpenHashMap();
            this.levels.defaultReturnValue((byte)7);
        }

        @Override
        protected int getLevelFromSource(long id) {
            return PoiManager.this.isVillageCenter(id) ? 0 : 7;
        }

        @Override
        protected int getLevel(long id) {
            return this.levels.get(id);
        }

        @Override
        protected void setLevel(long id, int level) {
            if (level > 6) {
                this.levels.remove(id);
            } else {
                this.levels.put(id, (byte)level);
            }
        }

        public void runAllUpdates() {
            super.runUpdates(Integer.MAX_VALUE);
        }
    }

    public static enum Occupancy {
        HAS_SPACE(PoiRecord::hasSpace),
        IS_OCCUPIED(PoiRecord::isOccupied),
        ANY(poi -> true);

        private final Predicate<? super PoiRecord> test;

        private Occupancy(Predicate<? super PoiRecord> predicate) {
            this.test = predicate;
        }

        public Predicate<? super PoiRecord> getTest() {
            return this.test;
        }
    }
}

