/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.phys.Vec3;

public class LandRandomPos {
    @Nullable
    public static Vec3 getPos(PathfinderMob entity, int horizontalRange, int verticalRange) {
        return LandRandomPos.getPos(entity, horizontalRange, verticalRange, entity::getWalkTargetValue);
    }

    @Nullable
    public static Vec3 getPos(PathfinderMob entity, int horizontalRange, int verticalRange, ToDoubleFunction<BlockPos> scorer) {
        boolean bl = GoalUtils.mobRestricted(entity, horizontalRange);
        return RandomPos.generateRandomPos(() -> {
            BlockPos blockPos = RandomPos.generateRandomDirection(entity.getRandom(), horizontalRange, verticalRange);
            BlockPos blockPos2 = LandRandomPos.generateRandomPosTowardDirection(entity, horizontalRange, bl, blockPos);
            if (blockPos2 == null) {
                return null;
            }
            return LandRandomPos.movePosUpOutOfSolid(entity, blockPos2);
        }, scorer);
    }

    @Nullable
    public static Vec3 getPosTowards(PathfinderMob entity, int horizontalRange, int verticalRange, Vec3 end) {
        Vec3 vec3 = end.subtract(entity.getX(), entity.getY(), entity.getZ());
        boolean bl = GoalUtils.mobRestricted(entity, horizontalRange);
        return LandRandomPos.getPosInDirection(entity, horizontalRange, verticalRange, vec3, bl);
    }

    @Nullable
    public static Vec3 getPosAway(PathfinderMob entity, int horizontalRange, int verticalRange, Vec3 start) {
        Vec3 vec3 = entity.position().subtract(start);
        boolean bl = GoalUtils.mobRestricted(entity, horizontalRange);
        return LandRandomPos.getPosInDirection(entity, horizontalRange, verticalRange, vec3, bl);
    }

    @Nullable
    private static Vec3 getPosInDirection(PathfinderMob entity, int horizontalRange, int verticalRange, Vec3 direction, boolean posTargetInRange) {
        return RandomPos.generateRandomPos(entity, () -> {
            BlockPos blockPos = RandomPos.generateRandomDirectionWithinRadians(entity.getRandom(), horizontalRange, verticalRange, 0, vec3.x, vec3.z, 1.5707963705062866);
            if (blockPos == null) {
                return null;
            }
            BlockPos blockPos2 = LandRandomPos.generateRandomPosTowardDirection(entity, horizontalRange, posTargetInRange, blockPos);
            if (blockPos2 == null) {
                return null;
            }
            return LandRandomPos.movePosUpOutOfSolid(entity, blockPos2);
        });
    }

    @Nullable
    public static BlockPos movePosUpOutOfSolid(PathfinderMob entity, BlockPos pos) {
        if (GoalUtils.isWater(entity, pos = RandomPos.moveUpOutOfSolid(pos, entity.level().getMaxBuildHeight(), currentPos -> GoalUtils.isSolid(entity, currentPos))) || GoalUtils.hasMalus(entity, pos)) {
            return null;
        }
        return pos;
    }

    @Nullable
    public static BlockPos generateRandomPosTowardDirection(PathfinderMob entity, int horizontalRange, boolean posTargetInRange, BlockPos relativeInRangePos) {
        BlockPos blockPos = RandomPos.generateRandomPosTowardDirection(entity, horizontalRange, entity.getRandom(), relativeInRangePos);
        if (GoalUtils.isOutsideLimits(blockPos, entity) || GoalUtils.isRestricted(posTargetInRange, entity, blockPos) || GoalUtils.isNotStable(entity.getNavigation(), blockPos)) {
            return null;
        }
        return blockPos;
    }
}

