/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.navigation;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;

public class AmphibiousPathNavigation
extends PathNavigation {
    public AmphibiousPathNavigation(Mob mob, Level world) {
        super(mob, world);
    }

    @Override
    @Override
    protected PathFinder createPathFinder(int range) {
        this.nodeEvaluator = new AmphibiousNodeEvaluator(false);
        this.nodeEvaluator.setCanPassDoors(true);
        return new PathFinder(this.nodeEvaluator, range);
    }

    @Override
    @Override
    protected boolean canUpdatePath() {
        return true;
    }

    @Override
    @Override
    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), this.mob.getY(0.5), this.mob.getZ());
    }

    @Override
    @Override
    protected double getGroundY(Vec3 pos) {
        return pos.y;
    }

    @Override
    @Override
    protected boolean canMoveDirectly(Vec3 origin, Vec3 target) {
        if (this.mob.isInLiquid()) {
            return AmphibiousPathNavigation.isClearForMovementBetween(this.mob, origin, target, false);
        }
        return false;
    }

    @Override
    @Override
    public boolean isStableDestination(BlockPos pos) {
        return !this.level.getBlockState(pos.below()).isAir();
    }

    @Override
    @Override
    public void setCanFloat(boolean canSwim) {
    }
}

