/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import com.destroystokyo.paper.entity.ai.PaperVanillaGoal;
import com.destroystokyo.paper.util.set.OptimizedSmallEnumSet;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import org.bukkit.entity.Mob;

public abstract class Goal {
    private final EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
    private final OptimizedSmallEnumSet<Flag> goalTypes = new OptimizedSmallEnumSet<Flag>(Flag.class);
    private PaperVanillaGoal<?> vanillaGoal;

    public Goal() {
        if (this.goalTypes.size() == 0) {
            this.goalTypes.add(Flag.UNKNOWN_BEHAVIOR);
        }
    }

    public abstract boolean canUse();

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public boolean isInterruptable() {
        return true;
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean requiresUpdateEveryTick() {
        return false;
    }

    public void tick() {
    }

    public void setFlags(EnumSet<Flag> controls) {
        this.goalTypes.clear();
        this.goalTypes.addAll(controls);
        if (this.goalTypes.size() == 0) {
            this.goalTypes.add(Flag.UNKNOWN_BEHAVIOR);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public OptimizedSmallEnumSet<Flag> getFlags() {
        return this.goalTypes;
    }

    protected int adjustedTickDelay(int ticks) {
        return this.requiresUpdateEveryTick() ? ticks : Goal.reducedTickDelay(ticks);
    }

    protected static int reducedTickDelay(int serverTicks) {
        return Mth.positiveCeilDiv(serverTicks, 2);
    }

    public <T extends Mob> com.destroystokyo.paper.entity.ai.Goal<T> asPaperVanillaGoal() {
        if (this.vanillaGoal == null) {
            this.vanillaGoal = new PaperVanillaGoal(this);
        }
        return this.vanillaGoal;
    }

    public static enum Flag {
        UNKNOWN_BEHAVIOR,
        MOVE,
        LOOK,
        JUMP,
        TARGET;

    }
}

