/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;

public class ClimbOnTopOfPowderSnowGoal
extends Goal {
    private final Mob mob;
    private final Level level;

    public ClimbOnTopOfPowderSnowGoal(Mob entity, Level world) {
        this.mob = entity;
        this.level = world;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP));
    }

    @Override
    @Override
    public boolean canUse() {
        boolean bl;
        boolean bl2 = bl = this.mob.wasInPowderSnow || this.mob.isInPowderSnow;
        if (!bl || !this.mob.getType().is(EntityTypeTags.POWDER_SNOW_WALKABLE_MOBS)) {
            return false;
        }
        BlockPos blockPos = this.mob.blockPosition().above();
        BlockState blockState = this.level.getBlockState(blockPos);
        return blockState.is(Blocks.POWDER_SNOW) || blockState.getCollisionShape(this.level, blockPos) == Shapes.empty();
    }

    @Override
    @Override
    public boolean requiresUpdateEveryTick() {
        return true;
    }

    @Override
    @Override
    public void tick() {
        this.mob.getJumpControl().jump();
    }
}

